/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.attributes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.function.Function;

public final class ConverterAbstractAttributesRename {
    public static void register(int version, Function<String, String> renamer) {
        ConverterAbstractAttributesRename.register(version, 0, renamer);
    }

    public static void register(int version, int versionStep, final Function<String, String> renamer) {
        DataConverter<MapType<String>, MapType<String>> entityConverter = new DataConverter<MapType<String>, MapType<String>>(version, versionStep){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType attributes = data.getList("Attributes", ObjectType.MAP);
                if (attributes == null) {
                    return null;
                }
                int len = attributes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    RenameHelper.renameString(attributes.getMap(i2), "Name", renamer);
                }
                return null;
            }
        };
        MCTypeRegistry.ENTITY.addStructureConverter(entityConverter);
        MCTypeRegistry.PLAYER.addStructureConverter(entityConverter);
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(version, versionStep){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType attributes = data.getList("AttributeModifiers", ObjectType.MAP);
                if (attributes == null) {
                    return null;
                }
                int len = attributes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    RenameHelper.renameString(attributes.getMap(i2), "AttributeName", renamer);
                }
                return null;
            }
        });
    }

    private ConverterAbstractAttributesRename() {
    }
}

