/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V1936 {
    private static final int VERSION = 1936;

    public static void register() {
        MCTypeRegistry.OPTIONS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(1936){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String chatOpacity = data.getString("chatOpacity");
                if (chatOpacity != null) {
                    data.setString("textBackgroundOpacity", Double.toString(V1936.calculateBackground(chatOpacity)));
                }
                return null;
            }
        });
    }

    private static double calculateBackground(String opacity) {
        try {
            double d2 = 0.9 * Double.parseDouble(opacity) + 0.1;
            return d2 / 2.0;
        }
        catch (NumberFormatException ex) {
            return 0.5;
        }
    }

    private V1936() {
    }
}

