/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.util.IntegerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class V2841 {
    private static final int VERSION = 2841;
    private static final Set<String> ALWAYS_WATERLOGGED = new HashSet<String>(Arrays.asList("minecraft:bubble_column", "minecraft:kelp", "minecraft:kelp_plant", "minecraft:seagrass", "minecraft:tall_seagrass"));

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(2841){

            @Override
            public MapType<String> convert(MapType<String> root, long sourceVersion, long toVersion) {
                MapType level = root.getMap("Level");
                if (level == null) {
                    return null;
                }
                MapType liquidTicks = level.getMap("LiquidTicks");
                if (liquidTicks != null) {
                    level.remove("LiquidTicks");
                    level.setMap("fluid_ticks", liquidTicks);
                }
                Int2ObjectOpenHashMap sectionBlocks = new Int2ObjectOpenHashMap();
                ListType sections = level.getList("Sections", ObjectType.MAP);
                int minSection = 0;
                if (sections != null) {
                    int len = sections.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        MapType blockStates;
                        MapType section = sections.getMap(i2);
                        int sectionY = section.getInt("Y");
                        if (sectionY < minSection && section.hasKey("biomes")) {
                            minSection = sectionY;
                        }
                        if ((blockStates = section.getMap("block_states")) == null) continue;
                        sectionBlocks.put(sectionY, (Object)new SimplePaletteReader(section.getList("palette", ObjectType.MAP), section.getLongs("data")));
                    }
                }
                level.setByte("yPos", (byte)minSection);
                if (level.hasKey("fluid_ticks") || level.hasKey("TileTicks")) {
                    return null;
                }
                int sectionX = level.getInt("xPos");
                int sectionZ = level.getInt("zPos");
                ListType fluidTicks = level.getList("LiquidsToBeTicked", ObjectType.LIST);
                ListType blockTicks = level.getList("ToBeTicked", ObjectType.LIST);
                level.remove("LiquidsToBeTicked");
                level.remove("ToBeTicked");
                level.setList("fluid_ticks", V2841.migrateTickList(fluidTicks, false, (Int2ObjectOpenHashMap<SimplePaletteReader>)sectionBlocks, sectionX, minSection, sectionZ));
                level.setList("TileTicks", V2841.migrateTickList(blockTicks, true, (Int2ObjectOpenHashMap<SimplePaletteReader>)sectionBlocks, sectionX, minSection, sectionZ));
                return null;
            }
        });
    }

    public static ListType migrateTickList(ListType ticks, boolean blockTicks, Int2ObjectOpenHashMap<SimplePaletteReader> sectionBlocks, int sectionX, int minSection, int sectionZ) {
        ListType ret = Types.NBT.createEmptyList();
        if (ticks == null) {
            return ret;
        }
        int totalSections = ticks.size();
        for (int sectionIndex = 0; sectionIndex < totalSections; ++sectionIndex) {
            int sectionY = sectionIndex + minSection;
            ListType sectionTicks = ticks.getList(sectionIndex);
            SimplePaletteReader palette = (SimplePaletteReader)sectionBlocks.get(sectionY);
            int len = sectionTicks.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int localIndex = sectionTicks.getShort(i2) & 0xFFFF;
                MapType<String> blockState = palette == null ? null : palette.getState(localIndex);
                String subjectId = blockTicks ? V2841.getBlockId(blockState) : V2841.getLiquidId(blockState);
                ret.addMap(V2841.createNewTick(subjectId, localIndex, sectionX, sectionY, sectionZ));
            }
        }
        return ret;
    }

    public static MapType<String> createNewTick(String subjectId, int localIndex, int sectionX, int sectionY, int sectionZ) {
        int newX = (localIndex & 0xF) + (sectionX << 4);
        int newZ = (localIndex >> 4 & 0xF) + (sectionZ << 4);
        int newY = (localIndex >> 8 & 0xF) + (sectionY << 4);
        MapType<String> ret = Types.NBT.createEmptyMap();
        ret.setString("i", subjectId);
        ret.setInt("x", newX);
        ret.setInt("y", newY);
        ret.setInt("z", newZ);
        ret.setInt("t", 0);
        ret.setInt("p", 0);
        return ret;
    }

    public static String getBlockId(MapType<String> blockState) {
        return blockState == null ? "minecraft:air" : blockState.getString("Name", "minecraft:air");
    }

    private static String getLiquidId(MapType<String> blockState) {
        if (blockState == null) {
            return "minecraft:empty";
        }
        String name = blockState.getString("Name");
        if (ALWAYS_WATERLOGGED.contains(name)) {
            return "minecraft:water";
        }
        MapType properties = blockState.getMap("Properties");
        if ("minecraft:water".equals(name)) {
            return properties != null && "0".equals(properties.getString("level")) ? "minecraft:water" : "minecraft:flowing_water";
        }
        if ("minecraft:lava".equals(name)) {
            return properties != null && "0".equals(properties.getString("level")) ? "minecraft:lava" : "minecraft:flowing_lava";
        }
        return properties != null && "true".equals(properties.getString("waterlogged")) ? "minecraft:water" : "minecraft:empty";
    }

    private V2841() {
    }

    public static final class SimplePaletteReader {
        public final ListType palette;
        public final long[] data;
        private final int bitsPerValue;
        private final long mask;
        private final int valuesPerLong;

        public SimplePaletteReader(ListType palette, long[] data) {
            this.palette = palette == null ? null : (palette.size() == 0 ? null : palette);
            this.data = data;
            this.bitsPerValue = Math.max(4, IntegerUtil.ceilLog2(this.palette == null ? 0 : this.palette.size()));
            this.mask = (1L << this.bitsPerValue) - 1L;
            this.valuesPerLong = (int)(64L / (long)this.bitsPerValue);
        }

        public MapType<String> getState(int x2, int y2, int z2) {
            int index = x2 | z2 << 4 | y2 << 8;
            return this.getState(index);
        }

        public MapType<String> getState(int index) {
            ListType palette = this.palette;
            if (palette == null) {
                return null;
            }
            int paletteSize = palette.size();
            if (paletteSize == 1) {
                return palette.getMap(0);
            }
            int dataIndex = index / this.valuesPerLong;
            int localIndex = index % this.valuesPerLong * this.bitsPerValue;
            long[] data = this.data;
            if (dataIndex < 0 || dataIndex >= data.length) {
                return null;
            }
            long value = data[dataIndex];
            int paletteIndex = (int)(value >>> localIndex & this.mask);
            if (paletteIndex < 0 || paletteIndex >= paletteSize) {
                return null;
            }
            return palette.getMap(paletteIndex);
        }
    }
}

