/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V804 {
    private static final int VERSION = 804;

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:banner", new DataConverter<MapType<String>, MapType<String>>(804){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                ListType lore;
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                MapType blockEntity = tag.getMap("BlockEntityTag");
                if (blockEntity == null) {
                    return null;
                }
                if (!blockEntity.hasKey("Base", ObjectType.NUMBER)) {
                    return null;
                }
                data.setShort("Damage", (short)(blockEntity.getShort("Base") & 0xF));
                MapType display = tag.getMap("display");
                if (display != null && (lore = display.getList("Lore", ObjectType.STRING)) != null && lore.size() == 1 && "(+NBT)".equals(lore.getString(0))) {
                    return null;
                }
                blockEntity.remove("Base");
                if (blockEntity.isEmpty()) {
                    tag.remove("BlockEntityTag");
                }
                if (tag.isEmpty()) {
                    data.remove("tag");
                }
                return null;
            }
        });
    }

    private V804() {
    }
}

