/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import java.util.Objects;

public final class FlatBitsetUtil {
    private static final int LOG2_LONG = 6;
    private static final long ALL_SET = -1L;
    private static final int BITS_PER_LONG = 64;

    public static int firstSet(long[] bitset, int from, int to) {
        if ((from | to | to - from) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bitsetIdx = from >>> 6;
        int bitIdx = from & 0xFFFFFFC0;
        long tmp = bitset[bitsetIdx] & -1L << from;
        while (true) {
            if (tmp != 0L) {
                int ret = bitIdx | Long.numberOfTrailingZeros(tmp);
                return ret >= to ? -1 : ret;
            }
            if ((bitIdx += 64) >= to) {
                return -1;
            }
            tmp = bitset[++bitsetIdx];
        }
    }

    public static int firstClear(long[] bitset, int from, int to) {
        if ((from | to | to - from) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bitsetIdx = from >>> 6;
        int bitIdx = from & 0xFFFFFFC0;
        long tmp = (bitset[bitsetIdx] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << from;
        while (true) {
            if (tmp != 0L) {
                int ret = bitIdx | Long.numberOfTrailingZeros(tmp);
                return ret >= to ? -1 : ret;
            }
            if ((bitIdx += 64) >= to) {
                return -1;
            }
            tmp = bitset[++bitsetIdx] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static void clearRange(long[] bitset, int from, int to) {
        if ((from | to | to - from) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int fromBitsetIdx = from >>> 6;
        int toBitsetIdx = --to >>> 6;
        long keepFirst = -1L << from ^ 0xFFFFFFFFFFFFFFFFL;
        long keepLast = -1L >>> (0x3F ^ to) ^ 0xFFFFFFFFFFFFFFFFL;
        Objects.checkFromToIndex(fromBitsetIdx, toBitsetIdx, bitset.length);
        if (fromBitsetIdx == toBitsetIdx) {
            int n2 = fromBitsetIdx;
            bitset[n2] = bitset[n2] & (keepFirst | keepLast);
        } else {
            int n3 = fromBitsetIdx;
            bitset[n3] = bitset[n3] & keepFirst;
            for (int i2 = fromBitsetIdx + 1; i2 < toBitsetIdx; ++i2) {
                bitset[i2] = 0L;
            }
            int n4 = toBitsetIdx;
            bitset[n4] = bitset[n4] & keepLast;
        }
    }

    public static boolean isRangeSet(long[] bitset, int from, int to) {
        return FlatBitsetUtil.firstClear(bitset, from, to) == -1;
    }

    private FlatBitsetUtil() {
    }
}

