/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;

public final class ChunkSystemConverters {
    private static final int DEFAULT_POI_DATA_VERSION = 1945;
    private static final int DEFAULT_ENTITY_CHUNK_DATA_VERSION = -1;

    private static int getCurrentVersion() {
        return SharedConstants.b().d().c();
    }

    private static int getDataVersion(NBTTagCompound data, int dfl) {
        return !data.b("DataVersion", 99) ? dfl : data.h("DataVersion");
    }

    public static NBTTagCompound convertPoiCompoundTag(NBTTagCompound data, WorldServer world) {
        int dataVersion = ChunkSystemConverters.getDataVersion(data, 1945);
        return MCDataConverter.convertTag(MCTypeRegistry.POI_CHUNK, data, dataVersion, ChunkSystemConverters.getCurrentVersion());
    }

    public static NBTTagCompound convertEntityChunkCompoundTag(NBTTagCompound data, WorldServer world) {
        int dataVersion = ChunkSystemConverters.getDataVersion(data, -1);
        return MCDataConverter.convertTag(MCTypeRegistry.ENTITY_CHUNK, data, dataVersion, ChunkSystemConverters.getCurrentVersion());
    }

    private ChunkSystemConverters() {
    }
}

