/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.gui;

import com.destroystokyo.paper.gui.GraphColor;
import java.awt.Color;

public class GraphData {
    private long total;
    private long free;
    private long max;
    private long usedMem;
    private int usedPercent;

    public GraphData(long total, long free, long max) {
        this.total = total;
        this.free = free;
        this.max = max;
        this.usedMem = total - free;
        this.usedPercent = this.usedMem == 0L ? 0 : (int)(this.usedMem * 100L / max);
    }

    public long getTotal() {
        return this.total;
    }

    public long getFree() {
        return this.free;
    }

    public long getMax() {
        return this.max;
    }

    public long getUsedMem() {
        return this.usedMem;
    }

    public int getUsedPercent() {
        return this.usedPercent;
    }

    public Color getFillColor() {
        return GraphColor.getFillColor(this.usedPercent);
    }

    public Color getLineColor() {
        return GraphColor.getLineColor(this.usedPercent);
    }
}

