/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class RedstoneWireTurbo {
    private final BlockRedstoneWire wire;
    private List<UpdateNode> updateQueue0 = Lists.newArrayList();
    private List<UpdateNode> updateQueue1 = Lists.newArrayList();
    private List<UpdateNode> updateQueue2 = Lists.newArrayList();
    private static final boolean[] update_redstone = new boolean[]{true, true, false, false, true, true, false, true, true, false, false, false, true, true, false, false, false, true, true, false, true, true, false, false};
    private static final int North = 0;
    private static final int East = 1;
    private static final int South = 2;
    private static final int West = 3;
    private static final int[] forward_is_north = new int[]{2, 3, 16, 19, 0, 4, 1, 5, 7, 8, 17, 20, 12, 13, 18, 21, 6, 9, 22, 14, 11, 10, 23, 15};
    private static final int[] forward_is_east = new int[]{2, 3, 16, 19, 4, 1, 5, 0, 17, 20, 12, 13, 18, 21, 7, 8, 22, 14, 11, 15, 23, 9, 6, 10};
    private static final int[] forward_is_south = new int[]{2, 3, 16, 19, 1, 5, 0, 4, 12, 13, 18, 21, 7, 8, 17, 20, 11, 15, 23, 10, 6, 14, 22, 9};
    private static final int[] forward_is_west = new int[]{2, 3, 16, 19, 5, 0, 4, 1, 18, 21, 7, 8, 17, 20, 12, 13, 23, 10, 6, 9, 22, 15, 11, 14};
    private static final int[][] reordering = new int[][]{forward_is_north, forward_is_east, forward_is_south, forward_is_west};
    private final Map<BlockPosition, UpdateNode> nodeCache = Maps.newHashMap();
    private static final boolean old_current_change = false;
    private int currentWalkLayer = 0;
    private static final int[] rs_neighbors = new int[]{4, 5, 6, 7};
    private static final int[] rs_neighbors_up = new int[]{9, 11, 13, 15};
    private static final int[] rs_neighbors_dn = new int[]{8, 10, 12, 14};
    private static final EnumDirection[] UPDATE_SHAPE_ORDER = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};

    public RedstoneWireTurbo(BlockRedstoneWire wire) {
        this.wire = wire;
    }

    public static BlockPosition[] computeAllNeighbors(BlockPosition pos) {
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        BlockPosition[] n2 = new BlockPosition[]{new BlockPosition(x2 - 1, y2, z2), new BlockPosition(x2 + 1, y2, z2), new BlockPosition(x2, y2 - 1, z2), new BlockPosition(x2, y2 + 1, z2), new BlockPosition(x2, y2, z2 - 1), new BlockPosition(x2, y2, z2 + 1), new BlockPosition(x2 - 2, y2, z2), new BlockPosition(x2 - 1, y2 - 1, z2), new BlockPosition(x2 - 1, y2 + 1, z2), new BlockPosition(x2 - 1, y2, z2 - 1), new BlockPosition(x2 - 1, y2, z2 + 1), new BlockPosition(x2 + 2, y2, z2), new BlockPosition(x2 + 1, y2 - 1, z2), new BlockPosition(x2 + 1, y2 + 1, z2), new BlockPosition(x2 + 1, y2, z2 - 1), new BlockPosition(x2 + 1, y2, z2 + 1), new BlockPosition(x2, y2 - 2, z2), new BlockPosition(x2, y2 - 1, z2 - 1), new BlockPosition(x2, y2 - 1, z2 + 1), new BlockPosition(x2, y2 + 2, z2), new BlockPosition(x2, y2 + 1, z2 - 1), new BlockPosition(x2, y2 + 1, z2 + 1), new BlockPosition(x2, y2, z2 - 2), new BlockPosition(x2, y2, z2 + 2)};
        return n2;
    }

    private static void orientNeighbors(UpdateNode[] src, UpdateNode[] dst, int heading) {
        int[] re = reordering[heading];
        for (int i2 = 0; i2 < 24; ++i2) {
            dst[i2] = src[re[i2]];
        }
    }

    private void identifyNode(World worldIn, UpdateNode upd1) {
        IBlockData oldState;
        BlockPosition pos = upd1.self;
        upd1.currentState = oldState = worldIn.a_(pos);
        net.minecraft.world.level.block.Block block = oldState.b();
        if (block != this.wire) {
            upd1.type = UpdateNode.Type.OTHER;
            return;
        }
        if (!this.wire.a(null, (IWorldReader)worldIn, pos)) {
            net.minecraft.world.level.block.Block.a(worldIn, pos, new ItemStack(Items.lH));
            worldIn.a(pos, false);
            upd1.type = UpdateNode.Type.OTHER;
            return;
        }
        upd1.type = UpdateNode.Type.REDSTONE;
    }

    private static int computeHeading(int rx, int rz) {
        int code = rx + 1 + 3 * (rz + 1);
        switch (code) {
            case 0: {
                int j2 = ThreadLocalRandom.current().nextInt(0, 1);
                return j2 == 0 ? 0 : 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                int j3 = ThreadLocalRandom.current().nextInt(0, 1);
                return j3 == 0 ? 0 : 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return ThreadLocalRandom.current().nextInt(0, 4);
            }
            case 5: {
                return 1;
            }
            case 6: {
                int j4 = ThreadLocalRandom.current().nextInt(0, 1);
                return j4 == 0 ? 2 : 3;
            }
            case 7: {
                return 2;
            }
            case 8: {
                int j5 = ThreadLocalRandom.current().nextInt(0, 1);
                return j5 == 0 ? 2 : 1;
            }
        }
        return ThreadLocalRandom.current().nextInt(0, 4);
    }

    private void updateNode(World worldIn, UpdateNode upd1, int layer) {
        BlockPosition pos = upd1.self;
        upd1.visited = true;
        IBlockData oldState = upd1.currentState;
        IBlockData newState = this.calculateCurrentChanges(worldIn, upd1);
        if (newState != oldState) {
            upd1.currentState = newState;
            this.propagateChanges(worldIn, upd1, layer);
        }
    }

    private void findNeighbors(World worldIn, UpdateNode upd1) {
        int heading;
        BlockPosition pos = upd1.self;
        BlockPosition[] neighbors = RedstoneWireTurbo.computeAllNeighbors(pos);
        UpdateNode[] neighbor_nodes = new UpdateNode[24];
        upd1.neighbor_nodes = new UpdateNode[24];
        for (int i2 = 0; i2 < 24; ++i2) {
            BlockPosition pos2 = neighbors[i2];
            UpdateNode upd2 = this.nodeCache.get(pos2);
            if (upd2 == null) {
                upd2 = new UpdateNode();
                upd2.self = pos2;
                upd2.parent = pos;
                this.nodeCache.put(pos2, upd2);
                this.identifyNode(worldIn, upd2);
            }
            if (!update_redstone[i2] && upd2.type == UpdateNode.Type.REDSTONE) continue;
            neighbor_nodes[i2] = upd2;
        }
        boolean fromWest = neighbor_nodes[0].visited || neighbor_nodes[7].visited || neighbor_nodes[8].visited;
        boolean fromEast = neighbor_nodes[1].visited || neighbor_nodes[12].visited || neighbor_nodes[13].visited;
        boolean fromNorth = neighbor_nodes[4].visited || neighbor_nodes[17].visited || neighbor_nodes[20].visited;
        boolean fromSouth = neighbor_nodes[5].visited || neighbor_nodes[18].visited || neighbor_nodes[21].visited;
        int cx = 0;
        int cz = 0;
        if (fromWest) {
            ++cx;
        }
        if (fromEast) {
            --cx;
        }
        if (fromNorth) {
            ++cz;
        }
        if (fromSouth) {
            --cz;
        }
        if (cx == 0 && cz == 0) {
            heading = RedstoneWireTurbo.computeHeading(upd1.xbias, upd1.zbias);
            for (int i3 = 0; i3 < 24; ++i3) {
                UpdateNode nn = neighbor_nodes[i3];
                if (nn == null) continue;
                nn.xbias = upd1.xbias;
                nn.zbias = upd1.zbias;
            }
        } else {
            if (cx != 0 && cz != 0) {
                if (upd1.xbias != 0) {
                    cz = 0;
                }
                if (upd1.zbias != 0) {
                    cx = 0;
                }
            }
            heading = RedstoneWireTurbo.computeHeading(cx, cz);
            for (int i4 = 0; i4 < 24; ++i4) {
                UpdateNode nn = neighbor_nodes[i4];
                if (nn == null) continue;
                nn.xbias = cx;
                nn.zbias = cz;
            }
        }
        RedstoneWireTurbo.orientNeighbors(neighbor_nodes, upd1.neighbor_nodes, heading);
    }

    private void propagateChanges(World worldIn, UpdateNode upd1, int layer) {
        if (upd1.neighbor_nodes == null) {
            this.findNeighbors(worldIn, upd1);
        }
        BlockPosition pos = upd1.self;
        int layer1 = layer + 1;
        for (int i2 = 0; i2 < 24; ++i2) {
            UpdateNode upd2 = upd1.neighbor_nodes[i2];
            if (upd2 == null || layer1 <= upd2.layer) continue;
            upd2.layer = layer1;
            this.updateQueue1.add(upd2);
            upd2.parent = pos;
        }
        int layer2 = layer + 2;
        for (int i3 = 0; i3 < 4; ++i3) {
            UpdateNode upd2 = upd1.neighbor_nodes[i3];
            if (upd2 == null || layer2 <= upd2.layer) continue;
            upd2.layer = layer2;
            this.updateQueue2.add(upd2);
            upd2.parent = pos;
        }
    }

    private void shiftQueue() {
        List<UpdateNode> t2 = this.updateQueue0;
        t2.clear();
        this.updateQueue0 = this.updateQueue1;
        this.updateQueue1 = this.updateQueue2;
        this.updateQueue2 = t2;
    }

    private void breadthFirstWalk(World worldIn) {
        this.shiftQueue();
        this.currentWalkLayer = 1;
        while (this.updateQueue0.size() > 0 || this.updateQueue1.size() > 0) {
            List<UpdateNode> thisLayer = this.updateQueue0;
            for (UpdateNode upd : thisLayer) {
                if (upd.type == UpdateNode.Type.REDSTONE) {
                    this.updateNode(worldIn, upd, this.currentWalkLayer);
                    continue;
                }
                worldIn.a_(upd.self).a(worldIn, upd.self, this.wire, upd.parent, false);
            }
            this.shiftQueue();
            ++this.currentWalkLayer;
        }
        this.currentWalkLayer = 0;
    }

    private IBlockData scheduleReentrantNeighborChanged(World worldIn, BlockPosition pos, IBlockData newState, BlockPosition source) {
        UpdateNode upd;
        UpdateNode src;
        if (source != null && (src = this.nodeCache.get(source)) == null) {
            src = new UpdateNode();
            src.self = source;
            src.parent = source;
            src.visited = true;
            this.identifyNode(worldIn, src);
            this.nodeCache.put(source, src);
        }
        if ((upd = this.nodeCache.get(pos)) == null) {
            upd = new UpdateNode();
            upd.self = pos;
            upd.parent = pos;
            upd.visited = true;
            this.identifyNode(worldIn, upd);
            this.nodeCache.put(pos, upd);
        }
        upd.currentState = newState;
        if (upd.neighbor_nodes != null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                UpdateNode upd2 = upd.neighbor_nodes[i2];
                if (upd2 == null) continue;
                upd2.type = UpdateNode.Type.UNKNOWN;
                upd2.currentState = null;
                this.identifyNode(worldIn, upd2);
            }
        }
        this.propagateChanges(worldIn, upd, this.currentWalkLayer);
        return newState;
    }

    public IBlockData updateSurroundingRedstone(World worldIn, BlockPosition pos, IBlockData state, BlockPosition source) {
        IBlockData newState = this.wire.calculateCurrentChanges(worldIn, pos, pos, state);
        if (newState == state) {
            return state;
        }
        if (this.currentWalkLayer > 0 || this.nodeCache.size() > 0) {
            return this.scheduleReentrantNeighborChanged(worldIn, pos, newState, source);
        }
        if (source != null) {
            UpdateNode src = new UpdateNode();
            src.self = source;
            src.parent = source;
            src.visited = true;
            this.nodeCache.put(source, src);
            this.identifyNode(worldIn, src);
        }
        UpdateNode upd = new UpdateNode();
        upd.self = pos;
        upd.parent = source != null ? source : pos;
        upd.currentState = newState;
        upd.type = UpdateNode.Type.REDSTONE;
        upd.visited = true;
        this.nodeCache.put(pos, upd);
        this.propagateChanges(worldIn, upd, 0);
        this.breadthFirstWalk(worldIn);
        this.nodeCache.clear();
        return newState;
    }

    private IBlockData calculateCurrentChanges(World worldIn, UpdateNode upd) {
        BlockPosition pos;
        IBlockData state = upd.currentState;
        int i2 = state.c(BlockRedstoneWire.f);
        int j2 = 0;
        j2 = RedstoneWireTurbo.getMaxCurrentStrength(upd, j2);
        int l2 = 0;
        this.wire.J = false;
        int k2 = worldIn.D(upd.self);
        this.wire.J = true;
        if (k2 < 15) {
            if (upd.neighbor_nodes == null) {
                this.findNeighbors(worldIn, upd);
            }
            UpdateNode center_up = upd.neighbor_nodes[1];
            boolean center_up_is_cube = center_up.currentState.g(worldIn, center_up.self);
            for (int m2 = 0; m2 < 4; ++m2) {
                int n2 = rs_neighbors[m2];
                UpdateNode neighbor = upd.neighbor_nodes[n2];
                l2 = RedstoneWireTurbo.getMaxCurrentStrength(neighbor, l2);
                boolean neighbor_is_cube = neighbor.currentState.g(worldIn, neighbor.self);
                if (!neighbor_is_cube) {
                    UpdateNode neighbor_down = upd.neighbor_nodes[rs_neighbors_dn[m2]];
                    l2 = RedstoneWireTurbo.getMaxCurrentStrength(neighbor_down, l2);
                    continue;
                }
                if (center_up_is_cube) continue;
                UpdateNode neighbor_up = upd.neighbor_nodes[rs_neighbors_up[m2]];
                l2 = RedstoneWireTurbo.getMaxCurrentStrength(neighbor_up, l2);
            }
        }
        if (k2 > (j2 = l2 - 1)) {
            j2 = k2;
        }
        if (i2 != j2) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(worldIn, upd.self), i2, j2);
            worldIn.getCraftServer().getPluginManager().callEvent((Event)event);
            j2 = event.getNewCurrent();
        }
        if (i2 != j2 && this.wire.a(null, (IWorldReader)worldIn, pos = new BlockPosition(upd.self.u(), upd.self.v(), upd.self.w())) && worldIn.a(upd.self, state = (IBlockData)state.a(BlockRedstoneWire.f, j2), 18)) {
            this.updateNeighborShapes(worldIn, upd.self, state);
        }
        return state;
    }

    public void updateNeighborShapes(World level, BlockPosition pos, IBlockData state) {
        state.b(level, pos, 18);
        for (EnumDirection dir : UPDATE_SHAPE_ORDER) {
            BlockPosition neighborPos = pos.a(dir);
            IBlockData neighborState = level.a_(neighborPos);
            IBlockData newState = neighborState.a(dir.g(), state, level, neighborPos, pos);
            net.minecraft.world.level.block.Block.a(neighborState, newState, level, neighborPos, 2);
        }
    }

    private static int getMaxCurrentStrength(UpdateNode upd, int strength) {
        if (upd.type != UpdateNode.Type.REDSTONE) {
            return strength;
        }
        int i2 = upd.currentState.c(BlockRedstoneWire.f);
        return i2 > strength ? i2 : strength;
    }

    private static class UpdateNode {
        IBlockData currentState;
        UpdateNode[] neighbor_nodes;
        BlockPosition self;
        BlockPosition parent;
        Type type = Type.UNKNOWN;
        int layer;
        boolean visited;
        int xbias;
        int zbias;

        private UpdateNode() {
        }

        public static enum Type {
            UNKNOWN,
            REDSTONE,
            OTHER;

        }
    }
}

