/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.block.fluid;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.block.fluid.type.PaperFallingFluidData;
import io.papermc.paper.block.fluid.type.PaperFlowingFluidData;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeLava;
import net.minecraft.world.level.material.FluidTypeWater;
import org.bukkit.Fluid;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class PaperFluidData
implements FluidData {
    private final net.minecraft.world.level.material.Fluid state;
    private static final Map<Class<? extends FluidType>, Function<net.minecraft.world.level.material.Fluid, PaperFluidData>> MAP = new HashMap<Class<? extends FluidType>, Function<net.minecraft.world.level.material.Fluid, PaperFluidData>>();

    protected PaperFluidData(net.minecraft.world.level.material.Fluid state) {
        this.state = state;
    }

    public net.minecraft.world.level.material.Fluid getState() {
        return this.state;
    }

    @NotNull
    public final Fluid getFluidType() {
        return CraftFluid.minecraftToBukkit(this.state.a());
    }

    @NotNull
    public PaperFluidData clone() {
        try {
            return (PaperFluidData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    @NotNull
    public Vector computeFlowDirection(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot compute flow direction on world-less location");
        return CraftVector.toBukkit(this.state.c(((CraftWorld)location.getWorld()).getHandle(), MCUtil.toBlockPosition(location)));
    }

    public int getLevel() {
        return this.state.e();
    }

    public float computeHeight(@NotNull Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot compute height on world-less location");
        return this.state.a((IBlockAccess)((CraftWorld)location.getWorld()).getHandle(), MCUtil.toBlockPos((Position)location));
    }

    public boolean isSource() {
        return this.state.b();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperFluidData)) return false;
        PaperFluidData paperFluidData = (PaperFluidData)obj;
        if (!this.state.equals(paperFluidData.state)) return false;
        return true;
    }

    public String toString() {
        return "PaperFluidData{" + String.valueOf(this.state) + "}";
    }

    static void register(Class<? extends FluidType> fluid, Function<net.minecraft.world.level.material.Fluid, PaperFluidData> creator) {
        Preconditions.checkState((MAP.put(fluid, creator) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", fluid, creator);
        MAP.put(fluid, creator);
    }

    public static PaperFluidData createData(net.minecraft.world.level.material.Fluid state) {
        return MAP.getOrDefault(state.a().getClass(), PaperFluidData::new).apply(state);
    }

    static {
        PaperFluidData.register(FluidTypeLava.b.class, PaperFallingFluidData::new);
        PaperFluidData.register(FluidTypeWater.b.class, PaperFallingFluidData::new);
        PaperFluidData.register(FluidTypeLava.a.class, PaperFlowingFluidData::new);
        PaperFluidData.register(FluidTypeWater.a.class, PaperFlowingFluidData::new);
    }
}

