/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer;

import com.destroystokyo.paper.util.SneakyThrow;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public class NbtPathSerializer
extends ScalarSerializer<ArgumentNBTKey.g> {
    public static final NbtPathSerializer SERIALIZER = new NbtPathSerializer();
    private static final ArgumentNBTKey DUMMY_ARGUMENT = new ArgumentNBTKey();

    private NbtPathSerializer() {
        super(ArgumentNBTKey.g.class);
    }

    public ArgumentNBTKey.g deserialize(Type type, Object obj) throws SerializationException {
        return NbtPathSerializer.fromString(obj.toString());
    }

    protected Object serialize(ArgumentNBTKey.g item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }

    public static List<ArgumentNBTKey.g> fromString(List<String> tags) {
        ArrayList<ArgumentNBTKey.g> paths = new ArrayList<ArgumentNBTKey.g>();
        try {
            for (String tag : tags) {
                paths.add(NbtPathSerializer.fromString(tag));
            }
        }
        catch (SerializationException ex) {
            SneakyThrow.sneaky((Throwable)ex);
        }
        return List.copyOf(paths);
    }

    private static ArgumentNBTKey.g fromString(String tag) throws SerializationException {
        try {
            return DUMMY_ARGUMENT.a(new StringReader(tag));
        }
        catch (CommandSyntaxException e2) {
            throw new SerializationException(ArgumentNBTKey.g.class, (Throwable)e2);
        }
    }
}

