/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.bootstrap;

import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.nio.file.Path;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;

public final class PluginProviderContextImpl
implements PluginProviderContext {
    private final PluginMeta config;
    private final Path dataFolder;
    private final ComponentLogger logger;
    private final Path pluginSource;

    public PluginProviderContextImpl(PluginMeta config, Path dataFolder, ComponentLogger logger, Path pluginSource) {
        this.config = config;
        this.dataFolder = dataFolder;
        this.logger = logger;
        this.pluginSource = pluginSource;
    }

    public static PluginProviderContextImpl create(PluginMeta config, ComponentLogger logger, Path pluginSource) {
        Path dataFolder = PluginInitializerManager.instance().pluginDirectoryPath().resolve(config.getName());
        return new PluginProviderContextImpl(config, dataFolder, logger, pluginSource);
    }

    @NotNull
    public PluginMeta getConfiguration() {
        return this.config;
    }

    @NotNull
    public Path getDataDirectory() {
        return this.dataFolder;
    }

    @NotNull
    public ComponentLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public Path getPluginSource() {
        return this.pluginSource;
    }
}

