/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.StringPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.srgutils.IMappingFile;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ObfHelper {
    INSTANCE;

    private final @Nullable Map<String, ClassMapping> mappingsByObfName;
    private final @Nullable Map<String, ClassMapping> mappingsByMojangName;

    private ObfHelper() {
        @Nullable Set<ClassMapping> maps = ObfHelper.loadMappingsIfPresent();
        if (maps != null) {
            this.mappingsByObfName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::obfName, map -> map));
            this.mappingsByMojangName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::mojangName, map -> map));
        } else {
            this.mappingsByObfName = null;
            this.mappingsByMojangName = null;
        }
    }

    public @Nullable Map<String, ClassMapping> mappingsByObfName() {
        return this.mappingsByObfName;
    }

    public @Nullable Map<String, ClassMapping> mappingsByMojangName() {
        return this.mappingsByMojangName;
    }

    public String reobfClassName(String fullyQualifiedMojangName) {
        if (this.mappingsByMojangName == null) {
            return fullyQualifiedMojangName;
        }
        ClassMapping map = this.mappingsByMojangName.get(fullyQualifiedMojangName);
        if (map == null) {
            return fullyQualifiedMojangName;
        }
        return map.obfName();
    }

    public String deobfClassName(String fullyQualifiedObfName) {
        if (this.mappingsByObfName == null) {
            return fullyQualifiedObfName;
        }
        ClassMapping map = this.mappingsByObfName.get(fullyQualifiedObfName);
        if (map == null) {
            return fullyQualifiedObfName;
        }
        return map.mojangName();
    }

    private static @Nullable Set<ClassMapping> loadMappingsIfPresent() {
        Set set;
        block12: {
            if (!MappingEnvironment.hasMappings()) {
                return null;
            }
            InputStream mappingsInputStream = MappingEnvironment.mappingsStream();
            try {
                IMappingFile mappings = IMappingFile.load((InputStream)mappingsInputStream);
                HashSet<ClassMapping> classes = new HashSet<ClassMapping>();
                StringPool pool = new StringPool();
                for (IMappingFile.IClass cls : mappings.getClasses()) {
                    HashMap<String, String> methods = new HashMap<String, String>();
                    HashMap<String, String> fields = new HashMap<String, String>();
                    HashMap<String, String> strippedMethods = new HashMap<String, String>();
                    for (IMappingFile.IMethod methodMapping : cls.getMethods()) {
                        methods.put(pool.string(ObfHelper.methodKey(Objects.requireNonNull(methodMapping.getMapped()), Objects.requireNonNull(methodMapping.getMappedDescriptor()))), pool.string(Objects.requireNonNull(methodMapping.getOriginal())));
                        strippedMethods.put(pool.string(pool.string(ObfHelper.strippedMethodKey(methodMapping.getMapped(), methodMapping.getDescriptor()))), pool.string(methodMapping.getOriginal()));
                    }
                    for (IMappingFile.IField field : cls.getFields()) {
                        fields.put(pool.string(field.getMapped()), pool.string(field.getOriginal()));
                    }
                    ClassMapping map = new ClassMapping(Objects.requireNonNull(cls.getMapped()).replace('/', '.'), Objects.requireNonNull(cls.getOriginal()).replace('/', '.'), Map.copyOf(methods), Map.copyOf(fields), Map.copyOf(strippedMethods));
                    classes.add(map);
                }
                set = Set.copyOf(classes);
                if (mappingsInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (mappingsInputStream != null) {
                        try {
                            mappingsInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    System.err.println("Failed to load mappings.");
                    ex.printStackTrace();
                    return null;
                }
            }
            mappingsInputStream.close();
        }
        return set;
    }

    public static String strippedMethodKey(String methodName, String methodDescriptor) {
        String methodKey = ObfHelper.methodKey(methodName, methodDescriptor);
        int returnDescriptorEnd = methodKey.indexOf(41);
        return methodKey.substring(0, returnDescriptorEnd + 1);
    }

    public static String methodKey(String methodName, String methodDescriptor) {
        return methodName + methodDescriptor;
    }

    public record ClassMapping(String obfName, String mojangName, Map<String, String> methodsByObf, Map<String, String> fieldsByObf, Map<String, String> strippedMethods) {
    }
}

