/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public final class Advancement
extends Record {
    private final Optional<MinecraftKey> c;
    private final Optional<AdvancementDisplay> d;
    private final AdvancementRewards e;
    private final Map<String, Criterion<?>> f;
    private final AdvancementRequirements g;
    private final boolean h;
    private final Optional<IChatBaseComponent> i;
    private static final Codec<Map<String, Criterion<?>>> j = Codec.unboundedMap((Codec)Codec.STRING, Criterion.a).validate(criteria -> criteria.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)criteria));
    public static final Codec<Advancement> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.optionalFieldOf("parent").forGetter(Advancement::b), (App)AdvancementDisplay.a.optionalFieldOf("display").forGetter(Advancement::c), (App)AdvancementRewards.a.optionalFieldOf("rewards", (Object)AdvancementRewards.b).forGetter(Advancement::d), (App)j.fieldOf("criteria").forGetter(Advancement::e), (App)AdvancementRequirements.a.optionalFieldOf("requirements").forGetter(advancement -> Optional.of(advancement.f())), (App)Codec.BOOL.optionalFieldOf("sends_telemetry_event", (Object)false).forGetter(Advancement::g)).apply((Applicative)instance, (parent, display, rewards, criteria, requirements, sendsTelemetryEvent) -> {
        AdvancementRequirements advancementRequirements = requirements.orElseGet(() -> AdvancementRequirements.a(criteria.keySet()));
        return new Advancement((Optional<MinecraftKey>)parent, (Optional<AdvancementDisplay>)display, (AdvancementRewards)rewards, (Map<String, Criterion<?>>)criteria, advancementRequirements, (boolean)sendsTelemetryEvent);
    })).validate(Advancement::a);
    public static final StreamCodec<RegistryFriendlyByteBuf, Advancement> b = StreamCodec.a(Advancement::a, Advancement::b);

    public Advancement(Optional<MinecraftKey> parent, Optional<AdvancementDisplay> display, AdvancementRewards rewards, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent) {
        this(parent, display, rewards, Map.copyOf(criteria), requirements, sendsTelemetryEvent, display.map(Advancement::a));
    }

    public Advancement(Optional<MinecraftKey> optional, Optional<AdvancementDisplay> optional2, AdvancementRewards advancementRewards, Map<String, Criterion<?>> map, AdvancementRequirements advancementRequirements, boolean bl, Optional<IChatBaseComponent> optional3) {
        this.c = optional;
        this.d = optional2;
        this.e = advancementRewards;
        this.f = map;
        this.g = advancementRequirements;
        this.h = bl;
        this.i = optional3;
    }

    private static DataResult<Advancement> a(Advancement advancement) {
        return advancement.f().a(advancement.e().keySet()).map(validated -> advancement);
    }

    public static IChatBaseComponent a(AdvancementDisplay display) {
        IChatBaseComponent component = display.a();
        EnumChatFormat chatFormatting = display.e().a();
        IChatMutableComponent component2 = ChatComponentUtils.a(component.f(), ChatModifier.a.a(chatFormatting)).f("\n").b(display.b());
        IChatMutableComponent component3 = component.f().a(style -> style.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, component2)));
        return ChatComponentUtils.a(component3).a(chatFormatting);
    }

    public static IChatBaseComponent a(AdvancementHolder identifiedAdvancement) {
        return identifiedAdvancement.b().h().orElseGet(() -> IChatBaseComponent.b(identifiedAdvancement.a().toString()));
    }

    private void a(RegistryFriendlyByteBuf buf) {
        buf.a(this.c, PacketDataSerializer::a);
        AdvancementDisplay.b.a(ByteBufCodecs::a).encode(buf, this.d);
        this.g.a(buf);
        buf.a(this.h);
    }

    private static Advancement b(RegistryFriendlyByteBuf buf) {
        return new Advancement(buf.b(PacketDataSerializer::q), (Optional)AdvancementDisplay.b.a(ByteBufCodecs::a).decode(buf), AdvancementRewards.b, Map.of(), new AdvancementRequirements(buf), buf.readBoolean());
    }

    public boolean a() {
        return this.c.isEmpty();
    }

    public void a(ProblemReporter errorReporter, HolderGetter.a lookup) {
        this.f.forEach((name, criterion) -> {
            CriterionValidator criterionValidator = new CriterionValidator(errorReporter.a((String)name), lookup);
            criterion.b().a(criterionValidator);
        });
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "c", "d", "e", "f", "g", "h", "i"}, this, object);
    }

    public Optional<MinecraftKey> b() {
        return this.c;
    }

    public Optional<AdvancementDisplay> c() {
        return this.d;
    }

    public AdvancementRewards d() {
        return this.e;
    }

    public Map<String, Criterion<?>> e() {
        return this.f;
    }

    public AdvancementRequirements f() {
        return this.g;
    }

    public boolean g() {
        return this.h;
    }

    public Optional<IChatBaseComponent> h() {
        return this.i;
    }

    public static class SerializedAdvancement {
        private Optional<MinecraftKey> a = Optional.empty();
        private Optional<AdvancementDisplay> b = Optional.empty();
        private AdvancementRewards c = AdvancementRewards.b;
        private final ImmutableMap.Builder<String, Criterion<?>> d = ImmutableMap.builder();
        private Optional<AdvancementRequirements> e = Optional.empty();
        private AdvancementRequirements.a f = AdvancementRequirements.a.a;
        private boolean g;

        public static SerializedAdvancement a() {
            return new SerializedAdvancement().c();
        }

        public static SerializedAdvancement b() {
            return new SerializedAdvancement();
        }

        public SerializedAdvancement a(AdvancementHolder parent) {
            this.a = Optional.of(parent.a());
            return this;
        }

        @Deprecated(forRemoval=true)
        public SerializedAdvancement a(MinecraftKey parentId) {
            this.a = Optional.of(parentId);
            return this;
        }

        public SerializedAdvancement a(ItemStack icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(icon, title, description, Optional.ofNullable(background), frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(IMaterial icon, IChatBaseComponent title, IChatBaseComponent description, @Nullable MinecraftKey background, AdvancementFrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.a(new AdvancementDisplay(new ItemStack(icon.r()), title, description, Optional.ofNullable(background), frame, showToast, announceToChat, hidden));
        }

        public SerializedAdvancement a(AdvancementDisplay display) {
            this.b = Optional.of(display);
            return this;
        }

        public SerializedAdvancement a(AdvancementRewards.a builder) {
            return this.a(builder.a());
        }

        public SerializedAdvancement a(AdvancementRewards rewards) {
            this.c = rewards;
            return this;
        }

        public SerializedAdvancement a(String name, Criterion<?> criterion) {
            this.d.put((Object)name, criterion);
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements.a merger) {
            this.f = merger;
            return this;
        }

        public SerializedAdvancement a(AdvancementRequirements requirements) {
            this.e = Optional.of(requirements);
            return this;
        }

        public SerializedAdvancement c() {
            this.g = true;
            return this;
        }

        public AdvancementHolder b(MinecraftKey id) {
            ImmutableMap map = this.d.buildOrThrow();
            AdvancementRequirements advancementRequirements = this.e.orElseGet(() -> this.a((Map)map));
            return new AdvancementHolder(id, new Advancement(this.a, this.b, this.c, (Map<String, Criterion<?>>)map, advancementRequirements, this.g));
        }

        public AdvancementHolder a(Consumer<AdvancementHolder> exporter, String id) {
            AdvancementHolder advancementHolder = this.b(MinecraftKey.a(id));
            exporter.accept(advancementHolder);
            return advancementHolder;
        }

        private /* synthetic */ AdvancementRequirements a(Map map) {
            return this.f.create(map.keySet());
        }
    }
}

