/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.IChatBaseComponent;

public interface CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.empty"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.swapped"));

    public Optional<T> a();

    public Optional<T> b();

    default public boolean c() {
        return this.a().isEmpty() && this.b().isEmpty();
    }

    default public Optional<T> d() {
        Optional<T> optional2;
        Optional<T> optional = this.a();
        return optional.equals(optional2 = this.b()) ? optional : Optional.empty();
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> Codec<R> a(Codec<T> valueCodec, a<T, R> rangeFactory) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.optionalFieldOf("min").forGetter(CriterionConditionValue::a), (App)valueCodec.optionalFieldOf("max").forGetter(CriterionConditionValue::b)).apply((Applicative)instance, rangeFactory::create));
        return Codec.either((Codec)codec, valueCodec).xmap(either -> either.map(range -> range, value -> rangeFactory.create(Optional.of(value), Optional.of(value))), range -> {
            Optional optional = range.d();
            return optional.isPresent() ? Either.right((Number)optional.get()) : Either.left(range);
        });
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> R a(StringReader commandReader, b<T, R> commandFactory, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier, Function<T, T> mapper) throws CommandSyntaxException {
        if (!commandReader.canRead()) {
            throw a.createWithContext((ImmutableStringReader)commandReader);
        }
        int i2 = commandReader.getCursor();
        try {
            Optional<T> optional3;
            Optional<T> optional = CriterionConditionValue.a(commandReader, converter, exceptionTypeSupplier).map(mapper);
            if (commandReader.canRead(2) && commandReader.peek() == '.' && commandReader.peek(1) == '.') {
                commandReader.skip();
                commandReader.skip();
                Optional<T> optional2 = CriterionConditionValue.a(commandReader, converter, exceptionTypeSupplier).map(mapper);
                if (optional.isEmpty() && optional2.isEmpty()) {
                    throw a.createWithContext((ImmutableStringReader)commandReader);
                }
            } else {
                optional3 = optional;
            }
            if (optional.isEmpty() && optional3.isEmpty()) {
                throw a.createWithContext((ImmutableStringReader)commandReader);
            }
            return commandFactory.create(commandReader, optional, optional3);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            commandReader.setCursor(i2);
            throw new CommandSyntaxException(commandSyntaxException.getType(), commandSyntaxException.getRawMessage(), commandSyntaxException.getInput(), i2);
        }
    }

    private static <T extends Number> Optional<T> a(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> exceptionTypeSupplier) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && CriterionConditionValue.a(reader)) {
            reader.skip();
        }
        String string = reader.getString().substring(i2, reader.getCursor());
        if (string.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)converter.apply(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw exceptionTypeSupplier.get().createWithContext((ImmutableStringReader)reader, (Object)string);
        }
    }

    private static boolean a(StringReader reader) {
        char c2 = reader.peek();
        if (c2 >= '0' && c2 <= '9' || c2 == '-') {
            return true;
        }
        if (c2 == '.') {
            return !reader.canRead(2) || reader.peek(1) != '.';
        }
        return false;
    }

    @FunctionalInterface
    public static interface a<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface b<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public static final class DoubleRange
    extends Record
    implements CriterionConditionValue<Double> {
        private final Optional<Double> e;
        private final Optional<Double> f;
        private final Optional<Double> g;
        private final Optional<Double> h;
        public static final DoubleRange c = new DoubleRange(Optional.empty(), Optional.empty());
        public static final Codec<DoubleRange> d = CriterionConditionValue.a(Codec.DOUBLE, DoubleRange::new);

        private DoubleRange(Optional<Double> min, Optional<Double> max) {
            this(min, max, DoubleRange.a(min), DoubleRange.a(max));
        }

        public DoubleRange(Optional<Double> optional, Optional<Double> optional2, Optional<Double> optional3, Optional<Double> optional4) {
            this.e = optional;
            this.f = optional2;
            this.g = optional3;
            this.h = optional4;
        }

        private static DoubleRange a(StringReader reader, Optional<Double> min, Optional<Double> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new DoubleRange(min, max);
        }

        private static Optional<Double> a(Optional<Double> value) {
            return value.map(d2 -> d2 * d2);
        }

        public static DoubleRange a(double value) {
            return new DoubleRange(Optional.of(value), Optional.of(value));
        }

        public static DoubleRange a(double min, double max) {
            return new DoubleRange(Optional.of(min), Optional.of(max));
        }

        public static DoubleRange b(double value) {
            return new DoubleRange(Optional.of(value), Optional.empty());
        }

        public static DoubleRange c(double value) {
            return new DoubleRange(Optional.empty(), Optional.of(value));
        }

        public boolean d(double value) {
            if (this.e.isPresent() && this.e.get() > value) {
                return false;
            }
            return this.f.isEmpty() || !(this.f.get() < value);
        }

        public boolean e(double value) {
            if (this.g.isPresent() && this.g.get() > value) {
                return false;
            }
            return this.h.isEmpty() || !(this.h.get() < value);
        }

        public static DoubleRange a(StringReader reader) throws CommandSyntaxException {
            return DoubleRange.a(reader, (Double value) -> value);
        }

        public static DoubleRange a(StringReader reader, Function<Double, Double> mapper) throws CommandSyntaxException {
            return CriterionConditionValue.a(reader, DoubleRange::a, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), mapper);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this, object);
        }

        @Override
        @Override
        public Optional<Double> a() {
            return this.e;
        }

        @Override
        @Override
        public Optional<Double> b() {
            return this.f;
        }

        public Optional<Double> e() {
            return this.g;
        }

        public Optional<Double> f() {
            return this.h;
        }
    }

    public static final class IntegerRange
    extends Record
    implements CriterionConditionValue<Integer> {
        private final Optional<Integer> e;
        private final Optional<Integer> f;
        private final Optional<Long> g;
        private final Optional<Long> h;
        public static final IntegerRange c = new IntegerRange(Optional.empty(), Optional.empty());
        public static final Codec<IntegerRange> d = CriterionConditionValue.a(Codec.INT, IntegerRange::new);

        private IntegerRange(Optional<Integer> min, Optional<Integer> max) {
            this(min, max, min.map(i2 -> i2.longValue() * i2.longValue()), IntegerRange.a(max));
        }

        public IntegerRange(Optional<Integer> optional, Optional<Integer> optional2, Optional<Long> optional3, Optional<Long> optional4) {
            this.e = optional;
            this.f = optional2;
            this.g = optional3;
            this.h = optional4;
        }

        private static IntegerRange a(StringReader reader, Optional<Integer> min, Optional<Integer> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new IntegerRange(min, max);
        }

        private static Optional<Long> a(Optional<Integer> value) {
            return value.map(i2 -> i2.longValue() * i2.longValue());
        }

        public static IntegerRange a(int value) {
            return new IntegerRange(Optional.of(value), Optional.of(value));
        }

        public static IntegerRange a(int min, int max) {
            return new IntegerRange(Optional.of(min), Optional.of(max));
        }

        public static IntegerRange b(int value) {
            return new IntegerRange(Optional.of(value), Optional.empty());
        }

        public static IntegerRange c(int value) {
            return new IntegerRange(Optional.empty(), Optional.of(value));
        }

        public boolean d(int value) {
            if (this.e.isPresent() && this.e.get() > value) {
                return false;
            }
            return this.f.isEmpty() || this.f.get() >= value;
        }

        public boolean a(long value) {
            if (this.g.isPresent() && this.g.get() > value) {
                return false;
            }
            return this.h.isEmpty() || this.h.get() >= value;
        }

        public static IntegerRange a(StringReader reader) throws CommandSyntaxException {
            return IntegerRange.a(reader, (Integer value) -> value);
        }

        public static IntegerRange a(StringReader reader, Function<Integer, Integer> converter) throws CommandSyntaxException {
            return CriterionConditionValue.a(reader, IntegerRange::a, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), converter);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this, object);
        }

        @Override
        @Override
        public Optional<Integer> a() {
            return this.e;
        }

        @Override
        @Override
        public Optional<Integer> b() {
            return this.f;
        }

        public Optional<Long> e() {
            return this.g;
        }

        public Optional<Long> f() {
            return this.h;
        }
    }
}

