/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentTime
implements ArgumentType<Integer> {
    private static final Collection<String> a = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.time.invalid_unit"));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((value, minimum) -> IChatBaseComponent.b("argument.time.tick_count_too_low", minimum, value));
    private static final Object2IntMap<String> d = new Object2IntOpenHashMap();
    final int e;

    private ArgumentTime(int minimum) {
        this.e = minimum;
    }

    public static ArgumentTime a() {
        return new ArgumentTime(0);
    }

    public static ArgumentTime a(int minimum) {
        return new ArgumentTime(minimum);
    }

    public Integer a(StringReader stringReader) throws CommandSyntaxException {
        float f2 = stringReader.readFloat();
        String string = stringReader.readUnquotedString();
        int i2 = d.getOrDefault((Object)string, 0);
        if (i2 == 0) {
            throw b.createWithContext((ImmutableStringReader)stringReader);
        }
        int j2 = Math.round(f2 * (float)i2);
        if (j2 < this.e) {
            throw c.createWithContext((ImmutableStringReader)stringReader, (Object)j2, (Object)this.e);
        }
        return j2;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        StringReader stringReader = new StringReader(suggestionsBuilder.getRemaining());
        try {
            stringReader.readFloat();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return suggestionsBuilder.buildFuture();
        }
        return ICompletionProvider.b((Iterable<String>)d.keySet(), suggestionsBuilder.createOffset(suggestionsBuilder.getStart() + stringReader.getCursor()));
    }

    public Collection<String> getExamples() {
        return a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    static {
        d.put((Object)"d", 24000);
        d.put((Object)"s", 20);
        d.put((Object)"t", 1);
        d.put((Object)"", 1);
    }

    public static class net.minecraft.commands.arguments.ArgumentTime$a
    implements ArgumentTypeInfo<ArgumentTime, a> {
        @Override
        @Override
        public void a(a properties, PacketDataSerializer buf) {
            buf.p(properties.b);
        }

        @Override
        @Override
        public a a(PacketDataSerializer friendlyByteBuf) {
            int i2 = friendlyByteBuf.readInt();
            return new a(i2);
        }

        @Override
        @Override
        public void a(a properties, JsonObject json) {
            json.addProperty("min", (Number)properties.b);
        }

        @Override
        @Override
        public a a(ArgumentTime argumentType) {
            return new a(argumentType.e);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a b(PacketDataSerializer buf) {
            return this.a(buf);
        }

        public final class a
        implements ArgumentTypeInfo.a<ArgumentTime> {
            final int b;

            a(int minimum) {
                this.b = minimum;
            }

            @Override
            public ArgumentTime a(CommandBuildContext commandBuildContext) {
                return ArgumentTime.a(this.b);
            }

            @Override
            @Override
            public ArgumentTypeInfo<ArgumentTime, ?> a() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType b(CommandBuildContext commandRegistryAccess) {
                return this.a(commandRegistryAccess);
            }
        }
    }
}

