/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable,
CollisionDirection {
    public static final /* enum */ EnumDirection a = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.b, EnumAxis.b, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection b = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.a, EnumAxis.b, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection c = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.b, EnumAxis.c, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection d = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.a, EnumAxis.c, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection e = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.b, EnumAxis.a, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection f = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.a, EnumAxis.a, new BaseBlockPosition(1, 0, 0));
    public static final INamable.a<EnumDirection> g;
    public static final Codec<EnumDirection> h;
    public static final IntFunction<EnumDirection> i;
    public static final StreamCodec<ByteBuf, EnumDirection> j;
    private final int k;
    private final int l;
    private final int m;
    private final String n;
    private final EnumAxis o;
    private final EnumAxisDirection p;
    private final BaseBlockPosition q;
    private static final EnumDirection[] r;
    private static final EnumDirection[] s;
    private static final EnumDirection[] t;
    private final int adjX;
    private final int adjY;
    private final int adjZ;
    private static final int RANDOM_OFFSET = 2017601568;
    private EnumDirection opposite;
    private Quaternionf rotation;
    private int id;
    private int stepX;
    private int stepY;
    private int stepZ;
    private static final /* synthetic */ EnumDirection[] u;

    public static EnumDirection[] values() {
        return (EnumDirection[])u.clone();
    }

    public static EnumDirection valueOf(String name) {
        return Enum.valueOf(EnumDirection.class, name);
    }

    private Quaternionf getRotationUncached() {
        switch (this.ordinal()) {
            case 0: {
                return new Quaternionf().rotationX((float)Math.PI);
            }
            case 1: {
                return new Quaternionf();
            }
            case 2: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            }
            case 3: {
                return new Quaternionf().rotationX(1.5707964f);
            }
            case 4: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            }
            case 5: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final int moonrise$uniqueId() {
        return this.id;
    }

    private EnumDirection(int id, int idOpposite, int idHorizontal, String name, EnumAxisDirection direction, EnumAxis axis, BaseBlockPosition vector) {
        this.k = id;
        this.m = idHorizontal;
        this.l = idOpposite;
        this.n = name;
        this.o = axis;
        this.p = direction;
        this.q = vector;
        this.adjX = vector.u();
        this.adjY = vector.v();
        this.adjZ = vector.w();
    }

    public static EnumDirection[] a(Entity entity) {
        EnumDirection direction3;
        float f2 = entity.h(1.0f) * ((float)Math.PI / 180);
        float g2 = -entity.i(1.0f) * ((float)Math.PI / 180);
        float h2 = MathHelper.a(f2);
        float i2 = MathHelper.b(f2);
        float j2 = MathHelper.a(g2);
        float k2 = MathHelper.b(g2);
        boolean bl = j2 > 0.0f;
        boolean bl2 = h2 < 0.0f;
        boolean bl3 = k2 > 0.0f;
        float l2 = bl ? j2 : -j2;
        float m2 = bl2 ? -h2 : h2;
        float n2 = bl3 ? k2 : -k2;
        float o2 = l2 * i2;
        float p2 = n2 * i2;
        EnumDirection direction = bl ? f : e;
        EnumDirection direction2 = bl2 ? b : a;
        EnumDirection enumDirection = direction3 = bl3 ? d : c;
        if (l2 > n2) {
            if (m2 > o2) {
                return EnumDirection.a(direction2, direction, direction3);
            }
            return p2 > m2 ? EnumDirection.a(direction, direction3, direction2) : EnumDirection.a(direction, direction2, direction3);
        }
        if (m2 > p2) {
            return EnumDirection.a(direction2, direction3, direction);
        }
        return o2 > m2 ? EnumDirection.a(direction3, direction, direction2) : EnumDirection.a(direction3, direction2, direction);
    }

    private static EnumDirection[] a(EnumDirection first, EnumDirection second, EnumDirection third) {
        return new EnumDirection[]{first, second, third, third.g(), second.g(), first.g()};
    }

    public static EnumDirection a(Matrix4f matrix, EnumDirection direction) {
        BaseBlockPosition vec3i = direction.q();
        Vector4f vector4f = matrix.transform(new Vector4f((float)vec3i.u(), (float)vec3i.v(), (float)vec3i.w(), 0.0f));
        return EnumDirection.a(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static Collection<EnumDirection> a(RandomSource random) {
        return SystemUtils.b(EnumDirection.values(), random);
    }

    public static Stream<EnumDirection> a() {
        return Stream.of(r);
    }

    public Quaternionf b() {
        try {
            return (Quaternionf)this.rotation.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public int d() {
        return this.k;
    }

    public int e() {
        return this.m;
    }

    public EnumAxisDirection f() {
        return this.p;
    }

    public static EnumDirection a(Entity entity, EnumAxis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (f.a(entity.i(1.0f))) {
                    yield f;
                }
                yield e;
            }
            case 1 -> {
                if (entity.h(1.0f) < 0.0f) {
                    yield b;
                }
                yield a;
            }
            case 2 -> d.a(entity.i(1.0f)) ? d : c;
        };
    }

    public EnumDirection g() {
        return this.opposite;
    }

    public EnumDirection a(EnumAxis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != e && this != f) {
                    yield this.r();
                }
                yield this;
            }
            case 1 -> {
                if (this != b && this != a) {
                    yield this.h();
                }
                yield this;
            }
            case 2 -> this != c && this != d ? this.t() : this;
        };
    }

    public EnumDirection b(EnumAxis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != e && this != f) {
                    yield this.s();
                }
                yield this;
            }
            case 1 -> {
                if (this != b && this != a) {
                    yield this.i();
                }
                yield this;
            }
            case 2 -> this != c && this != d ? this.u() : this;
        };
    }

    public EnumDirection h() {
        return switch (this.ordinal()) {
            case 2 -> f;
            case 3 -> e;
            case 4 -> c;
            case 5 -> d;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection r() {
        return switch (this.ordinal()) {
            case 0 -> d;
            case 1 -> c;
            case 2 -> a;
            case 3 -> b;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection s() {
        return switch (this.ordinal()) {
            case 0 -> c;
            case 1 -> d;
            case 2 -> b;
            case 3 -> a;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection t() {
        return switch (this.ordinal()) {
            case 0 -> e;
            case 1 -> f;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> b;
            case 5 -> a;
        };
    }

    private EnumDirection u() {
        return switch (this.ordinal()) {
            case 0 -> f;
            case 1 -> e;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> a;
            case 5 -> b;
        };
    }

    public EnumDirection i() {
        return switch (this.ordinal()) {
            case 2 -> e;
            case 3 -> f;
            case 4 -> d;
            case 5 -> c;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int j() {
        return this.adjX;
    }

    public int k() {
        return this.adjY;
    }

    public int l() {
        return this.adjZ;
    }

    public Vector3f m() {
        return new Vector3f((float)this.j(), (float)this.k(), (float)this.l());
    }

    public String n() {
        return this.n;
    }

    public EnumAxis o() {
        return this.o;
    }

    @Nullable
    public static EnumDirection a(@Nullable String name) {
        return g.a(name);
    }

    public static EnumDirection a(int id) {
        return s[MathHelper.a(id % s.length)];
    }

    public static EnumDirection b(int value) {
        return t[MathHelper.a(value % t.length)];
    }

    @Nullable
    public static EnumDirection a(int x2, int y2, int z2) {
        if (x2 == 0) {
            if (y2 == 0) {
                if (z2 > 0) {
                    return d;
                }
                if (z2 < 0) {
                    return c;
                }
            } else if (z2 == 0) {
                if (y2 > 0) {
                    return b;
                }
                return a;
            }
        } else if (y2 == 0 && z2 == 0) {
            if (x2 > 0) {
                return f;
            }
            return e;
        }
        return null;
    }

    public static EnumDirection a(double rotation) {
        return EnumDirection.b(MathHelper.a(rotation / 90.0 + 0.5) & 3);
    }

    public static EnumDirection a(EnumAxis axis, EnumAxisDirection direction) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (direction == EnumAxisDirection.a) {
                    yield f;
                }
                yield e;
            }
            case 1 -> {
                if (direction == EnumAxisDirection.a) {
                    yield b;
                }
                yield a;
            }
            case 2 -> direction == EnumAxisDirection.a ? d : c;
        };
    }

    public float p() {
        return (this.m & 3) * 90;
    }

    public static EnumDirection b(RandomSource random) {
        return SystemUtils.a(r, random);
    }

    public static EnumDirection a(double x2, double y2, double z2) {
        return EnumDirection.a((float)x2, (float)y2, (float)z2);
    }

    public static EnumDirection a(float x2, float y2, float z2) {
        EnumDirection direction = c;
        float f2 = Float.MIN_VALUE;
        for (EnumDirection direction2 : r) {
            float g2 = x2 * (float)direction2.q.u() + y2 * (float)direction2.q.v() + z2 * (float)direction2.q.w();
            if (!(g2 > f2)) continue;
            f2 = g2;
            direction = direction2;
        }
        return direction;
    }

    public static EnumDirection a(Vec3D vec) {
        return EnumDirection.a(vec.c, vec.d, vec.e);
    }

    public String toString() {
        return this.n;
    }

    @Override
    public String c() {
        return this.n;
    }

    private static DataResult<EnumDirection> a(EnumDirection direction) {
        return direction.o().b() ? DataResult.success((Object)direction) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static EnumDirection a(EnumAxisDirection direction, EnumAxis axis) {
        for (EnumDirection direction2 : r) {
            if (direction2.f() != direction || direction2.o() != axis) continue;
            return direction2;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)direction) + " " + String.valueOf(axis));
    }

    public BaseBlockPosition q() {
        return this.q;
    }

    public boolean a(float yaw) {
        float f2 = yaw * ((float)Math.PI / 180);
        float g2 = -MathHelper.a(f2);
        float h2 = MathHelper.b(f2);
        return (float)this.q.u() * g2 + (float)this.q.w() * h2 > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] w() {
        return new EnumDirection[]{a, b, c, d, e, f};
    }

    static {
        u = EnumDirection.w();
        g = INamable.a(EnumDirection::values);
        h = g.validate(EnumDirection::a);
        i = ByIdMap.a(EnumDirection::d, EnumDirection.values(), ByIdMap.a.b);
        j = ByteBufCodecs.a(i, EnumDirection::d);
        r = EnumDirection.values();
        s = (EnumDirection[])Arrays.stream(r).sorted(Comparator.comparingInt(direction -> direction.k)).toArray(EnumDirection[]::new);
        t = (EnumDirection[])Arrays.stream(r).filter(direction -> direction.o().d()).sorted(Comparator.comparingInt(direction -> direction.m)).toArray(EnumDirection[]::new);
        for (EnumDirection direction2 : r) {
            direction2.opposite = EnumDirection.a(direction2.l);
            direction2.rotation = direction2.getRotationUncached();
            direction2.id = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(direction2.ordinal() + 2017601568)) + 2017601568));
            direction2.stepX = direction2.q.u();
            direction2.stepY = direction2.q.v();
            direction2.stepZ = direction2.q.w();
        }
    }

    public static abstract sealed class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis a = new EnumAxis("x"){

            @Override
            public int a(int x2, int y2, int z2) {
                return x2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return x2;
            }
        };
        public static final /* enum */ EnumAxis b = new EnumAxis("y"){

            @Override
            public int a(int x2, int y2, int z2) {
                return y2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return y2;
            }
        };
        public static final /* enum */ EnumAxis c = new EnumAxis("z"){

            @Override
            public int a(int x2, int y2, int z2) {
                return z2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return z2;
            }
        };
        public static final EnumAxis[] d;
        public static final INamable.a<EnumAxis> e;
        private final String f;
        private static final /* synthetic */ EnumAxis[] g;

        public static EnumAxis[] values() {
            return (EnumAxis[])g.clone();
        }

        public static EnumAxis valueOf(String name) {
            return Enum.valueOf(EnumAxis.class, name);
        }

        private EnumAxis(String name) {
            this.f = name;
        }

        @Nullable
        public static EnumAxis a(String name) {
            return e.a(name);
        }

        public String a() {
            return this.f;
        }

        public boolean b() {
            return this == b;
        }

        public boolean d() {
            return this == a || this == c;
        }

        public String toString() {
            return this.f;
        }

        public static EnumAxis a(RandomSource random) {
            return SystemUtils.a(d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.o() == this;
        }

        public EnumDirectionLimit e() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> EnumDirectionLimit.a;
                case 1 -> EnumDirectionLimit.b;
            };
        }

        @Override
        public String c() {
            return this.f;
        }

        public abstract int a(int var1, int var2, int var3);

        public abstract double a(double var1, double var3, double var5);

        private static /* synthetic */ EnumAxis[] f() {
            return new EnumAxis[]{a, b, c};
        }

        static {
            g = EnumAxis.f();
            d = EnumAxis.values();
            e = INamable.a(EnumAxis::values);
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection a = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection b = new EnumAxisDirection(-1, "Towards negative");
        private final int c;
        private final String d;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String name) {
            return Enum.valueOf(EnumAxisDirection.class, name);
        }

        private EnumAxisDirection(int offset, String description) {
            this.c = offset;
            this.d = description;
        }

        public int a() {
            return this.c;
        }

        public String b() {
            return this.d;
        }

        public String toString() {
            return this.d;
        }

        public EnumAxisDirection c() {
            return this == a ? b : a;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{a, b};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit a = new EnumDirectionLimit(new EnumDirection[]{c, f, d, e}, new EnumAxis[]{EnumAxis.a, EnumAxis.c});
        public static final /* enum */ EnumDirectionLimit b = new EnumDirectionLimit(new EnumDirection[]{b, a}, new EnumAxis[]{EnumAxis.b});
        private final EnumDirection[] c;
        private final EnumAxis[] d;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String name) {
            return Enum.valueOf(EnumDirectionLimit.class, name);
        }

        private EnumDirectionLimit(EnumDirection[] facingArray, EnumAxis[] axisArray) {
            this.c = facingArray;
            this.d = axisArray;
        }

        public EnumDirection a(RandomSource random) {
            return SystemUtils.a(this.c, random);
        }

        public EnumAxis b(RandomSource random) {
            return SystemUtils.a(this.d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.o().e() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.c);
        }

        public Stream<EnumDirection> a() {
            return Arrays.stream(this.c);
        }

        public List<EnumDirection> c(RandomSource random) {
            return SystemUtils.b(this.c, random);
        }

        public int b() {
            return this.c.length;
        }

        private static /* synthetic */ EnumDirectionLimit[] c() {
            return new EnumDirectionLimit[]{a, b};
        }

        static {
            e = EnumDirectionLimit.c();
        }
    }
}

