/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.ResourceKey;

public class LayeredRegistryAccess<T> {
    private final List<T> a;
    private final List<IRegistryCustom.Dimension> b;
    private final IRegistryCustom.Dimension c;

    public LayeredRegistryAccess(List<T> types) {
        this(types, SystemUtils.a(() -> {
            Object[] frozens = new IRegistryCustom.Dimension[types.size()];
            Arrays.fill(frozens, IRegistryCustom.b);
            return Arrays.asList(frozens);
        }));
    }

    private LayeredRegistryAccess(List<T> types, List<IRegistryCustom.Dimension> registryManagers) {
        this.a = List.copyOf(types);
        this.b = List.copyOf(registryManagers);
        this.c = new IRegistryCustom.c(LayeredRegistryAccess.a(registryManagers.stream())).d();
    }

    private int d(T type) {
        int i2 = this.a.indexOf(type);
        if (i2 == -1) {
            throw new IllegalStateException("Can't find " + String.valueOf(type) + " inside " + String.valueOf(this.a));
        }
        return i2;
    }

    public IRegistryCustom.Dimension a(T index) {
        int i2 = this.d(index);
        return this.b.get(i2);
    }

    public IRegistryCustom.Dimension b(T type) {
        int i2 = this.d(type);
        return this.a(0, i2);
    }

    public IRegistryCustom.Dimension c(T type) {
        int i2 = this.d(type);
        return this.a(i2, this.b.size());
    }

    private IRegistryCustom.Dimension a(int startIndex, int endIndex) {
        return new IRegistryCustom.c(LayeredRegistryAccess.a(this.b.subList(startIndex, endIndex).stream())).d();
    }

    public LayeredRegistryAccess<T> a(T type, IRegistryCustom.Dimension ... registryManagers) {
        return this.a(type, Arrays.asList(registryManagers));
    }

    public LayeredRegistryAccess<T> a(T type, List<IRegistryCustom.Dimension> registryManagers) {
        int i2 = this.d(type);
        if (registryManagers.size() > this.b.size() - i2) {
            throw new IllegalStateException("Too many values to replace");
        }
        ArrayList<IRegistryCustom.Dimension> list = new ArrayList<IRegistryCustom.Dimension>();
        for (int j2 = 0; j2 < i2; ++j2) {
            list.add(this.b.get(j2));
        }
        list.addAll(registryManagers);
        while (list.size() < this.b.size()) {
            list.add(IRegistryCustom.b);
        }
        return new LayeredRegistryAccess<T>(this.a, list);
    }

    public IRegistryCustom.Dimension a() {
        return this.c;
    }

    private static Map<ResourceKey<? extends IRegistry<?>>, IRegistry<?>> a(Stream<? extends IRegistryCustom> registryManagers) {
        HashMap map = new HashMap();
        registryManagers.forEach(registryManager -> registryManager.c().forEach(entry -> {
            if (map.put(entry.a(), entry.b()) != null) {
                throw new IllegalStateException("Duplicated registry " + String.valueOf(entry.a()));
            }
        }));
        return map;
    }
}

