/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private static final Logger b = LogUtils.getLogger();
    final ResourceKey<? extends IRegistry<T>> c;
    private final ObjectList<Holder.c<T>> d = new ObjectArrayList(256);
    private final Reference2IntMap<T> e = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(2048), (? super T map) -> map.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> f = new HashMap<MinecraftKey, Holder.c<T>>(2048);
    private final Map<ResourceKey<T>, Holder.c<T>> g = new HashMap<ResourceKey<T>, Holder.c<T>>(2048);
    private final Map<T, Holder.c<T>> h = new IdentityHashMap<T, Holder.c<T>>(2048);
    private final Map<ResourceKey<T>, RegistrationInfo> i = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>(2048);
    private Lifecycle j;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> k = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean l;
    @Nullable
    private Map<T, Holder.c<T>> m;
    private final HolderLookup.b<T> n = new HolderLookup.b<T>(){

        @Override
        public ResourceKey<? extends IRegistry<? extends T>> f() {
            return RegistryMaterials.this.c;
        }

        @Override
        public Lifecycle g() {
            return RegistryMaterials.this.e();
        }

        @Override
        public Optional<Holder.c<T>> a(ResourceKey<T> key) {
            return RegistryMaterials.this.b(key);
        }

        @Override
        public Stream<Holder.c<T>> b() {
            return RegistryMaterials.this.i();
        }

        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
            return RegistryMaterials.this.b(tag);
        }

        @Override
        public Stream<HolderSet.Named<T>> d() {
            return RegistryMaterials.this.j().map(Pair::getSecond);
        }
    };
    private final Object o = new Object();

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle) {
        this(key, lifecycle, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, boolean intrusive) {
        this.c = key;
        this.j = lifecycle;
        if (intrusive) {
            this.m = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> d() {
        return this.c;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.c) + " (" + String.valueOf(this.j) + ")]";
    }

    private void b() {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    public void h(ResourceKey<T> key) {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(key) + ")");
        }
    }

    @Override
    public Holder.c<T> a(ResourceKey<T> key, T value, RegistrationInfo info) {
        Holder.c reference;
        this.h(key);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.f.containsKey(key.a())) {
            SystemUtils.b(new IllegalStateException("Adding duplicate key '" + String.valueOf(key) + "' to registry"));
        }
        if (this.h.containsKey(value)) {
            SystemUtils.b(new IllegalStateException("Adding duplicate value '" + String.valueOf(value) + "' to registry"));
        }
        if (this.m != null) {
            reference = this.m.remove(value);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(key) + ":" + String.valueOf(value)));
            }
            reference.b(key);
        } else {
            reference = this.g.computeIfAbsent(key, k2 -> Holder.c.a(this.p(), k2));
        }
        this.g.put(key, reference);
        this.f.put(key.a(), reference);
        this.h.put(value, reference);
        int i2 = this.d.size();
        this.d.add((Object)reference);
        this.e.put(value, i2);
        this.i.put(key, info);
        this.j = this.j.add(info.b());
        return reference;
    }

    @Override
    @Nullable
    public MinecraftKey b(T value) {
        Holder.c<T> reference = this.h.get(value);
        return reference != null ? reference.h().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> d(T entry) {
        return Optional.ofNullable(this.h.get(entry)).map(Holder.c::h);
    }

    @Override
    public int a(@Nullable T value) {
        return this.e.getInt(value);
    }

    @Override
    @Nullable
    public T a(@Nullable ResourceKey<T> key) {
        return RegistryMaterials.a(this.g.get(key));
    }

    @Override
    @Nullable
    public T a(int index) {
        return index >= 0 && index < this.d.size() ? (T)((Holder.c)this.d.get(index)).a() : null;
    }

    @Override
    public Optional<Holder.c<T>> c(int rawId) {
        return rawId >= 0 && rawId < this.d.size() ? Optional.ofNullable((Holder.c)this.d.get(rawId)) : Optional.empty();
    }

    @Override
    public Optional<Holder.c<T>> c(MinecraftKey id) {
        return Optional.ofNullable(this.f.get(id));
    }

    @Override
    public Optional<Holder.c<T>> b(ResourceKey<T> key) {
        return Optional.ofNullable(this.g.get(key));
    }

    @Override
    public Optional<Holder.c<T>> a() {
        return this.d.isEmpty() ? Optional.empty() : Optional.of((Holder.c)this.d.getFirst());
    }

    @Override
    public Holder<T> e(T value) {
        Holder.c<T> reference = this.h.get(value);
        return reference != null ? reference : Holder.a(value);
    }

    Holder.c<T> i(ResourceKey<T> key) {
        return this.g.computeIfAbsent(key, key2 -> {
            if (this.m != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.h((ResourceKey<T>)key2);
            return Holder.c.a(this.p(), key2);
        });
    }

    @Override
    public int c() {
        return this.g.size();
    }

    @Override
    public Optional<RegistrationInfo> c(ResourceKey<T> key) {
        return Optional.ofNullable(this.i.get(key));
    }

    @Override
    public Lifecycle e() {
        return this.j;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.d.iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey id) {
        Holder.c<T> reference = this.f.get(id);
        return RegistryMaterials.a(reference);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> entry) {
        return entry != null ? (T)entry.a() : null;
    }

    @Override
    public Set<MinecraftKey> f() {
        return Collections.unmodifiableSet(this.f.keySet());
    }

    @Override
    public Set<ResourceKey<T>> g() {
        return Collections.unmodifiableSet(this.g.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> h() {
        return Collections.unmodifiableSet(Maps.transformValues(this.g, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> i() {
        return this.d.stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> j() {
        return this.k.entrySet().stream().map(entry -> Pair.of((Object)((TagKey)entry.getKey()), (Object)((HolderSet.Named)entry.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HolderSet.Named<T> a(TagKey<T> tag) {
        HolderSet.Named<T> named = this.k.get(tag);
        if (named != null) {
            return named;
        }
        Object object = this.o;
        synchronized (object) {
            named = this.k.get(tag);
            if (named != null) {
                return named;
            }
            named = this.d(tag);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
            map.put(tag, named);
            this.k = map;
            return named;
        }
    }

    private HolderSet.Named<T> d(TagKey<T> tag) {
        return new HolderSet.Named<T>(this.p(), tag);
    }

    @Override
    public Stream<TagKey<T>> k() {
        return this.k.keySet().stream();
    }

    @Override
    public boolean l() {
        return this.g.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> a(RandomSource random) {
        return SystemUtils.b(this.d, random);
    }

    @Override
    public boolean d(MinecraftKey id) {
        return this.f.containsKey(id);
    }

    @Override
    public boolean d(ResourceKey<T> key) {
        return this.g.containsKey(key);
    }

    @Override
    public IRegistry<T> m() {
        if (this.l) {
            return this;
        }
        this.l = true;
        this.h.forEach((? super K value, ? super V entry) -> entry.b(value));
        List<MinecraftKey> list = this.g.entrySet().stream().filter(entry -> !((Holder.c)entry.getValue()).b()).map(entry -> ((ResourceKey)entry.getKey()).a()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.d()) + ": " + String.valueOf(list));
        }
        if (this.m != null) {
            if (!this.m.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.m.values()));
            }
            this.m = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> f(T value) {
        if (this.m == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.b();
        return this.m.computeIfAbsent(value, valuex -> Holder.c.a(this.q(), valuex));
    }

    @Override
    public Optional<HolderSet.Named<T>> b(TagKey<T> tag) {
        return Optional.ofNullable(this.k.get(tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(Map<TagKey<T>, List<Holder<T>>> tagEntries) {
        IdentityHashMap<Holder.c, List> map = new IdentityHashMap<Holder.c, List>();
        this.g.values().forEach(entry -> map.put((Holder.c)entry, new ArrayList()));
        tagEntries.forEach((? super K tag, ? super V entries) -> {
            for (Holder holder : entries) {
                if (!holder.a(this.q())) {
                    throw new IllegalStateException("Can't create named set " + String.valueOf(tag) + " containing value " + String.valueOf(holder) + " from outside registry " + String.valueOf(this));
                }
                if (!(holder instanceof Holder.c)) {
                    throw new IllegalStateException("Found direct holder " + String.valueOf(holder) + " value in tag " + String.valueOf(tag));
                }
                Holder.c reference = (Holder.c)holder;
                ((List)map.get(reference)).add(tag);
            }
        });
        Sets.SetView set = Sets.difference(this.k.keySet(), tagEntries.keySet());
        if (!set.isEmpty()) {
            b.warn("Not all defined tags for registry {} are present in data pack: {}", this.d(), (Object)set.stream().map(tag -> tag.b().toString()).sorted().collect(Collectors.joining(", ")));
        }
        Object object = this.o;
        synchronized (object) {
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> map2 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.k);
            tagEntries.forEach((? super K tag, ? super V entries) -> map2.computeIfAbsent((TagKey<T>)tag, this::d).b(entries));
            map.forEach(Holder.c::a);
            this.k = map2;
        }
    }

    @Override
    public void n() {
        this.k.values().forEach(entryList -> entryList.b(List.of()));
        this.g.values().forEach(entry -> entry.a(Set.of()));
    }

    @Override
    public HolderGetter<T> o() {
        this.b();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return Optional.of(this.b(key));
            }

            @Override
            public Holder.c<T> b(ResourceKey<T> key) {
                return RegistryMaterials.this.i(key);
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return Optional.of(this.b(tag));
            }

            @Override
            public HolderSet.Named<T> b(TagKey<T> tag) {
                return RegistryMaterials.this.a(tag);
            }
        };
    }

    @Override
    public HolderOwner<T> p() {
        return this.n;
    }

    @Override
    public HolderLookup.b<T> q() {
        return this.n;
    }

    public void clearIntrusiveHolder(T instance) {
        if (this.m != null) {
            this.m.remove(instance);
        }
    }
}

