/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;

public class Vector3f {
    public static final StreamCodec<ByteBuf, Vector3f> a = new StreamCodec<ByteBuf, Vector3f>(){

        public Vector3f a(ByteBuf byteBuf) {
            return new Vector3f(byteBuf.readFloat(), byteBuf.readFloat(), byteBuf.readFloat());
        }

        public void a(ByteBuf byteBuf, Vector3f rotations) {
            byteBuf.writeFloat(rotations.b);
            byteBuf.writeFloat(rotations.c);
            byteBuf.writeFloat(rotations.d);
        }
    };
    protected final float b;
    protected final float c;
    protected final float d;

    public Vector3f(float pitch, float yaw, float roll) {
        this.b = !Float.isInfinite(pitch) && !Float.isNaN(pitch) ? pitch % 360.0f : 0.0f;
        this.c = !Float.isInfinite(yaw) && !Float.isNaN(yaw) ? yaw % 360.0f : 0.0f;
        this.d = !Float.isInfinite(roll) && !Float.isNaN(roll) ? roll % 360.0f : 0.0f;
    }

    public Vector3f(NBTTagList serialized) {
        this(serialized.i(0), serialized.i(1), serialized.i(2));
    }

    private Vector3f(float x2, float y2, float z2, Void dummy_var) {
        this.b = x2;
        this.c = y2;
        this.d = z2;
    }

    public static Vector3f createWithoutValidityChecks(float x2, float y2, float z2) {
        return new Vector3f(x2, y2, z2, null);
    }

    public NBTTagList a() {
        NBTTagList listTag = new NBTTagList();
        listTag.add(NBTTagFloat.a(this.b));
        listTag.add(NBTTagFloat.a(this.c));
        listTag.add(NBTTagFloat.a(this.d));
        return listTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Vector3f)) return false;
        Vector3f rotations = (Vector3f)object;
        if (this.b != rotations.b) return false;
        if (this.c != rotations.c) return false;
        if (this.d != rotations.d) return false;
        return true;
    }

    public float b() {
        return this.b;
    }

    public float c() {
        return this.c;
    }

    public float d() {
        return this.d;
    }

    public float e() {
        return MathHelper.g(this.b);
    }

    public float f() {
        return MathHelper.g(this.c);
    }

    public float g() {
        return MathHelper.g(this.d);
    }
}

