/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentMap
extends Iterable<TypedDataComponent<?>> {
    public static final DataComponentMap a = new DataComponentMap(){

        @Override
        @Nullable
        @Override
        public <T> T a(DataComponentType<? extends T> type) {
            return null;
        }

        @Override
        @Override
        public Set<DataComponentType<?>> b() {
            return Set.of();
        }

        @Override
        @Override
        public Iterator<TypedDataComponent<?>> iterator() {
            return Collections.emptyIterator();
        }
    };
    public static final Codec<DataComponentMap> b = DataComponentMap.b(DataComponentType.d);

    public static Codec<DataComponentMap> a(Codec<DataComponentType<?>> componentTypeCodec) {
        return DataComponentMap.b(Codec.dispatchedMap(componentTypeCodec, DataComponentType::c));
    }

    public static Codec<DataComponentMap> b(Codec<Map<DataComponentType<?>, Object>> typeToValueMapCodec) {
        return typeToValueMapCodec.flatComapMap(a::a, componentMap -> {
            int i2 = componentMap.d();
            if (i2 == 0) {
                return DataResult.success((Object)Reference2ObjectMaps.emptyMap());
            }
            Reference2ObjectArrayMap reference2ObjectMap = new Reference2ObjectArrayMap(i2);
            for (TypedDataComponent<?> typedDataComponent : componentMap) {
                if (typedDataComponent.a().d()) continue;
                reference2ObjectMap.put(typedDataComponent.a(), typedDataComponent.b());
            }
            return DataResult.success((Object)reference2ObjectMap);
        });
    }

    public static DataComponentMap a(final DataComponentMap base, final DataComponentMap overrides) {
        return new DataComponentMap(){

            @Override
            @Nullable
            @Override
            public <T> T a(DataComponentType<? extends T> type) {
                T object = overrides.a(type);
                if (object != null) {
                    return object;
                }
                return base.a(type);
            }

            @Override
            @Override
            public Set<DataComponentType<?>> b() {
                return Sets.union(base.b(), overrides.b());
            }
        };
    }

    public static a a() {
        return new a();
    }

    @Nullable
    public <T> T a(DataComponentType<? extends T> var1);

    public Set<DataComponentType<?>> b();

    default public boolean b(DataComponentType<?> type) {
        return this.a(type) != null;
    }

    default public <T> T a(DataComponentType<? extends T> type, T fallback) {
        T object = this.a(type);
        return object != null ? object : fallback;
    }

    @Nullable
    default public <T> TypedDataComponent<T> c(DataComponentType<T> type) {
        T object = this.a(type);
        return object != null ? new TypedDataComponent<T>(type, object) : null;
    }

    @Override
    @Override
    default public Iterator<TypedDataComponent<?>> iterator() {
        return Iterators.transform(this.b().iterator(), type -> Objects.requireNonNull(this.c((DataComponentType)type)));
    }

    default public Stream<TypedDataComponent<?>> c() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.d(), 1345), false);
    }

    default public int d() {
        return this.b().size();
    }

    default public boolean e() {
        return this.d() == 0;
    }

    default public DataComponentMap a(final Predicate<DataComponentType<?>> predicate) {
        return new DataComponentMap(){

            @Override
            @Nullable
            @Override
            public <T> T a(DataComponentType<? extends T> type) {
                return predicate.test(type) ? (T)DataComponentMap.this.a(type) : null;
            }

            @Override
            @Override
            public Set<DataComponentType<?>> b() {
                return Sets.filter(DataComponentMap.this.b(), predicate::test);
            }
        };
    }

    public static class net.minecraft.core.component.DataComponentMap$a {
        private final Reference2ObjectMap<DataComponentType<?>, Object> a = new Reference2ObjectArrayMap();

        net.minecraft.core.component.DataComponentMap$a() {
        }

        public <T> net.minecraft.core.component.DataComponentMap$a a(DataComponentType<T> type, @Nullable T value) {
            this.b(type, value);
            return this;
        }

        <T> void b(DataComponentType<T> type, @Nullable Object value) {
            if (value != null) {
                this.a.put(type, value);
            } else {
                this.a.remove(type);
            }
        }

        public net.minecraft.core.component.DataComponentMap$a a(DataComponentMap componentSet) {
            for (TypedDataComponent<?> typedDataComponent : componentSet) {
                this.a.put(typedDataComponent.a(), typedDataComponent.b());
            }
            return this;
        }

        public DataComponentMap a() {
            return net.minecraft.core.component.DataComponentMap$a.a(this.a);
        }

        private static DataComponentMap a(Map<DataComponentType<?>, Object> components) {
            if (components.isEmpty()) {
                return a;
            }
            if (components.size() < 8) {
                return new a((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectArrayMap(components));
            }
            return new a((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectOpenHashMap(components));
        }

        static final class a
        extends Record
        implements DataComponentMap {
            private final Reference2ObjectMap<DataComponentType<?>, Object> c;

            a(Reference2ObjectMap<DataComponentType<?>, Object> reference2ObjectMap) {
                this.c = reference2ObjectMap;
            }

            @Override
            @Nullable
            @Override
            public <T> T a(DataComponentType<? extends T> type) {
                return (T)this.c.get(type);
            }

            @Override
            @Override
            public boolean b(DataComponentType<?> type) {
                return this.c.containsKey(type);
            }

            @Override
            @Override
            public Set<DataComponentType<?>> b() {
                return this.c.keySet();
            }

            @Override
            @Override
            public Iterator<TypedDataComponent<?>> iterator() {
                return Iterators.transform((Iterator)Reference2ObjectMaps.fastIterator(this.c), TypedDataComponent::a);
            }

            @Override
            @Override
            public int d() {
                return this.c.size();
            }

            @Override
            @Override
            public String toString() {
                return this.c.toString();
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "map", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "map", "c"}, this, object);
            }

            public Reference2ObjectMap<DataComponentType<?>, Object> f() {
                return this.c;
            }
        }
    }
}

