/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenseBehaviorShears
extends DispenseBehaviorMaybe {
    @Override
    protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
        net.minecraft.world.item.ItemStack eventStack;
        IDispenseBehavior idispensebehavior;
        WorldServer worldserver = pointer.b();
        CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
        if (!BlockDispenser.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return stack;
        }
        if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.d.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).g())) != IDispenseBehavior.b && idispensebehavior != this) {
            idispensebehavior.dispense(pointer, eventStack);
            return stack;
        }
        if (!worldserver.x_()) {
            BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
            this.a(DispenseBehaviorShears.a(worldserver, blockposition) || DispenseBehaviorShears.tryShearLivingEntity(worldserver, blockposition, bukkitBlock, craftItem));
            if (this.b()) {
                stack.hurtAndBreak(1, worldserver, (EntityLiving)null, item -> {});
            }
        }
        return stack;
    }

    private static boolean a(WorldServer world, BlockPosition pos) {
        int i2;
        IBlockData iblockdata = world.a_(pos);
        if (iblockdata.a(TagsBlock.aH, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(BlockBeehive.c) && blockbase_blockdata.b() instanceof BlockBeehive) && (i2 = iblockdata.c(BlockBeehive.c).intValue()) >= 5) {
            world.a((EntityHuman)null, pos, SoundEffects.bX, SoundCategory.e, 1.0f, 1.0f);
            BlockBeehive.a(world, pos);
            ((BlockBeehive)iblockdata.b()).a((World)world, iblockdata, pos, (EntityHuman)null, TileEntityBeehive.ReleaseStatus.b);
            world.a((Entity)null, GameEvent.M, pos);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(WorldServer worldserver, BlockPosition blockposition, Block bukkitBlock, CraftItemStack craftItem) {
        List<Entity> list = worldserver.a(EntityLiving.class, new AxisAlignedBB(blockposition), IEntitySelector.f);
        for (EntityLiving entityLiving : list) {
            BlockShearEntityEvent event;
            IShearable ishearable;
            if (!(entityLiving instanceof IShearable) || !(ishearable = (IShearable)((Object)entityLiving)).a() || (event = CraftEventFactory.callBlockShearEntityEvent(entityLiving, bukkitBlock, craftItem, ishearable.generateDefaultDrops())).isCancelled()) continue;
            ishearable.shear(SoundCategory.e, CraftItemStack.asNMSCopy(event.getDrops()));
            worldserver.a((Entity)null, GameEvent.M, blockposition);
            return true;
        }
        return false;
    }
}

