/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final PackOutput.a e;
    private final Set<ResourceKey<LootTable>> f;
    private final List<a> g;
    private final CompletableFuture<HolderLookup.a> h;

    public LootTableProvider(PackOutput output, Set<ResourceKey<LootTable>> lootTableIds, List<a> lootTypeGenerators, CompletableFuture<HolderLookup.a> registryLookupFuture) {
        this.e = output.a(Registries.bc);
        this.g = lootTypeGenerators;
        this.f = lootTableIds;
        this.h = registryLookupFuture;
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        return this.h.thenCompose(registryLookup -> this.a(writer, (HolderLookup.a)registryLookup));
    }

    private CompletableFuture<?> a(CachedOutput writer, HolderLookup.a registryLookup) {
        RegistryMaterials<LootTable> writableRegistry = new RegistryMaterials<LootTable>(Registries.bc, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        this.g.forEach(arg_0 -> LootTableProvider.a(registryLookup, (Map)map, writableRegistry, arg_0));
        writableRegistry.m();
        ProblemReporter.a collector = new ProblemReporter.a();
        HolderGetter.a provider = new IRegistryCustom.c(List.of(writableRegistry)).d().b();
        LootCollector validationContext = new LootCollector(collector, LootContextParameterSets.q, provider);
        Sets.SetView set = Sets.difference(this.f, writableRegistry.g());
        for (ResourceKey resourceKey : set) {
            collector.b("Missing built-in table: " + String.valueOf(resourceKey.a()));
        }
        writableRegistry.i().forEach(entry -> ((LootTable)entry.a()).a(validationContext.a(((LootTable)entry.a()).a()).a("{" + String.valueOf(entry.h().a()) + "}", entry.h())));
        Multimap<String, String> multimap = collector.a();
        if (!multimap.isEmpty()) {
            multimap.forEach((name, message) -> d.warn("Found validation problem in {}: {}", name, message));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableRegistry.h().stream().map(entry -> {
            ResourceKey resourceKey = (ResourceKey)entry.getKey();
            LootTable lootTable = (LootTable)entry.getValue();
            Path path = this.e.a(resourceKey.a());
            return DebugReportProvider.a(writer, registryLookup, LootTable.d, lootTable, path);
        }).toArray(CompletableFuture[]::new));
    }

    private static MinecraftKey a(ResourceKey<LootTable> lootTableKey) {
        return lootTableKey.a();
    }

    @Override
    @Override
    public final String a() {
        return "Loot Tables";
    }

    private static /* synthetic */ void a(HolderLookup.a provider, Map map, IRegistryWritable writableRegistry, a lootTypeGenerator) {
        lootTypeGenerator.a().apply(provider).generate((lootTable, builder) -> {
            MinecraftKey resourceLocation = LootTableProvider.a(lootTable);
            MinecraftKey resourceLocation2 = map.put(RandomSequence.a(resourceLocation), resourceLocation);
            if (resourceLocation2 != null) {
                SystemUtils.b("Loot table random sequence seed collision on " + String.valueOf(resourceLocation2) + " and " + String.valueOf(lootTable.a()));
            }
            builder.a(resourceLocation);
            LootTable lootTable2 = builder.a(subProviderEntry.b).b();
            writableRegistry.a(lootTable, lootTable2, RegistrationInfo.a);
        });
    }

    public record a(Function<HolderLookup.a, LootTableSubProvider> a, LootContextParameterSet b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "provider;paramSet", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "provider;paramSet", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "provider;paramSet", "a", "b"}, this, object);
        }
    }
}

