/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.level.IMaterial;

public class SimpleCookingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final CookingBookCategory c;
    private final Item d;
    private final RecipeItemStack e;
    private final float f;
    private final int g;
    private final Map<String, Criterion<?>> h = new LinkedHashMap();
    @Nullable
    private String i;
    private final RecipeCooking.a<?> j;

    private SimpleCookingRecipeBuilder(RecipeCategory category, CookingBookCategory cookingCategory, IMaterial output, RecipeItemStack input, float experience, int cookingTime, RecipeCooking.a<?> recipeFactory) {
        this.b = category;
        this.c = cookingCategory;
        this.d = output.r();
        this.e = input;
        this.f = experience;
        this.g = cookingTime;
        this.j = recipeFactory;
    }

    public static <T extends RecipeCooking> SimpleCookingRecipeBuilder a(RecipeItemStack input, RecipeCategory category, IMaterial output, float experience, int cookingTime, RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory) {
        return new SimpleCookingRecipeBuilder(category, SimpleCookingRecipeBuilder.a(serializer, output), output, input, experience, cookingTime, recipeFactory);
    }

    public static SimpleCookingRecipeBuilder a(RecipeItemStack input, RecipeCategory category, IMaterial output, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, CookingBookCategory.a, output, input, experience, cookingTime, RecipeCampfire::new);
    }

    public static SimpleCookingRecipeBuilder b(RecipeItemStack input, RecipeCategory category, IMaterial output, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, SimpleCookingRecipeBuilder.c(output), output, input, experience, cookingTime, RecipeBlasting::new);
    }

    public static SimpleCookingRecipeBuilder c(RecipeItemStack input, RecipeCategory category, IMaterial output, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, SimpleCookingRecipeBuilder.b(output), output, input, experience, cookingTime, FurnaceRecipe::new);
    }

    public static SimpleCookingRecipeBuilder d(RecipeItemStack input, RecipeCategory category, IMaterial output, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, CookingBookCategory.a, output, input, experience, cookingTime, RecipeSmoking::new);
    }

    @Override
    public SimpleCookingRecipeBuilder b(String string, Criterion<?> criterion) {
        this.h.put(string, criterion);
        return this;
    }

    @Override
    public SimpleCookingRecipeBuilder b(@Nullable String string) {
        this.i = string;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.d;
    }

    @Override
    @Override
    public void a(RecipeOutput exporter, MinecraftKey recipeId) {
        this.a(recipeId);
        Advancement.SerializedAdvancement builder = exporter.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.a(recipeId)).a(AdvancementRequirements.a.b);
        this.h.forEach(builder::a);
        Object abstractCookingRecipe = this.j.create(Objects.requireNonNullElse(this.i, ""), this.c, this.e, new ItemStack(this.d), this.f, this.g);
        exporter.a(recipeId, (IRecipe<?>)abstractCookingRecipe, builder.b(recipeId.f("recipes/" + this.b.a() + "/")));
    }

    private static CookingBookCategory b(IMaterial output) {
        if (output.r().p().b(DataComponents.v)) {
            return CookingBookCategory.a;
        }
        if (output.r() instanceof ItemBlock) {
            return CookingBookCategory.b;
        }
        return CookingBookCategory.c;
    }

    private static CookingBookCategory c(IMaterial output) {
        if (output.r() instanceof ItemBlock) {
            return CookingBookCategory.b;
        }
        return CookingBookCategory.c;
    }

    private static CookingBookCategory a(RecipeSerializer<? extends RecipeCooking> serializer, IMaterial output) {
        if (serializer == RecipeSerializer.p) {
            return SimpleCookingRecipeBuilder.b(output);
        }
        if (serializer == RecipeSerializer.q) {
            return SimpleCookingRecipeBuilder.c(output);
        }
        if (serializer == RecipeSerializer.r || serializer == RecipeSerializer.s) {
            return CookingBookCategory.a;
        }
        throw new IllegalStateException("Unknown cooking recipe type");
    }

    private void a(MinecraftKey recipeId) {
        if (this.h.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.b(group);
    }

    public /* synthetic */ RecipeBuilder a(String name, Criterion criterion) {
        return this.b(name, criterion);
    }
}

