/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;

public abstract class TagsProvider<T>
implements DebugReportProvider {
    protected final PackOutput.a e;
    private final CompletableFuture<HolderLookup.a> d;
    private final CompletableFuture<Void> g = new CompletableFuture();
    private final CompletableFuture<c<T>> h;
    protected final ResourceKey<? extends IRegistry<T>> f;
    private final Map<MinecraftKey, TagBuilder> i = Maps.newLinkedHashMap();

    protected TagsProvider(PackOutput output, ResourceKey<? extends IRegistry<T>> registryRef, CompletableFuture<HolderLookup.a> registryLookupFuture) {
        this(output, registryRef, registryLookupFuture, CompletableFuture.completedFuture(c.empty()));
    }

    protected TagsProvider(PackOutput output, ResourceKey<? extends IRegistry<T>> registryRef, CompletableFuture<HolderLookup.a> registryLookupFuture, CompletableFuture<c<T>> parentTagLookupFuture) {
        this.e = output.b(registryRef);
        this.f = registryRef;
        this.h = parentTagLookupFuture;
        this.d = registryLookupFuture;
    }

    @Override
    @Override
    public final String a() {
        return "Tags for " + String.valueOf(this.f.a());
    }

    protected abstract void a(HolderLookup.a var1);

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        record A<T>(HolderLookup.a a, c<T> b) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this, object);
            }
        }
        return ((CompletableFuture)((CompletableFuture)this.b().thenApply(registryLookupFuture -> {
            this.g.complete(null);
            return registryLookupFuture;
        })).thenCombineAsync(this.h, (lookup, parent) -> new A((HolderLookup.a)lookup, parent), (Executor)SystemUtils.g())).thenCompose(info -> {
            HolderLookup.b registryLookup = info.a.b(this.f);
            Predicate<MinecraftKey> predicate = id -> registryLookup.a(ResourceKey.a(this.f, id)).isPresent();
            Predicate<MinecraftKey> predicate2 = id -> this.i.containsKey(id) || arg.b.contains(TagKey.a(this.f, id));
            return CompletableFuture.allOf((CompletableFuture[])this.i.entrySet().stream().map(entry -> {
                MinecraftKey resourceLocation = (MinecraftKey)entry.getKey();
                TagBuilder tagBuilder = (TagBuilder)entry.getValue();
                List<TagEntry> list = tagBuilder.b();
                List<TagEntry> list2 = list.stream().filter(tagEntry -> !tagEntry.a(predicate, predicate2)).toList();
                if (!list2.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", resourceLocation, list2.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                Path path = this.e.a(resourceLocation);
                return DebugReportProvider.a(writer, arg.a, TagFile.a, new TagFile(list, false), path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected b<T> b(TagKey<T> tag) {
        TagBuilder tagBuilder = this.c(tag);
        return new b(tagBuilder);
    }

    protected TagBuilder c(TagKey<T> tag) {
        return this.i.computeIfAbsent(tag.b(), id -> TagBuilder.a());
    }

    public CompletableFuture<c<T>> c() {
        return this.g.thenApply(void_ -> tag -> Optional.ofNullable(this.i.get(tag.b())));
    }

    protected CompletableFuture<HolderLookup.a> b() {
        return this.d.thenApply(lookup -> {
            this.i.clear();
            this.a((HolderLookup.a)lookup);
            return lookup;
        });
    }

    @FunctionalInterface
    public static interface c<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> c<T> empty() {
            return tag -> Optional.empty();
        }

        default public boolean contains(TagKey<T> tag) {
            return ((Optional)this.apply(tag)).isPresent();
        }
    }

    protected static class b<T> {
        private final TagBuilder a;

        protected b(TagBuilder builder) {
            this.a = builder;
        }

        public final b<T> a(ResourceKey<T> key) {
            this.a.a(key.a());
            return this;
        }

        @SafeVarargs
        public final b<T> a(ResourceKey<T> ... keys) {
            for (ResourceKey<T> resourceKey : keys) {
                this.a.a(resourceKey.a());
            }
            return this;
        }

        public final b<T> a(List<ResourceKey<T>> keys) {
            for (ResourceKey<T> resourceKey : keys) {
                this.a.a(resourceKey.a());
            }
            return this;
        }

        public b<T> a(MinecraftKey id) {
            this.a.b(id);
            return this;
        }

        public b<T> b(TagKey<T> identifiedTag) {
            this.a.c(identifiedTag.b());
            return this;
        }

        public b<T> b(MinecraftKey id) {
            this.a.d(id);
            return this;
        }
    }
}

