/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class GameTestHarnessStructures {
    private static final Logger d = LogUtils.getLogger();
    public static final int a = 10;
    public static final String b = "gameteststructures";
    public static String c = "gameteststructures";

    public static EnumBlockRotation a(int steps) {
        switch (steps) {
            case 0: {
                return EnumBlockRotation.a;
            }
            case 1: {
                return EnumBlockRotation.b;
            }
            case 2: {
                return EnumBlockRotation.c;
            }
            case 3: {
                return EnumBlockRotation.d;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + steps);
    }

    public static int a(EnumBlockRotation rotation) {
        switch (rotation) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf(rotation));
    }

    public static AxisAlignedBB a(TileEntityStructure structureBlockEntity) {
        return AxisAlignedBB.a(GameTestHarnessStructures.b(structureBlockEntity));
    }

    public static StructureBoundingBox b(TileEntityStructure structureBlockEntity) {
        BlockPosition blockPos = GameTestHarnessStructures.c(structureBlockEntity);
        BlockPosition blockPos2 = GameTestHarnessStructures.a(blockPos, structureBlockEntity.j(), structureBlockEntity.l());
        return StructureBoundingBox.a(blockPos, blockPos2);
    }

    public static BlockPosition c(TileEntityStructure structureBlockEntity) {
        return structureBlockEntity.aD_().a(structureBlockEntity.f());
    }

    public static void a(BlockPosition pos, BlockPosition relativePos, EnumBlockRotation rotation, WorldServer world) {
        BlockPosition blockPos = DefinedStructure.a(pos.a(relativePos), EnumBlockMirror.a, rotation, pos);
        world.b(blockPos, Blocks.fN.o());
        TileEntityCommand commandBlockEntity = (TileEntityCommand)world.c_(blockPos);
        commandBlockEntity.b().a("test runclosest");
        BlockPosition blockPos2 = DefinedStructure.a(blockPos.b(0, 0, -1), EnumBlockMirror.a, rotation, blockPos);
        world.b(blockPos2, Blocks.dM.o().a(rotation));
    }

    public static void a(String testName, BlockPosition pos, BaseBlockPosition relativePos, EnumBlockRotation rotation, WorldServer world) {
        StructureBoundingBox boundingBox = GameTestHarnessStructures.b(pos.d(), relativePos, rotation);
        GameTestHarnessStructures.a(boundingBox, world);
        world.b(pos, Blocks.pa.o());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        structureBlockEntity.a(false);
        structureBlockEntity.a(MinecraftKey.a(testName));
        structureBlockEntity.a(relativePos);
        structureBlockEntity.a(BlockPropertyStructureMode.a);
        structureBlockEntity.e(true);
    }

    /*
     * WARNING - void declaration
     */
    public static TileEntityStructure a(GameTestHarnessInfo state, BlockPosition pos, EnumBlockRotation rotation, WorldServer world) {
        void blockPos5;
        BaseBlockPosition vec3i = world.q().b(MinecraftKey.a(state.s())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + state.s())).a();
        StructureBoundingBox boundingBox = GameTestHarnessStructures.b(pos, vec3i, rotation);
        if (rotation == EnumBlockRotation.a) {
            BlockPosition blockPos = pos;
        } else if (rotation == EnumBlockRotation.b) {
            BlockPosition blockPos2 = pos.b(vec3i.w() - 1, 0, 0);
        } else if (rotation == EnumBlockRotation.c) {
            BlockPosition blockPos3 = pos.b(vec3i.u() - 1, 0, vec3i.w() - 1);
        } else if (rotation == EnumBlockRotation.d) {
            BlockPosition blockPos4 = pos.b(0, 0, vec3i.u() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + String.valueOf(rotation));
        }
        GameTestHarnessStructures.b(boundingBox, world);
        GameTestHarnessStructures.a(boundingBox, world);
        return GameTestHarnessStructures.b(state, blockPos5.e(), rotation, world);
    }

    public static void a(AxisAlignedBB box, WorldServer world, boolean noSkyAccess) {
        BlockPosition blockPos = BlockPosition.a(box.a, box.b, box.c).b(-1, 0, -1);
        BlockPosition blockPos2 = BlockPosition.a(box.d, box.e, box.f);
        BlockPosition.d(blockPos, blockPos2).forEach(pos -> {
            boolean bl3;
            boolean bl2 = pos.u() == blockPos.u() || pos.u() == blockPos2.u() || pos.w() == blockPos.w() || pos.w() == blockPos2.w();
            boolean bl4 = bl3 = pos.v() == blockPos2.v();
            if (bl2 || bl3 && noSkyAccess) {
                world.b((BlockPosition)pos, Blocks.hW.o());
            }
        });
    }

    public static void a(AxisAlignedBB box, WorldServer world) {
        BlockPosition blockPos = BlockPosition.a(box.a, box.b, box.c).b(-1, 0, -1);
        BlockPosition blockPos2 = BlockPosition.a(box.d, box.e, box.f);
        BlockPosition.d(blockPos, blockPos2).forEach(pos -> {
            boolean bl2;
            boolean bl = pos.u() == blockPos.u() || pos.u() == blockPos2.u() || pos.w() == blockPos.w() || pos.w() == blockPos2.w();
            boolean bl3 = bl2 = pos.v() == blockPos2.v();
            if (world.a_((BlockPosition)pos).a(Blocks.hW) && (bl || bl2)) {
                world.b((BlockPosition)pos, Blocks.a.o());
            }
        });
    }

    private static void b(StructureBoundingBox box, WorldServer world) {
        box.b().forEach(chunkPos -> world.a(chunkPos.e, chunkPos.f, true));
    }

    public static void a(StructureBoundingBox area, WorldServer world) {
        int i2 = area.i() - 1;
        StructureBoundingBox boundingBox = new StructureBoundingBox(area.h() - 2, area.i() - 3, area.j() - 3, area.k() + 3, area.l() + 20, area.m() + 3);
        BlockPosition.a(boundingBox).forEach(pos -> GameTestHarnessStructures.a(i2, pos, world));
        world.m().a(boundingBox);
        world.a(boundingBox);
        AxisAlignedBB aABB = AxisAlignedBB.a(boundingBox);
        List<Entity> list = world.a(Entity.class, aABB, entity -> !(entity instanceof EntityHuman));
        list.forEach(Entity::aq);
    }

    public static BlockPosition a(BlockPosition pos, BaseBlockPosition size, EnumBlockRotation rotation) {
        BlockPosition blockPos = pos.a(size).b(-1, -1, -1);
        return DefinedStructure.a(blockPos, EnumBlockMirror.a, rotation, pos);
    }

    public static StructureBoundingBox b(BlockPosition pos, BaseBlockPosition relativePos, EnumBlockRotation rotation) {
        BlockPosition blockPos = GameTestHarnessStructures.a(pos, relativePos, rotation);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(pos, blockPos);
        int i2 = Math.min(boundingBox.h(), boundingBox.k());
        int j2 = Math.min(boundingBox.j(), boundingBox.m());
        return boundingBox.a(pos.u() - i2, 0, pos.w() - j2);
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int radius, WorldServer world) {
        return GameTestHarnessStructures.c(pos, radius, world).filter(structureBlockPos -> GameTestHarnessStructures.a(structureBlockPos, pos, world)).findFirst();
    }

    public static Optional<BlockPosition> b(BlockPosition pos, int radius, WorldServer world) {
        Comparator<BlockPosition> comparator = Comparator.comparingInt(posx -> posx.k(pos));
        return GameTestHarnessStructures.c(pos, radius, world).min(comparator);
    }

    public static Stream<BlockPosition> a(BlockPosition pos, int radius, WorldServer world, String templateName) {
        return GameTestHarnessStructures.c(pos, radius, world).map(posx -> (TileEntityStructure)world.c_((BlockPosition)posx)).filter(Objects::nonNull).filter(blockEntity -> Objects.equals(blockEntity.c(), templateName)).map(TileEntity::aD_).map(BlockPosition::j);
    }

    public static Stream<BlockPosition> c(BlockPosition pos, int radius, WorldServer world) {
        StructureBoundingBox boundingBox = GameTestHarnessStructures.d(pos, radius, world);
        return BlockPosition.a(boundingBox).filter(p2 -> world.a_((BlockPosition)p2).a(Blocks.pa)).map(BlockPosition::j);
    }

    private static TileEntityStructure b(GameTestHarnessInfo state, BlockPosition pos, EnumBlockRotation rotation, WorldServer world) {
        world.b(pos, Blocks.pa.o());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(pos);
        structureBlockEntity.a(BlockPropertyStructureMode.b);
        structureBlockEntity.a(rotation);
        structureBlockEntity.a(false);
        structureBlockEntity.a(MinecraftKey.a(state.s()));
        structureBlockEntity.b(state.b());
        if (!structureBlockEntity.b(world)) {
            throw new RuntimeException("Failed to load structure info for test: " + state.b() + ". Structure name: " + state.s());
        }
        return structureBlockEntity;
    }

    private static StructureBoundingBox d(BlockPosition pos, int radius, WorldServer world) {
        BlockPosition blockPos = BlockPosition.a((double)pos.u(), (double)world.a(HeightMap.Type.b, pos).v(), (double)pos.w());
        return new StructureBoundingBox(blockPos).c(radius, 10, radius);
    }

    public static Stream<BlockPosition> a(BlockPosition pos, Entity entity, WorldServer world) {
        int i2 = 200;
        Vec3D vec3 = entity.by();
        Vec3D vec32 = vec3.e(entity.bM().a(200.0));
        return GameTestHarnessStructures.c(pos, 200, world).map(p2 -> world.a((BlockPosition)p2, TileEntityTypes.u)).flatMap(Optional::stream).filter(blockEntity -> GameTestHarnessStructures.a(blockEntity).b(vec3, vec32).isPresent()).map(TileEntity::aD_).sorted(Comparator.comparing(pos::j)).limit(1L);
    }

    private static void a(int altitude, BlockPosition pos, WorldServer world) {
        IBlockData blockState2;
        if (pos.v() < altitude) {
            IBlockData blockState = Blocks.b.o();
        } else {
            blockState2 = Blocks.a.o();
        }
        ArgumentTileLocation blockInput = new ArgumentTileLocation(blockState2, Collections.emptySet(), null);
        blockInput.a(world, pos, 2);
        world.b(pos, blockState2.b());
    }

    private static boolean a(BlockPosition structureBlockPos, BlockPosition pos, WorldServer world) {
        TileEntityStructure structureBlockEntity = (TileEntityStructure)world.c_(structureBlockPos);
        return GameTestHarnessStructures.b(structureBlockEntity).b(pos);
    }
}

