/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.gametest.framework.GameTestHarnessITestReporter;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitLikeTestReporter
implements GameTestHarnessITestReporter {
    private final Document a;
    private final Element b;
    private final Stopwatch c;
    private final File d;

    public JUnitLikeTestReporter(File file) throws ParserConfigurationException {
        this.d = file;
        this.a = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.b = this.a.createElement("testsuite");
        Element element = this.a.createElement("testsuite");
        element.appendChild(this.b);
        this.a.appendChild(element);
        this.b.setAttribute("timestamp", DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        this.c = Stopwatch.createStarted();
    }

    private Element a(GameTestHarnessInfo test, String name) {
        Element element = this.a.createElement("testcase");
        element.setAttribute("name", name);
        element.setAttribute("classname", test.s());
        element.setAttribute("time", String.valueOf((double)test.k() / 1000.0));
        this.b.appendChild(element);
        return element;
    }

    @Override
    @Override
    public void a(GameTestHarnessInfo test) {
        String string = test.b();
        String string2 = test.m().getMessage();
        Element element = this.a.createElement(test.q() ? "failure" : "skipped");
        element.setAttribute("message", "(" + test.c().x() + ") " + string2);
        Element element2 = this.a(test, string);
        element2.appendChild(element);
    }

    @Override
    @Override
    public void b(GameTestHarnessInfo test) {
        String string = test.b();
        this.a(test, string);
    }

    @Override
    @Override
    public void a() {
        this.c.stop();
        this.b.setAttribute("time", String.valueOf((double)this.c.elapsed(TimeUnit.MILLISECONDS) / 1000.0));
        try {
            this.a(this.d);
        }
        catch (TransformerException transformerException) {
            throw new Error("Couldn't save test report", transformerException);
        }
    }

    public void a(File file) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(this.a);
        StreamResult streamResult = new StreamResult(file);
        transformer.transform(dOMSource, streamResult);
    }
}

