/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;

public class ChatModifier {
    public static final ChatModifier a = new ChatModifier(null, null, null, null, null, null, null, null, null, null);
    public static final MinecraftKey b = MinecraftKey.b("default");
    @Nullable
    final ChatHexColor c;
    @Nullable
    final Boolean d;
    @Nullable
    final Boolean e;
    @Nullable
    final Boolean f;
    @Nullable
    final Boolean g;
    @Nullable
    final Boolean h;
    @Nullable
    final ChatClickable i;
    @Nullable
    final ChatHoverable j;
    @Nullable
    final String k;
    @Nullable
    final MinecraftKey l;

    private static ChatModifier a(Optional<ChatHexColor> color, Optional<Boolean> bold, Optional<Boolean> italic, Optional<Boolean> underlined, Optional<Boolean> strikethrough, Optional<Boolean> obfuscated, Optional<ChatClickable> optional, Optional<ChatHoverable> optional2, Optional<String> optional3, Optional<MinecraftKey> optional4) {
        ChatModifier style = new ChatModifier(color.orElse(null), bold.orElse(null), italic.orElse(null), underlined.orElse(null), strikethrough.orElse(null), obfuscated.orElse(null), optional.orElse(null), optional2.orElse(null), optional3.orElse(null), optional4.orElse(null));
        if (style.equals(a)) {
            return a;
        }
        return style;
    }

    private ChatModifier(@Nullable ChatHexColor color, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable ChatClickable clickEvent, @Nullable ChatHoverable hoverEvent, @Nullable String insertion, @Nullable MinecraftKey font) {
        this.c = color;
        this.d = bold;
        this.e = italic;
        this.f = underlined;
        this.g = strikethrough;
        this.h = obfuscated;
        this.i = clickEvent;
        this.j = hoverEvent;
        this.k = insertion;
        this.l = font;
    }

    @Nullable
    public ChatHexColor a() {
        return this.c;
    }

    public boolean b() {
        return this.d == Boolean.TRUE;
    }

    public boolean c() {
        return this.e == Boolean.TRUE;
    }

    public boolean d() {
        return this.g == Boolean.TRUE;
    }

    public boolean e() {
        return this.f == Boolean.TRUE;
    }

    public boolean f() {
        return this.h == Boolean.TRUE;
    }

    public boolean g() {
        return this == a;
    }

    @Nullable
    public ChatClickable h() {
        return this.i;
    }

    @Nullable
    public ChatHoverable i() {
        return this.j;
    }

    @Nullable
    public String j() {
        return this.k;
    }

    public MinecraftKey k() {
        return this.l != null ? this.l : b;
    }

    private static <T> ChatModifier a(ChatModifier newStyle, @Nullable T oldAttribute, @Nullable T newAttribute) {
        if (oldAttribute != null && newAttribute == null && newStyle.equals(a)) {
            return a;
        }
        return newStyle;
    }

    public ChatModifier a(@Nullable ChatHexColor color) {
        if (Objects.equals(this.c, color)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(color, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.c, color);
    }

    public ChatModifier a(@Nullable EnumChatFormat color) {
        return this.a(color != null ? ChatHexColor.a(color) : null);
    }

    public ChatModifier a(int rgbColor) {
        return this.a(ChatHexColor.a(rgbColor));
    }

    public ChatModifier a(@Nullable Boolean bold) {
        if (Objects.equals(this.d, bold)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, bold, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.d, bold);
    }

    public ChatModifier b(@Nullable Boolean italic) {
        if (Objects.equals(this.e, italic)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, italic, this.f, this.g, this.h, this.i, this.j, this.k, this.l), this.e, italic);
    }

    public ChatModifier c(@Nullable Boolean underline) {
        if (Objects.equals(this.f, underline)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, underline, this.g, this.h, this.i, this.j, this.k, this.l), this.f, underline);
    }

    public ChatModifier d(@Nullable Boolean strikethrough) {
        if (Objects.equals(this.g, strikethrough)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, strikethrough, this.h, this.i, this.j, this.k, this.l), this.g, strikethrough);
    }

    public ChatModifier e(@Nullable Boolean obfuscated) {
        if (Objects.equals(this.h, obfuscated)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, obfuscated, this.i, this.j, this.k, this.l), this.h, obfuscated);
    }

    public ChatModifier a(@Nullable ChatClickable clickEvent) {
        if (Objects.equals(this.i, clickEvent)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, clickEvent, this.j, this.k, this.l), this.i, clickEvent);
    }

    public ChatModifier a(@Nullable ChatHoverable hoverEvent) {
        if (Objects.equals(this.j, hoverEvent)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, hoverEvent, this.k, this.l), this.j, hoverEvent);
    }

    public ChatModifier a(@Nullable String insertion) {
        if (Objects.equals(this.k, insertion)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, insertion, this.l), this.k, insertion);
    }

    public ChatModifier a(@Nullable MinecraftKey font) {
        if (Objects.equals(this.l, font)) {
            return this;
        }
        return ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, font), this.l, font);
    }

    public ChatModifier b(EnumChatFormat formatting) {
        ChatHexColor textColor = this.c;
        Boolean boolean_ = this.d;
        Boolean boolean2 = this.e;
        Boolean boolean3 = this.g;
        Boolean boolean4 = this.f;
        Boolean boolean5 = this.h;
        switch (formatting) {
            case q: {
                boolean5 = true;
                break;
            }
            case r: {
                boolean_ = true;
                break;
            }
            case s: {
                boolean3 = true;
                break;
            }
            case t: {
                boolean4 = true;
                break;
            }
            case u: {
                boolean2 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.i, this.j, this.k, this.l);
    }

    public ChatModifier c(EnumChatFormat formatting) {
        ChatHexColor textColor = this.c;
        Boolean boolean_ = this.d;
        Boolean boolean2 = this.e;
        Boolean boolean3 = this.g;
        Boolean boolean4 = this.f;
        Boolean boolean5 = this.h;
        switch (formatting) {
            case q: {
                boolean5 = true;
                break;
            }
            case r: {
                boolean_ = true;
                break;
            }
            case s: {
                boolean3 = true;
                break;
            }
            case t: {
                boolean4 = true;
                break;
            }
            case u: {
                boolean2 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                boolean5 = false;
                boolean_ = false;
                boolean3 = false;
                boolean4 = false;
                boolean2 = false;
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(EnumChatFormat ... formattings) {
        ChatHexColor textColor = this.c;
        Boolean boolean_ = this.d;
        Boolean boolean2 = this.e;
        Boolean boolean3 = this.g;
        Boolean boolean4 = this.f;
        Boolean boolean5 = this.h;
        block8: for (EnumChatFormat chatFormatting : formattings) {
            switch (chatFormatting) {
                case q: {
                    boolean5 = true;
                    continue block8;
                }
                case r: {
                    boolean_ = true;
                    continue block8;
                }
                case s: {
                    boolean3 = true;
                    continue block8;
                }
                case t: {
                    boolean4 = true;
                    continue block8;
                }
                case u: {
                    boolean2 = true;
                    continue block8;
                }
                case v: {
                    return a;
                }
                default: {
                    textColor = ChatHexColor.a(chatFormatting);
                }
            }
        }
        return new ChatModifier(textColor, boolean_, boolean2, boolean4, boolean3, boolean5, this.i, this.j, this.k, this.l);
    }

    public ChatModifier a(ChatModifier parent) {
        if (this == a) {
            return parent;
        }
        if (parent == a) {
            return this;
        }
        return new ChatModifier(this.c != null ? this.c : parent.c, this.d != null ? this.d : parent.d, this.e != null ? this.e : parent.e, this.f != null ? this.f : parent.f, this.g != null ? this.g : parent.g, this.h != null ? this.h : parent.h, this.i != null ? this.i : parent.i, this.j != null ? this.j : parent.j, this.k != null ? this.k : parent.k, this.l != null ? this.l : parent.l);
    }

    @Override
    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        class A {
            private boolean b;

            A() {
            }

            private void a() {
                if (this.b) {
                    stringBuilder.append(',');
                }
                this.b = true;
            }

            void a(String key, @Nullable Boolean value) {
                if (value != null) {
                    this.a();
                    if (!value.booleanValue()) {
                        stringBuilder.append('!');
                    }
                    stringBuilder.append(key);
                }
            }

            void a(String key, @Nullable Object value) {
                if (value != null) {
                    this.a();
                    stringBuilder.append(key);
                    stringBuilder.append('=');
                    stringBuilder.append(value);
                }
            }
        }
        A lv = new A();
        lv.a("color", this.c);
        lv.a("bold", this.d);
        lv.a("italic", this.e);
        lv.a("underlined", this.f);
        lv.a("strikethrough", this.g);
        lv.a("obfuscated", this.h);
        lv.a("clickEvent", this.i);
        lv.a("hoverEvent", this.j);
        lv.a("insertion", this.k);
        lv.a("font", this.l);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChatModifier) {
            ChatModifier style = (ChatModifier)object;
            return this.d == style.d && Objects.equals(this.a(), style.a()) && this.e == style.e && this.h == style.h && this.g == style.g && this.f == style.f && Objects.equals(this.i, style.i) && Objects.equals(this.j, style.j) && Objects.equals(this.k, style.k) && Objects.equals(this.l, style.l);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k);
    }

    public static class ChatModifierSerializer {
        public static final MapCodec<ChatModifier> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChatHexColor.a.optionalFieldOf("color").forGetter(style -> Optional.ofNullable(style.c)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(style -> Optional.ofNullable(style.d)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(style -> Optional.ofNullable(style.e)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(style -> Optional.ofNullable(style.f)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(style -> Optional.ofNullable(style.g)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(style -> Optional.ofNullable(style.h)), (App)ChatClickable.a.optionalFieldOf("clickEvent").forGetter(style -> Optional.ofNullable(style.i)), (App)ChatHoverable.a.optionalFieldOf("hoverEvent").forGetter(style -> Optional.ofNullable(style.j)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(style -> Optional.ofNullable(style.k)), (App)MinecraftKey.a.optionalFieldOf("font").forGetter(style -> Optional.ofNullable(style.l))).apply((Applicative)instance, ChatModifier::a));
        public static final Codec<ChatModifier> b = a.codec();
        public static final StreamCodec<RegistryFriendlyByteBuf, ChatModifier> c = ByteBufCodecs.c(b);
    }
}

