/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface ByteBufCodecs {
    public static final int a = 65536;
    public static final StreamCodec<ByteBuf, Boolean> b = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public Boolean a(ByteBuf byteBuf) {
            return byteBuf.readBoolean();
        }

        @Override
        public void a(ByteBuf byteBuf, Boolean boolean_) {
            byteBuf.writeBoolean(boolean_.booleanValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Boolean)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Byte> c = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public Byte a(ByteBuf byteBuf) {
            return byteBuf.readByte();
        }

        @Override
        public void a(ByteBuf byteBuf, Byte byte_) {
            byteBuf.writeByte((int)byte_.byteValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Byte)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Short> d = new StreamCodec<ByteBuf, Short>(){

        @Override
        public Short a(ByteBuf byteBuf) {
            return byteBuf.readShort();
        }

        @Override
        public void a(ByteBuf byteBuf, Short short_) {
            byteBuf.writeShort((int)short_.shortValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Short)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> e = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer a(ByteBuf byteBuf) {
            return byteBuf.readUnsignedShort();
        }

        @Override
        public void a(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeShort(integer.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> f = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer a(ByteBuf byteBuf) {
            return byteBuf.readInt();
        }

        @Override
        public void a(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeInt(integer.intValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> g = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer a(ByteBuf byteBuf) {
            return VarInt.a(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, Integer integer) {
            VarInt.a(byteBuf, integer);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Integer)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Long> h = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long a(ByteBuf byteBuf) {
            return VarLong.a(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, Long long_) {
            VarLong.a(byteBuf, long_);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Long)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Float> i = new StreamCodec<ByteBuf, Float>(){

        @Override
        public Float a(ByteBuf byteBuf) {
            return Float.valueOf(byteBuf.readFloat());
        }

        @Override
        public void a(ByteBuf byteBuf, Float float_) {
            byteBuf.writeFloat(float_.floatValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Float)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Double> j = new StreamCodec<ByteBuf, Double>(){

        @Override
        public Double a(ByteBuf byteBuf) {
            return byteBuf.readDouble();
        }

        @Override
        public void a(ByteBuf byteBuf, Double double_) {
            byteBuf.writeDouble(double_.doubleValue());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Double)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> k = new StreamCodec<ByteBuf, byte[]>(){

        @Override
        public byte[] a(ByteBuf byteBuf) {
            return PacketDataSerializer.a(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, byte[] bs) {
            PacketDataSerializer.a(byteBuf, bs);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (byte[])value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, String> l = ByteBufCodecs.b(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, NBTBase> m = ByteBufCodecs.a(() -> NBTReadLimiter.a(0x200000L));
    public static final StreamCodec<ByteBuf, NBTBase> n = ByteBufCodecs.a(NBTReadLimiter::a);
    public static final StreamCodec<ByteBuf, NBTTagCompound> o = ByteBufCodecs.b(() -> NBTReadLimiter.a(0x200000L));
    public static final StreamCodec<ByteBuf, NBTTagCompound> p = ByteBufCodecs.b(NBTReadLimiter::a);
    public static final StreamCodec<ByteBuf, Optional<NBTTagCompound>> q = new StreamCodec<ByteBuf, Optional<NBTTagCompound>>(){

        @Override
        public Optional<NBTTagCompound> a(ByteBuf byteBuf) {
            return Optional.ofNullable(PacketDataSerializer.f(byteBuf));
        }

        @Override
        public void a(ByteBuf byteBuf, Optional<NBTTagCompound> optional) {
            PacketDataSerializer.a(byteBuf, optional.orElse(null));
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Optional)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Vector3f> r = new StreamCodec<ByteBuf, Vector3f>(){

        @Override
        public Vector3f a(ByteBuf byteBuf) {
            return PacketDataSerializer.c(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, Vector3f vector3f) {
            PacketDataSerializer.a(byteBuf, vector3f);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Vector3f)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionf> s = new StreamCodec<ByteBuf, Quaternionf>(){

        @Override
        public Quaternionf a(ByteBuf byteBuf) {
            return PacketDataSerializer.d(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, Quaternionf quaternionf) {
            PacketDataSerializer.a(byteBuf, quaternionf);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Quaternionf)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> t = new StreamCodec<ByteBuf, PropertyMap>(){
        private static final int a = 64;
        private static final int b = Short.MAX_VALUE;
        private static final int c = 1024;
        private static final int d = 16;

        @Override
        public PropertyMap a(ByteBuf byteBuf) {
            int i2 = ByteBufCodecs.a(byteBuf, 16);
            PropertyMap propertyMap = new PropertyMap();
            for (int j2 = 0; j2 < i2; ++j2) {
                String string = Utf8String.a(byteBuf, 64);
                String string2 = Utf8String.a(byteBuf, Short.MAX_VALUE);
                String string3 = PacketDataSerializer.a(byteBuf, (? super B buf2) -> Utf8String.a(buf2, 1024));
                Property property = new Property(string, string2, string3);
                propertyMap.put((Object)property.name(), (Object)property);
            }
            return propertyMap;
        }

        @Override
        public void a(ByteBuf byteBuf, PropertyMap propertyMap) {
            ByteBufCodecs.a(byteBuf, propertyMap.size(), 16);
            for (Property property : propertyMap.values()) {
                Utf8String.a(byteBuf, property.name(), 64);
                Utf8String.a(byteBuf, property.value(), Short.MAX_VALUE);
                PacketDataSerializer.a(byteBuf, property.signature(), (? super B buf2, T signature) -> Utf8String.a(buf2, signature, 1024));
            }
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (PropertyMap)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final StreamCodec<ByteBuf, GameProfile> u = new StreamCodec<ByteBuf, GameProfile>(){

        @Override
        public GameProfile a(ByteBuf byteBuf) {
            UUID uUID = (UUID)UUIDUtil.g.decode(byteBuf);
            String string = Utf8String.a(byteBuf, 16);
            GameProfile gameProfile = new GameProfile(uUID, string);
            gameProfile.getProperties().putAll((Multimap)t.decode(byteBuf));
            return gameProfile;
        }

        @Override
        public void a(ByteBuf byteBuf, GameProfile gameProfile) {
            UUIDUtil.g.encode(byteBuf, gameProfile.getId());
            Utf8String.a(byteBuf, gameProfile.getName(), 16);
            t.encode(byteBuf, gameProfile.getProperties());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (GameProfile)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };

    public static StreamCodec<ByteBuf, byte[]> a(final int maxLength) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            public byte[] a(ByteBuf buf) {
                return PacketDataSerializer.a(buf, maxLength);
            }

            @Override
            public void a(ByteBuf byteBuf, byte[] bs) {
                if (bs.length > maxLength) {
                    throw new EncoderException("ByteArray with size " + bs.length + " is bigger than allowed " + maxLength);
                }
                PacketDataSerializer.a(byteBuf, bs);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (byte[])value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> b(final int maxLength) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            public String a(ByteBuf byteBuf) {
                return Utf8String.a(byteBuf, maxLength);
            }

            @Override
            public void a(ByteBuf byteBuf, String string) {
                Utf8String.a(byteBuf, string, maxLength);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (String)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTBase> a(final Supplier<NBTReadLimiter> sizeTracker) {
        return new StreamCodec<ByteBuf, NBTBase>(){

            @Override
            public NBTBase a(ByteBuf byteBuf) {
                NBTBase tag = PacketDataSerializer.a(byteBuf, (NBTReadLimiter)sizeTracker.get());
                if (tag == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return tag;
            }

            @Override
            public void a(ByteBuf byteBuf, NBTBase tag) {
                if (tag == NBTTagEnd.b) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                PacketDataSerializer.a(byteBuf, tag);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (NBTBase)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTTagCompound> b(Supplier<NBTReadLimiter> sizeTracker) {
        return ByteBufCodecs.a(sizeTracker).a(nbt -> {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)nbt;
                return compoundTag;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(nbt));
        }, nbt -> nbt);
    }

    public static <T> StreamCodec<ByteBuf, T> a(Codec<T> codec) {
        return ByteBufCodecs.a(codec, NBTReadLimiter::a);
    }

    public static <T> StreamCodec<ByteBuf, T> b(Codec<T> codec) {
        return ByteBufCodecs.a(codec, () -> NBTReadLimiter.a(0x200000L));
    }

    public static <T> StreamCodec<ByteBuf, T> a(Codec<T> codec, Supplier<NBTReadLimiter> sizeTracker) {
        return ByteBufCodecs.a(sizeTracker).a(nbt -> codec.parse((DynamicOps)DynamicOpsNBT.a, nbt).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(nbt))), value -> (NBTBase)codec.encodeStart((DynamicOps)DynamicOpsNBT.a, value).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(value))));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> c(Codec<T> codec) {
        return ByteBufCodecs.b(codec, NBTReadLimiter::a);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> d(Codec<T> codec) {
        return ByteBufCodecs.b(codec, () -> NBTReadLimiter.a(0x200000L));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> b(final Codec<T> codec, Supplier<NBTReadLimiter> sizeTracker) {
        final StreamCodec<ByteBuf, NBTBase> streamCodec = ByteBufCodecs.a(sizeTracker);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            public T a(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                NBTBase tag = (NBTBase)streamCodec.decode(registryFriendlyByteBuf);
                RegistryOps<NBTBase> registryOps = registryFriendlyByteBuf.G().a(DynamicOpsNBT.a);
                return codec.parse(registryOps, (Object)tag).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(tag)));
            }

            @Override
            public void a(RegistryFriendlyByteBuf registryFriendlyByteBuf, T object) {
                RegistryOps<NBTBase> registryOps = registryFriendlyByteBuf.G().a(DynamicOpsNBT.a);
                NBTBase tag = (NBTBase)codec.encodeStart(registryOps, object).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(object)));
                streamCodec.encode(registryFriendlyByteBuf, tag);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((RegistryFriendlyByteBuf)((Object)buf), value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> a(final StreamCodec<B, V> codec) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> a(B byteBuf) {
                if (byteBuf.readBoolean()) {
                    return Optional.of(codec.decode(byteBuf));
                }
                return Optional.empty();
            }

            @Override
            public void a(B byteBuf, Optional<V> optional) {
                if (optional.isPresent()) {
                    byteBuf.writeBoolean(true);
                    codec.encode(byteBuf, optional.get());
                } else {
                    byteBuf.writeBoolean(false);
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (Optional)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static int a(ByteBuf buf, int maxSize) {
        int i2 = VarInt.a(buf);
        if (i2 > maxSize) {
            throw new DecoderException(i2 + " elements exceeded max size of: " + maxSize);
        }
        return i2;
    }

    public static void a(ByteBuf buf, int size, int maxSize) {
        if (size > maxSize) {
            throw new EncoderException(size + " elements exceeded max size of: " + maxSize);
        }
        VarInt.a(buf, size);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> a(IntFunction<C> factory, StreamCodec<? super B, V> elementCodec) {
        return ByteBufCodecs.a(factory, elementCodec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> a(final IntFunction<C> factory, final StreamCodec<? super B, V> elementCodec, final int maxSize) {
        return new StreamCodec<B, C>(){

            @Override
            public C a(B byteBuf) {
                int i2 = ByteBufCodecs.a(byteBuf, maxSize);
                Collection collection = (Collection)factory.apply(Math.min(i2, 65536));
                for (int j2 = 0; j2 < i2; ++j2) {
                    collection.add(elementCodec.decode(byteBuf));
                }
                return collection;
            }

            @Override
            public void a(B byteBuf, C collection) {
                ByteBufCodecs.a(byteBuf, collection.size(), maxSize);
                for (Object object : collection) {
                    elementCodec.encode(byteBuf, object);
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (Collection)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.a<B, V, C> a(IntFunction<C> collectionFactory) {
        return codec -> ByteBufCodecs.a(collectionFactory, codec);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> a() {
        return codec -> ByteBufCodecs.a(ArrayList::new, codec);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> c(int maxLength) {
        return codec -> ByteBufCodecs.a(ArrayList::new, codec, maxLength);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> a(IntFunction<? extends M> factory, StreamCodec<? super B, K> keyCodec, StreamCodec<? super B, V> valueCodec) {
        return ByteBufCodecs.a(factory, keyCodec, valueCodec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> a(final IntFunction<? extends M> factory, final StreamCodec<? super B, K> keyCodec, final StreamCodec<? super B, V> valueCodec, final int maxSize) {
        return new StreamCodec<B, M>(){

            @Override
            public void a(B byteBuf, M map) {
                ByteBufCodecs.a(byteBuf, map.size(), maxSize);
                map.forEach((k2, v2) -> {
                    keyCodec.encode(byteBuf, k2);
                    valueCodec.encode(byteBuf, v2);
                });
            }

            @Override
            public M a(B byteBuf) {
                int i2 = ByteBufCodecs.a(byteBuf, maxSize);
                Map map = (Map)factory.apply(Math.min(i2, 65536));
                for (int j2 = 0; j2 < i2; ++j2) {
                    Object object = keyCodec.decode(byteBuf);
                    Object object2 = valueCodec.decode(byteBuf);
                    map.put(object, object2);
                }
                return map;
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (Map)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> a(final StreamCodec<? super B, L> left, final StreamCodec<? super B, R> right) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            @Override
            public Either<L, R> a(B byteBuf) {
                if (byteBuf.readBoolean()) {
                    return Either.left(left.decode(byteBuf));
                }
                return Either.right(right.decode(byteBuf));
            }

            @Override
            public void a(B byteBuf, Either<L, R> either) {
                either.ifLeft(left -> {
                    byteBuf.writeBoolean(true);
                    left.encode(byteBuf, left);
                }).ifRight(right -> {
                    byteBuf.writeBoolean(false);
                    right.encode(byteBuf, right);
                });
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, (Either)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> a(final IntFunction<T> indexToValue, final ToIntFunction<T> valueToIndex) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T a(ByteBuf byteBuf) {
                int i2 = VarInt.a(byteBuf);
                return indexToValue.apply(i2);
            }

            @Override
            public void a(ByteBuf byteBuf, T object) {
                int i2 = valueToIndex.applyAsInt(object);
                VarInt.a(byteBuf, i2);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> a(Registry<T> iterable) {
        return ByteBufCodecs.a(iterable::b, iterable::c);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> a(final ResourceKey<? extends IRegistry<T>> registry, final Function<IRegistry<T>, Registry<R>> registryTransformer) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private Registry<R> b(RegistryFriendlyByteBuf buf) {
                return (Registry)registryTransformer.apply(buf.G().d(registry));
            }

            @Override
            public R a(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                int i2 = VarInt.a(registryFriendlyByteBuf);
                return this.b(registryFriendlyByteBuf).b(i2);
            }

            @Override
            public void a(RegistryFriendlyByteBuf registryFriendlyByteBuf, R object) {
                int i2 = this.b(registryFriendlyByteBuf).c(object);
                VarInt.a(registryFriendlyByteBuf, i2);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((RegistryFriendlyByteBuf)((Object)buf), value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> a(ResourceKey<? extends IRegistry<T>> registry2) {
        return ByteBufCodecs.a(registry2, (IRegistry<T> registry) -> registry);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> b(ResourceKey<? extends IRegistry<T>> registry) {
        return ByteBufCodecs.a(registry, IRegistry::u);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> a(final ResourceKey<? extends IRegistry<T>> registry, final StreamCodec<? super RegistryFriendlyByteBuf, T> directCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int c = 0;

            private Registry<Holder<T>> b(RegistryFriendlyByteBuf buf) {
                return buf.G().d(registry).u();
            }

            @Override
            public Holder<T> a(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                int i2 = VarInt.a(registryFriendlyByteBuf);
                if (i2 == 0) {
                    return Holder.a(directCodec.decode(registryFriendlyByteBuf));
                }
                return this.b(registryFriendlyByteBuf).b(i2 - 1);
            }

            @Override
            public void a(RegistryFriendlyByteBuf registryFriendlyByteBuf, Holder<T> holder) {
                switch (holder.f()) {
                    case a: {
                        int i2 = this.b(registryFriendlyByteBuf).c(holder);
                        VarInt.a(registryFriendlyByteBuf, i2 + 1);
                        break;
                    }
                    case b: {
                        VarInt.a(registryFriendlyByteBuf, 0);
                        directCodec.encode(registryFriendlyByteBuf, holder.a());
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((RegistryFriendlyByteBuf)((Object)buf), (Holder)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> c(final ResourceKey<? extends IRegistry<T>> registryRef) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int b = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> c;
            {
                this.c = ByteBufCodecs.b(registryRef);
            }

            @Override
            public HolderSet<T> a(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                int i2 = VarInt.a(registryFriendlyByteBuf) - 1;
                if (i2 == -1) {
                    IRegistry registry = registryFriendlyByteBuf.G().d(registryRef);
                    return registry.b(TagKey.a(registryRef, (MinecraftKey)MinecraftKey.b.decode(registryFriendlyByteBuf))).orElseThrow();
                }
                ArrayList<Holder> list = new ArrayList<Holder>(Math.min(i2, 65536));
                for (int j2 = 0; j2 < i2; ++j2) {
                    list.add((Holder)this.c.decode(registryFriendlyByteBuf));
                }
                return HolderSet.a(list);
            }

            @Override
            public void a(RegistryFriendlyByteBuf registryFriendlyByteBuf, HolderSet<T> holderSet) {
                Optional optional = holderSet.d();
                if (optional.isPresent()) {
                    VarInt.a(registryFriendlyByteBuf, 0);
                    MinecraftKey.b.encode(registryFriendlyByteBuf, optional.get().b());
                } else {
                    VarInt.a(registryFriendlyByteBuf, holderSet.b() + 1);
                    for (Holder holder : holderSet) {
                        this.c.encode(registryFriendlyByteBuf, holder);
                    }
                }
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((RegistryFriendlyByteBuf)((Object)buf), (HolderSet)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((RegistryFriendlyByteBuf)((Object)buf));
            }
        };
    }
}

