/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger d = LogUtils.getLogger();
    private static final RegistrationInfo e = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> f = SystemUtils.b((T knownPacks) -> {
        Lifecycle lifecycle = knownPacks.map(KnownPack::a).map(vanilla -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)knownPacks, lifecycle);
    });
    public static final List<c<?>> a = List.of(new c<DimensionManager>(Registries.aK, DimensionManager.h), new c<BiomeBase>(Registries.aF, BiomeBase.a), new c<ChatMessageType>(Registries.aG, ChatMessageType.a), new c(Registries.aH, WorldGenCarverWrapper.a), new c(Registries.aI, WorldGenFeatureConfigured.a), new c<PlacedFeature>(Registries.aQ, PlacedFeature.a), new c<Structure>(Registries.aR, Structure.a), new c<StructureSet>(Registries.aT, StructureSet.a), new c<ProcessorList>(Registries.aS, DefinedStructureStructureProcessorType.c), new c<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.aU, WorldGenFeatureDefinedStructurePoolTemplate.a), new c<GeneratorSettingBase>(Registries.aO, GeneratorSettingBase.a), new c<NoiseGeneratorNormal.a>(Registries.aP, NoiseGeneratorNormal.a.a), new c<DensityFunction>(Registries.aJ, DensityFunction.b), new c<WorldPreset>(Registries.aY, WorldPreset.a), new c<FlatLevelGeneratorPreset>(Registries.aN, FlatLevelGeneratorPreset.a), new c<TrimPattern>(Registries.aX, TrimPattern.a), new c<TrimMaterial>(Registries.aW, TrimMaterial.a), new c<WolfVariant>(Registries.m, WolfVariant.a, true), new c<PaintingVariant>(Registries.X, PaintingVariant.a, true), new c<DamageType>(Registries.s, DamageType.a), new c<MultiNoiseBiomeSourceParameterList>(Registries.aZ, MultiNoiseBiomeSourceParameterList.a), new c<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new c<Enchantment>(Registries.aL, Enchantment.b), new c<EnchantmentProvider>(Registries.aM, EnchantmentProvider.a), new c<JukeboxSong>(Registries.L, JukeboxSong.a));
    public static final List<c<?>> b = List.of(new c<WorldDimension>(Registries.bb, WorldDimension.a));
    public static final List<c<?>> c = List.of(new c<BiomeBase>(Registries.aF, BiomeBase.b), new c<ChatMessageType>(Registries.aG, ChatMessageType.a), new c<TrimPattern>(Registries.aX, TrimPattern.a), new c<TrimMaterial>(Registries.aW, TrimMaterial.a), new c<WolfVariant>(Registries.m, WolfVariant.a, true), new c<PaintingVariant>(Registries.X, PaintingVariant.a, true), new c<DimensionManager>(Registries.aK, DimensionManager.h), new c<DamageType>(Registries.s, DamageType.a), new c<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new c<Enchantment>(Registries.aL, Enchantment.b), new c<JukeboxSong>(Registries.L, JukeboxSong.a));

    public static IRegistryCustom.Dimension a(IResourceManager resourceManager, IRegistryCustom registryManager, List<c<?>> entries) {
        return RegistryDataLoader.a((a<?> loader, RegistryOps.c infoGetter, Conversions conversions) -> loader.loadFromResources(resourceManager, infoGetter, conversions), registryManager, entries);
    }

    public static IRegistryCustom.Dimension a(Map<ResourceKey<? extends IRegistry<?>>, List<RegistrySynchronization.a>> data, ResourceProvider factory, IRegistryCustom registryManager, List<c<?>> entries) {
        return RegistryDataLoader.a((a<?> loader, RegistryOps.c infoGetter, Conversions conversions) -> loader.loadFromNetwork(data, factory, infoGetter, conversions), registryManager, entries);
    }

    private static IRegistryCustom.Dimension a(b loadable, IRegistryCustom baseRegistryManager, List<c<?>> entries) {
        HashMap map = new HashMap();
        List<a<?>> list = entries.stream().map(entry -> entry.a(Lifecycle.stable(), map)).collect(Collectors.toUnmodifiableList());
        RegistryOps.c registryInfoLookup = RegistryDataLoader.a(baseRegistryManager, list);
        Conversions conversions = new Conversions(registryInfoLookup);
        list.forEach(loader -> loadable.apply((a<?>)loader, registryInfoLookup, conversions));
        list.forEach(loader -> {
            IRegistryWritable registry = loader.b();
            PaperRegistryListenerManager.INSTANCE.runFreezeListeners(loader.b.d(), conversions);
            try {
                registry.m();
            }
            catch (Exception var4x) {
                map.put(registry.d(), var4x);
            }
            if (loader.a.c && registry.c() == 0) {
                map.put(registry.d(), new IllegalStateException("Registry must be non-empty"));
            }
        });
        if (!map.isEmpty()) {
            RegistryDataLoader.a(map);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new IRegistryCustom.c(list.stream().map(a::b).toList()).d();
    }

    private static RegistryOps.c a(IRegistryCustom baseRegistryManager, List<a<?>> additionalRegistries) {
        final HashMap map = new HashMap();
        baseRegistryManager.c().forEach(entry -> map.put(entry.a(), RegistryDataLoader.a(entry.b())));
        additionalRegistries.forEach(loader -> map.put(loader.b.d(), RegistryDataLoader.a(loader.b)));
        return new RegistryOps.c(){

            @Override
            public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return Optional.ofNullable((RegistryOps.b)map.get(registryRef));
            }
        };
    }

    private static <T> RegistryOps.b<T> a(IRegistryWritable<T> registry) {
        return new RegistryOps.b(registry.q(), registry.o(), registry.e());
    }

    private static <T> RegistryOps.b<T> a(IRegistry<T> registry) {
        return new RegistryOps.b<T>(registry.q(), registry.v(), registry.e());
    }

    private static void a(Map<ResourceKey<?>, Exception> exceptions) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> map = exceptions.entrySet().stream().collect(Collectors.groupingBy(entry -> ((ResourceKey)entry.getKey()).b(), Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).a(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            printWriter.printf("> Errors in registry %s:%n", entry.getKey());
            ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(elementEntry -> {
                printWriter.printf(">> Errors in element %s:%n", elementEntry.getKey());
                ((Exception)elementEntry.getValue()).printStackTrace(printWriter);
            });
        });
        printWriter.flush();
        d.error("Registry loading errors:\n{}", (Object)stringWriter);
    }

    private static <E> void loadElementFromResource(IRegistryWritable<E> registry, Decoder<E> decoder, RegistryOps<JsonElement> ops, ResourceKey<E> key, IResource resource, RegistrationInfo entryInfo, Conversions conversions) throws IOException {
        try (BufferedReader reader = resource.e();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            DataResult dataResult = decoder.parse(ops, (Object)jsonElement);
            Object object = dataResult.getOrThrow();
            PaperRegistryListenerManager.INSTANCE.registerWithListeners(registry, key, object, entryInfo, conversions);
        }
    }

    static <E> void loadContentsFromManager(IResourceManager resourceManager, RegistryOps.c infoGetter, IRegistryWritable<E> registry, Decoder<E> elementDecoder, Map<ResourceKey<?>, Exception> errors, Conversions conversions) {
        String string = Registries.c(registry.d());
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(string);
        RegistryOps<JsonElement> registryOps = RegistryOps.a(JsonOps.INSTANCE, infoGetter);
        for (Map.Entry<MinecraftKey, IResource> entry : fileToIdConverter.a(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            ResourceKey resourceKey = ResourceKey.a(registry.d(), fileToIdConverter.b(resourceLocation));
            IResource resource = entry.getValue();
            RegistrationInfo registrationInfo = f.apply(resource.c());
            try {
                RegistryDataLoader.loadElementFromResource(registry, elementDecoder, registryOps, resourceKey, resource, registrationInfo, conversions);
            }
            catch (Exception var15) {
                errors.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourceLocation, resource.b()), var15));
            }
        }
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends IRegistry<?>>, List<RegistrySynchronization.a>> data, ResourceProvider factory, RegistryOps.c infoGetter, IRegistryWritable<E> registry, Decoder<E> decoder, Map<ResourceKey<?>, Exception> loadingErrors, Conversions conversions) {
        List<RegistrySynchronization.a> list = data.get(registry.d());
        if (list != null) {
            RegistryOps<NBTBase> registryOps = RegistryOps.a(DynamicOpsNBT.a, infoGetter);
            RegistryOps<JsonElement> registryOps2 = RegistryOps.a(JsonOps.INSTANCE, infoGetter);
            String string = Registries.c(registry.d());
            FileToIdConverter fileToIdConverter = FileToIdConverter.a(string);
            for (RegistrySynchronization.a packedRegistryEntry : list) {
                ResourceKey resourceKey = ResourceKey.a(registry.d(), packedRegistryEntry.a());
                Optional<NBTBase> optional = packedRegistryEntry.b();
                if (optional.isPresent()) {
                    try {
                        DataResult dataResult = decoder.parse(registryOps, (Object)optional.get());
                        Object object = dataResult.getOrThrow();
                        registry.a(resourceKey, object, e);
                    }
                    catch (Exception var17) {
                        loadingErrors.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", optional.get()), var17));
                    }
                    continue;
                }
                MinecraftKey resourceLocation = fileToIdConverter.a(packedRegistryEntry.a());
                try {
                    IResource resource = factory.getResourceOrThrow(resourceLocation);
                    RegistryDataLoader.loadElementFromResource(registry, decoder, registryOps2, resourceKey, resource, e, conversions);
                }
                catch (Exception var18) {
                    loadingErrors.put(resourceKey, new IllegalStateException("Failed to parse local data", var18));
                }
            }
        }
    }

    @FunctionalInterface
    static interface b {
        public void apply(a<?> var1, RegistryOps.c var2, Conversions var3);
    }

    record a<T>(c<T> a, IRegistryWritable<T> b, Map<ResourceKey<?>, Exception> c) {
        public void loadFromResources(IResourceManager resourceManager, RegistryOps.c infoGetter, Conversions conversions) {
            RegistryDataLoader.loadContentsFromManager(resourceManager, infoGetter, this.b, this.a.b, this.c, conversions);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends IRegistry<?>>, List<RegistrySynchronization.a>> data, ResourceProvider factory, RegistryOps.c infoGetter, Conversions conversions) {
            RegistryDataLoader.loadContentsFromNetwork(data, factory, infoGetter, this.b, this.a.b, this.c, conversions);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this, o2);
        }
    }

    public record c<T>(ResourceKey<? extends IRegistry<T>> a, Codec<T> b, boolean c) {
        c(ResourceKey<? extends IRegistry<T>> resourceKey, Codec<T> codec) {
            this(resourceKey, codec, false);
        }

        a<T> a(Lifecycle lifecycle, Map<ResourceKey<?>, Exception> errors) {
            RegistryMaterials writableRegistry = new RegistryMaterials(this.a, lifecycle);
            PaperRegistryAccess.instance().registerRegistry(this.a, writableRegistry);
            return new a(this, writableRegistry, errors);
        }

        public void a(BiConsumer<ResourceKey<? extends IRegistry<T>>, Codec<T>> callback) {
            callback.accept(this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this, o2);
        }
    }
}

