/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public final class RegistryFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends IRegistry<E>> a;
    private final Codec<E> b;
    private final boolean c;

    public static <E> RegistryFileCodec<E> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec) {
        return RegistryFileCodec.a(registryRef, elementCodec, true);
    }

    public static <E> RegistryFileCodec<E> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec, boolean allowInlineDefinitions) {
        return new RegistryFileCodec<E>(registryRef, elementCodec, allowInlineDefinitions);
    }

    private RegistryFileCodec(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec, boolean allowInlineDefinitions) {
        this.a = registryRef;
        this.b = elementCodec;
        this.c = allowInlineDefinitions;
    }

    public <T> DataResult<T> a(Holder<E> holder, DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).a(this.a)).isPresent()) {
            if (!holder.a(optional.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(holder) + " is not valid in current registry set");
            }
            return holder.d().map(key -> MinecraftKey.a.encode((Object)key.a(), dynamicOps, object), value -> this.b.encode(value, dynamicOps, object));
        }
        return this.b.encode(holder.a(), dynamicOps, object);
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        if (dynamicOps instanceof RegistryOps) {
            RegistryOps registryOps = (RegistryOps)dynamicOps;
            Optional optional = registryOps.b(this.a);
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Registry does not exist: " + String.valueOf(this.a));
            }
            HolderGetter holderGetter = optional.get();
            DataResult dataResult = MinecraftKey.a.decode(dynamicOps, object);
            if (dataResult.result().isEmpty()) {
                if (!this.c) {
                    return DataResult.error(() -> "Inline definitions not allowed here");
                }
                return this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Holder::a));
            }
            Pair pair2 = (Pair)dataResult.result().get();
            ResourceKey resourceKey = ResourceKey.a(this.a, (MinecraftKey)pair2.getFirst());
            return holderGetter.a(resourceKey).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf(resourceKey))).map(reference -> Pair.of((Object)reference, (Object)pair2.getSecond())).setLifecycle(Lifecycle.stable());
        }
        return this.b.decode(dynamicOps, object).map(pair -> pair.mapFirst(Holder::a));
    }

    @Override
    public String toString() {
        return "RegistryFileCodec[" + String.valueOf(this.a) + " " + String.valueOf(this.b) + "]";
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.a((Holder)object, dynamicOps, object2);
    }
}

