/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DynamicOpsWrapper<T> {
    public final c b;

    public static <T> RegistryOps<T> a(DynamicOps<T> delegate, HolderLookup.a wrapperLookup) {
        return RegistryOps.a(delegate, new a(wrapperLookup));
    }

    public static <T> RegistryOps<T> a(DynamicOps<T> delegate, c registryInfoGetter) {
        return new RegistryOps<T>(delegate, registryInfoGetter);
    }

    public static <T> Dynamic<T> a(Dynamic<T> dynamic, HolderLookup.a registryLookup) {
        return new Dynamic(registryLookup.a(dynamic.getOps()), dynamic.getValue());
    }

    private RegistryOps(DynamicOps<T> delegate, c registryInfoGetter) {
        super(delegate);
        this.b = registryInfoGetter;
    }

    public <U> RegistryOps<U> a(DynamicOps<U> delegate) {
        if (delegate == this.a) {
            return this;
        }
        return new RegistryOps<U>(delegate, this.b);
    }

    public <E> Optional<HolderOwner<E>> a(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
        return this.b.a(registryRef).map(b::a);
    }

    public <E> Optional<HolderGetter<E>> b(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
        return this.b.a(registryRef).map(b::b);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegistryOps registryOps = (RegistryOps)object;
        return this.a.equals(registryOps.a) && this.b.equals(registryOps.b);
    }

    @Override
    public int hashCode() {
        return this.a.hashCode() * 31 + this.b.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> c(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
        return ExtraCodecs.a((DynamicOps<?> ops) -> {
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                return registryOps.b.a(registryRef).map(info -> DataResult.success(info.b(), (Lifecycle)info.c())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(registryRef)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(object -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.c<E>> d(ResourceKey<E> key) {
        ResourceKey resourceKey = ResourceKey.a(key.b());
        return ExtraCodecs.a((DynamicOps<?> ops) -> {
            if (ops instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)ops;
                return registryOps.b.a(resourceKey).flatMap(info -> info.b().a(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(key)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(object -> null);
    }

    public static final class a
    implements c {
        private final HolderLookup.a a;
        private final Map<ResourceKey<? extends IRegistry<?>>, Optional<? extends b<?>>> b = new ConcurrentHashMap();

        public a(HolderLookup.a registriesLookup) {
            this.a = registriesLookup;
        }

        @Override
        public <E> Optional<b<E>> a(ResourceKey<? extends IRegistry<? extends E>> registryRef) {
            return this.b.computeIfAbsent(registryRef, this::b);
        }

        private Optional<b<Object>> b(ResourceKey<? extends IRegistry<?>> registryRef) {
            return this.a.a(registryRef).map(b::a);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof a)) return false;
            a holderLookupAdapter = (a)object;
            if (!this.a.equals(holderLookupAdapter.a)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.a.hashCode();
        }
    }

    public static interface c {
        public <T> Optional<b<T>> a(ResourceKey<? extends IRegistry<? extends T>> var1);
    }

    public record b<T>(HolderOwner<T> a, HolderGetter<T> b, Lifecycle c) {
        public static <T> b<T> a(HolderLookup.b<T> wrapper) {
            return new b<T>(wrapper, wrapper, wrapper.g());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "owner;getter;elementsLifecycle", "a", "b", "c"}, this, object);
        }
    }
}

