/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import org.slf4j.Logger;

public class DataPackResources {
    private static final Logger a = LogUtils.getLogger();
    private static final CompletableFuture<Unit> b = CompletableFuture.completedFuture(Unit.a);
    private final ReloadableServerRegistries.b c;
    public final a d;
    public CommandDispatcher e;
    private final CraftingManager f;
    private final TagRegistry g;
    private final AdvancementDataWorld h;
    private final CustomFunctionManager i;

    private DataPackResources(IRegistryCustom.Dimension dynamicRegistryManager, FeatureFlagSet enabledFeatures, CommandDispatcher.ServerType environment, int functionPermissionLevel) {
        this.c = new ReloadableServerRegistries.b(dynamicRegistryManager);
        this.d = new a(dynamicRegistryManager);
        this.d.a(net.minecraft.server.DataPackResources$b.a);
        this.f = new CraftingManager(this.d);
        this.g = new TagRegistry(dynamicRegistryManager);
        this.e = new CommandDispatcher(environment, CommandBuildContext.a(this.d, enabledFeatures));
        PaperCommands.INSTANCE.setDispatcher(this.e, CommandBuildContext.a(this.d, enabledFeatures));
        this.h = new AdvancementDataWorld(this.d);
        this.i = new CustomFunctionManager(functionPermissionLevel, this.e.a());
    }

    public CustomFunctionManager a() {
        return this.i;
    }

    public ReloadableServerRegistries.b b() {
        return this.c;
    }

    public CraftingManager c() {
        return this.f;
    }

    public CommandDispatcher d() {
        return this.e;
    }

    public AdvancementDataWorld e() {
        return this.h;
    }

    public List<IReloadListener> f() {
        return List.of(this.g, this.f, this.i, this.h);
    }

    public static CompletableFuture<DataPackResources> a(IResourceManager manager, LayeredRegistryAccess<RegistryLayer> dynamicRegistries, FeatureFlagSet enabledFeatures, CommandDispatcher.ServerType environment, int functionPermissionLevel, Executor prepareExecutor, Executor applyExecutor) {
        return ReloadableServerRegistries.a(dynamicRegistries, manager, prepareExecutor).thenCompose(reloadedDynamicRegistries -> {
            DataPackResources reloadableServerResources = new DataPackResources(reloadedDynamicRegistries.a(), enabledFeatures, environment, functionPermissionLevel);
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, BootstrapContext.class, MinecraftServer.getServer() == null ? ReloadableRegistrarEvent.Cause.INITIAL : ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)Reloadable.a(manager, reloadableServerResources.f(), prepareExecutor, applyExecutor, b, a.isDebugEnabled()).a().whenComplete((void_, throwable) -> reloadableServerResources.d.a(net.minecraft.server.DataPackResources$b.b))).thenApply(void_ -> reloadableServerResources);
        });
    }

    public void g() {
        this.g.a().forEach(tags -> DataPackResources.a(this.c.a(), tags));
        TileEntityFurnace.f();
        Blocks.a();
    }

    private static <T> void a(IRegistryCustom dynamicRegistryManager, TagRegistry.a<T> tags) {
        ResourceKey resourceKey = tags.a();
        Map map = tags.b().entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.a(resourceKey, (MinecraftKey)entry.getKey()), entry -> List.copyOf((Collection)entry.getValue())));
        dynamicRegistryManager.d(resourceKey).a(map);
    }

    static class a
    implements HolderLookup.a {
        private final IRegistryCustom a;
        b b = net.minecraft.server.DataPackResources$b.b;

        a(IRegistryCustom dynamicRegistryManager) {
            this.a = dynamicRegistryManager;
        }

        public void a(b entryListCreationPolicy) {
            this.b = entryListCreationPolicy;
        }

        @Override
        public Stream<ResourceKey<? extends IRegistry<?>>> a() {
            return this.a.a();
        }

        @Override
        public <T> Optional<HolderLookup.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
            return this.a.c(registryRef).map(registry -> this.a(registry.q(), registry.v()));
        }

        private <T> HolderLookup.b<T> a(final HolderLookup.b<T> readOnlyWrapper, final HolderLookup.b<T> tagCreatingWrapper) {
            return new HolderLookup.b.a<T>(){

                @Override
                public HolderLookup.b<T> a() {
                    return switch (b.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> tagCreatingWrapper;
                        case 1 -> readOnlyWrapper;
                    };
                }
            };
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        private static final /* synthetic */ b[] c;

        public static b[] values() {
            return (b[])c.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b};
        }

        static {
            c = net.minecraft.server.DataPackResources$b.a();
        }
    }
}

