/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.time.Duration;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.slf4j.Logger;

public class CommandLocate {
    private static final Logger a = LogUtils.getLogger();
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("commands.locate.structure.not_found", id));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("commands.locate.structure.invalid", id));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("commands.locate.biome.not_found", id));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("commands.locate.poi.not_found", id));
    private static final int f = 100;
    private static final int g = 6400;
    private static final int h = 32;
    private static final int i = 64;
    private static final int j = 256;

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("locate").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("structure").then(net.minecraft.commands.CommandDispatcher.a("structure", ResourceOrTagKeyArgument.a(Registries.aR)).executes(context -> CommandLocate.a((CommandListenerWrapper)context.getSource(), ResourceOrTagKeyArgument.a((CommandContext<CommandListenerWrapper>)context, "structure", Registries.aR, c)))))).then(net.minecraft.commands.CommandDispatcher.a("biome").then(net.minecraft.commands.CommandDispatcher.a("biome", ResourceOrTagArgument.a(registryAccess, Registries.aF)).executes(context -> CommandLocate.a((CommandListenerWrapper)context.getSource(), ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context, "biome", Registries.aF)))))).then(net.minecraft.commands.CommandDispatcher.a("poi").then(net.minecraft.commands.CommandDispatcher.a("poi", ResourceOrTagArgument.a(registryAccess, Registries.aa)).executes(context -> CommandLocate.b((CommandListenerWrapper)context.getSource(), ResourceOrTagArgument.a((CommandContext<CommandListenerWrapper>)context, "poi", Registries.aa)))))));
    }

    private static Optional<? extends HolderSet.b<Structure>> a(ResourceOrTagKeyArgument.c<Structure> predicate, IRegistry<Structure> structureRegistry) {
        return predicate.a().map(key -> structureRegistry.b((ResourceKey<Structure>)key).map(entry -> HolderSet.a(entry)), structureRegistry::b);
    }

    private static int a(CommandListenerWrapper source, ResourceOrTagKeyArgument.c<Structure> predicate) throws CommandSyntaxException {
        IRegistry<Structure> registry = source.e().H_().d(Registries.aR);
        HolderSet holderSet = CommandLocate.a(predicate, registry).orElseThrow(() -> c.create((Object)predicate.b()));
        BlockPosition blockPos = BlockPosition.a(source.d());
        WorldServer serverLevel = source.e();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        Pair<BlockPosition, Holder<Structure>> pair = serverLevel.l().g().a(serverLevel, holderSet, blockPos, 100, false);
        stopwatch.stop();
        if (pair == null) {
            throw b.create((Object)predicate.b());
        }
        return CommandLocate.a(source, predicate, blockPos, pair, "commands.locate.structure.success", false, stopwatch.elapsed());
    }

    private static int a(CommandListenerWrapper source, ResourceOrTagArgument.c<BiomeBase> predicate) throws CommandSyntaxException {
        BlockPosition blockPos = BlockPosition.a(source.d());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        Pair<BlockPosition, Holder<BiomeBase>> pair = source.e().a(predicate, blockPos, 6400, 32, 64);
        stopwatch.stop();
        if (pair == null) {
            throw d.create((Object)predicate.b());
        }
        return CommandLocate.a(source, predicate, blockPos, pair, "commands.locate.biome.success", true, stopwatch.elapsed());
    }

    private static int b(CommandListenerWrapper source, ResourceOrTagArgument.c<VillagePlaceType> predicate) throws CommandSyntaxException {
        BlockPosition blockPos = BlockPosition.a(source.d());
        WorldServer serverLevel = source.e();
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> optional = serverLevel.y().e(predicate, blockPos, 256, VillagePlace.Occupancy.c);
        stopwatch.stop();
        if (optional.isEmpty()) {
            throw e.create((Object)predicate.b());
        }
        return CommandLocate.a(source, predicate, blockPos, optional.get().swap(), "commands.locate.poi.success", false, stopwatch.elapsed());
    }

    public static int a(CommandListenerWrapper source, ResourceOrTagArgument.c<?> predicate, BlockPosition currentPos, Pair<BlockPosition, ? extends Holder<?>> result, String successMessage, boolean includeY, Duration timeTaken) {
        String string = predicate.a().map(entry -> predicate.b(), tag -> predicate.b() + " (" + ((Holder)result.getSecond()).g() + ")");
        return CommandLocate.a(source, currentPos, result, successMessage, includeY, string, timeTaken);
    }

    public static int a(CommandListenerWrapper source, ResourceOrTagKeyArgument.c<?> structure, BlockPosition currentPos, Pair<BlockPosition, ? extends Holder<?>> result, String successMessage, boolean includeY, Duration timeTaken) {
        String string = structure.a().map(key -> key.a().toString(), key -> "#" + String.valueOf(key.b()) + " (" + ((Holder)result.getSecond()).g() + ")");
        return CommandLocate.a(source, currentPos, result, successMessage, includeY, string, timeTaken);
    }

    private static int a(CommandListenerWrapper source, BlockPosition currentPos, Pair<BlockPosition, ? extends Holder<?>> result, String successMessage, boolean includeY, String entryString, Duration timeTaken) {
        BlockPosition blockPos = (BlockPosition)result.getFirst();
        int i2 = includeY ? MathHelper.d(MathHelper.c((float)currentPos.j(blockPos))) : MathHelper.d(CommandLocate.a(currentPos.u(), currentPos.w(), blockPos.u(), blockPos.w()));
        String string = includeY ? String.valueOf(blockPos.v()) : "~";
        IChatMutableComponent component = ChatComponentUtils.a(IChatBaseComponent.a("chat.coordinates", blockPos.u(), string, blockPos.w())).a(style -> style.a(EnumChatFormat.k).a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tp @s " + blockPos.u() + " " + string + " " + blockPos.w())).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, IChatBaseComponent.c("chat.coordinates.tooltip"))));
        source.a(() -> IChatBaseComponent.a(successMessage, new Object[]{entryString, component, i2}), false);
        a.info("Locating element " + entryString + " took " + timeTaken.toMillis() + " ms");
        return i2;
    }

    private static float a(int x1, int y1, int x2, int y2) {
        int i2 = x2 - x1;
        int j2 = y2 - y1;
        return MathHelper.c((float)(i2 * i2 + j2 * j2));
    }
}

