/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class CommandLoot {
    public static final SuggestionProvider<CommandListenerWrapper> a = (commandcontext, suggestionsbuilder) -> {
        ReloadableServerRegistries.b reloadableserverregistries_b = ((CommandListenerWrapper)commandcontext.getSource()).l().be();
        return ICompletionProvider.a(reloadableserverregistries_b.a(Registries.bc), suggestionsbuilder);
    };
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.drop.no_loot_table", object));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)CommandLoot.a((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("loot").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2)), (ArgumentBuilder<CommandListenerWrapper, ?> argumentbuilder, b commandloot_b) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentbuilder.then(net.minecraft.commands.CommandDispatcher.a("fish").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ResourceOrIdArgument.a(commandRegistryAccess)).suggests(a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.l, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a(commandRegistryAccess)).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.a(commandcontext, "tool").a(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.a), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.b), commandloot_b))))))).then(net.minecraft.commands.CommandDispatcher.a("loot").then(net.minecraft.commands.CommandDispatcher.a("loot_table", ResourceOrIdArgument.a(commandRegistryAccess)).suggests(a).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ResourceOrIdArgument.a((CommandContext<CommandListenerWrapper>)commandcontext, "loot_table"), commandloot_b))))).then(net.minecraft.commands.CommandDispatcher.a("kill").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "target"), commandloot_b))))).then(net.minecraft.commands.CommandDispatcher.a("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ItemStack.l, commandloot_b))).then(net.minecraft.commands.CommandDispatcher.a("tool", ArgumentItemStack.a(commandRegistryAccess)).executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), ArgumentItemStack.a(commandcontext, "tool").a(1, false), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("mainhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.a), commandloot_b)))).then(net.minecraft.commands.CommandDispatcher.a("offhand").executes(commandcontext -> CommandLoot.a((CommandContext<CommandListenerWrapper>)commandcontext, ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "pos"), CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), EnumItemSlot.b), commandloot_b)))))));
    }

    private static <T extends ArgumentBuilder<CommandListenerWrapper, T>> T a(T rootArgument, c sourceConstructor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)rootArgument.then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").then(net.minecraft.commands.CommandDispatcher.a("entity").then(net.minecraft.commands.CommandDispatcher.a("entities", ArgumentEntity.b()).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "entities"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(net.minecraft.commands.CommandDispatcher.a("block").then(net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a)))))))).then(net.minecraft.commands.CommandDispatcher.a("insert").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentPosition.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), (List<ItemStack>)list, commandloot_a))))).then(net.minecraft.commands.CommandDispatcher.a("give").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("players", ArgumentEntity.d()), (commandcontext, list, commandloot_a) -> CommandLoot.a(ArgumentEntity.f((CommandContext<CommandListenerWrapper>)commandcontext, "players"), (List<ItemStack>)list, commandloot_a))))).then(net.minecraft.commands.CommandDispatcher.a("spawn").then(sourceConstructor.construct((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("targetPos", ArgumentVec3.a()), (commandcontext, list, commandloot_a) -> CommandLoot.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "targetPos"), (List<ItemStack>)list, commandloot_a))));
    }

    private static IInventory a(CommandListenerWrapper source, BlockPosition pos) throws CommandSyntaxException {
        TileEntity tileentity = source.e().c_(pos);
        if (!(tileentity instanceof IInventory)) {
            throw ItemCommands.a.create((Object)pos.u(), (Object)pos.v(), (Object)pos.w());
        }
        return (IInventory)((Object)tileentity);
    }

    private static int a(CommandListenerWrapper source, BlockPosition targetPos, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.a(source, targetPos);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemstack : stacks) {
            if (!CommandLoot.a(iinventory, itemstack.s())) continue;
            iinventory.e();
            list1.add(itemstack);
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static boolean a(IInventory inventory, ItemStack stack) {
        boolean flag = false;
        for (int i2 = 0; i2 < inventory.b() && !stack.e(); ++i2) {
            ItemStack itemstack1 = inventory.a(i2);
            if (!inventory.b(i2, stack)) continue;
            if (itemstack1.e()) {
                inventory.a(i2, stack);
                flag = true;
                break;
            }
            if (!CommandLoot.a(itemstack1, stack)) continue;
            int j2 = stack.j() - itemstack1.H();
            int k2 = Math.min(stack.H(), j2);
            stack.h(k2);
            itemstack1.g(k2);
            flag = true;
        }
        return flag;
    }

    private static int a(CommandListenerWrapper source, BlockPosition targetPos, int slot, int stackCount, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        IInventory iinventory = CommandLoot.a(source, targetPos);
        int k2 = iinventory.b();
        if (slot >= 0 && slot < k2) {
            ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
            for (int l2 = 0; l2 < stackCount; ++l2) {
                ItemStack itemstack;
                int i1 = slot + l2;
                ItemStack itemStack = itemstack = l2 < stacks.size() ? stacks.get(l2) : ItemStack.l;
                if (!iinventory.b(i1, itemstack)) continue;
                iinventory.a(i1, itemstack);
                list1.add(itemstack);
            }
            messageSender.accept(list1);
            return list1.size();
        }
        throw ItemCommands.c.create((Object)slot);
    }

    private static boolean a(ItemStack first, ItemStack second) {
        return first.H() <= first.j() && ItemStack.c(first, second);
    }

    private static int a(Collection<EntityPlayer> players, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemstack : stacks) {
            for (EntityPlayer entityplayer : players) {
                if (!entityplayer.fY().f(itemstack.s())) continue;
                list1.add(itemstack);
            }
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static void a(Entity entity, List<ItemStack> stacks, int slot, int stackCount, List<ItemStack> addedStacks) {
        for (int k2 = 0; k2 < stackCount; ++k2) {
            ItemStack itemstack = k2 < stacks.size() ? stacks.get(k2) : ItemStack.l;
            SlotAccess slotaccess = entity.a_(slot + k2);
            if (slotaccess == SlotAccess.a || !slotaccess.a(itemstack.s())) continue;
            addedStacks.add(itemstack);
        }
    }

    private static int a(Collection<? extends Entity> targets, int slot, int stackCount, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (Entity entity : targets) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                CommandLoot.a(entity, stacks, slot, stackCount, list1);
                entityplayer.cd.d();
                continue;
            }
            CommandLoot.a(entity, stacks, slot, stackCount, list1);
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static int a(CommandListenerWrapper source, Vec3D pos, List<ItemStack> stacks, a messageSender) throws CommandSyntaxException {
        WorldServer worldserver = source.e();
        stacks.removeIf(ItemStack::e);
        stacks.forEach(itemstack -> {
            EntityItem entityitem = new EntityItem(worldserver, pos.c, pos.d, pos.e, itemstack.s());
            entityitem.v();
            worldserver.b(entityitem);
        });
        messageSender.accept(stacks);
        return stacks.size();
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> stacks) {
        if (stacks.size() == 1) {
            ItemStack itemstack = stacks.get(0);
            source.a(() -> IChatBaseComponent.a("commands.drop.success.single", itemstack.H(), itemstack.F()), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.drop.success.multiple", stacks.size()), false);
        }
    }

    private static void a(CommandListenerWrapper source, List<ItemStack> stacks, ResourceKey<LootTable> lootTable) {
        if (stacks.size() == 1) {
            ItemStack itemstack = stacks.get(0);
            source.a(() -> IChatBaseComponent.a("commands.drop.success.single_with_table", itemstack.H(), itemstack.F(), IChatBaseComponent.a(lootTable.a())), false);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.drop.success.multiple_with_table", stacks.size(), IChatBaseComponent.a(lootTable.a())), false);
        }
    }

    private static ItemStack a(CommandListenerWrapper source, EnumItemSlot slot) throws CommandSyntaxException {
        Entity entity = source.g();
        if (entity instanceof EntityLiving) {
            return ((EntityLiving)entity).a(slot);
        }
        throw b.create((Object)entity.S_());
    }

    private static int a(CommandContext<CommandListenerWrapper> context, BlockPosition pos, ItemStack stack, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        WorldServer worldserver = commandlistenerwrapper.e();
        IBlockData iblockdata = worldserver.a_(pos);
        TileEntity tileentity = worldserver.c_(pos);
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.g, iblockdata).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameters.i, stack);
        List<ItemStack> list = iblockdata.a(lootparams_a);
        return constructor.accept(context, list, list1 -> CommandLoot.a(commandlistenerwrapper, (List<ItemStack>)list1, iblockdata.b().v()));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Entity entity, b constructor) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw c.create((Object)entity.S_());
        }
        ResourceKey<LootTable> resourcekey = ((EntityLiving)entity).eA();
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootParams.a lootparams_a = new LootParams.a(commandlistenerwrapper.e());
        Entity entity1 = commandlistenerwrapper.f();
        if (entity1 instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity1;
            lootparams_a.a(LootContextParameters.b, entityhuman);
        }
        lootparams_a.a(LootContextParameters.c, entity.dP().p());
        lootparams_a.b(LootContextParameters.e, entity1);
        lootparams_a.b(LootContextParameters.d, entity1);
        lootparams_a.a(LootContextParameters.a, entity);
        lootparams_a.a(LootContextParameters.f, commandlistenerwrapper.d());
        LootParams lootparams = lootparams_a.a(LootContextParameterSets.g);
        LootTable loottable = commandlistenerwrapper.l().be().b(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.a(lootparams);
        return constructor.accept(context, (List<ItemStack>)list, list1 -> CommandLoot.a(commandlistenerwrapper, (List<ItemStack>)list1, resourcekey));
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Holder<LootTable> lootTable, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootParams lootparams = new LootParams.a(commandlistenerwrapper.e()).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameters.f, commandlistenerwrapper.d()).a(LootContextParameterSets.c);
        return CommandLoot.a(context, lootTable, lootparams, constructor);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Holder<LootTable> lootTable, BlockPosition pos, ItemStack stack, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        LootParams lootparams = new LootParams.a(commandlistenerwrapper.e()).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameters.i, stack).b(LootContextParameters.a, commandlistenerwrapper.f()).a(LootContextParameterSets.f);
        return CommandLoot.a(context, lootTable, lootparams, constructor);
    }

    private static int a(CommandContext<CommandListenerWrapper> context, Holder<LootTable> lootTable, LootParams lootContextParameters, b constructor) throws CommandSyntaxException {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)context.getSource();
        ObjectArrayList<ItemStack> list = lootTable.a().a(lootContextParameters);
        return constructor.accept(context, (List<ItemStack>)list, list1 -> CommandLoot.a(commandlistenerwrapper, list1));
    }

    @FunctionalInterface
    private static interface c {
        public ArgumentBuilder<CommandListenerWrapper, ?> construct(ArgumentBuilder<CommandListenerWrapper, ?> var1, b var2);
    }

    @FunctionalInterface
    private static interface b {
        public int accept(CommandContext<CommandListenerWrapper> var1, List<ItemStack> var2, a var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface a {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

