/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalcommandnode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("teleport").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), VectorPosition.d(), null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new b(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new b(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new c(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("tp").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).redirect(literalcommandnode)));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, net.minecraft.world.entity.Entity destination) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity : targets) {
            CommandTeleport.a(source, entity, (WorldServer)destination.dO(), destination.dt(), destination.dv(), destination.dz(), EnumSet.noneOf(RelativeMovement.class), destination.dE(), destination.dG(), null);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).S_(), destination.S_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.multiple", targets.size(), destination.S_()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, WorldServer world, IVectorPosition location, @Nullable IVectorPosition rotation, @Nullable a facingLocation) throws CommandSyntaxException {
        Vec3D vec3d = location.a(source);
        Vec2F vec2f = rotation == null ? null : rotation.b(source);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (location.a()) {
            set.add(RelativeMovement.a);
        }
        if (location.b()) {
            set.add(RelativeMovement.b);
        }
        if (location.c()) {
            set.add(RelativeMovement.c);
        }
        if (rotation == null) {
            set.add(RelativeMovement.e);
            set.add(RelativeMovement.d);
        } else {
            if (rotation.a()) {
                set.add(RelativeMovement.e);
            }
            if (rotation.b()) {
                set.add(RelativeMovement.d);
            }
        }
        for (net.minecraft.world.entity.Entity entity : targets) {
            if (rotation == null) {
                CommandTeleport.a(source, entity, world, vec3d.c, vec3d.d, vec3d.e, set, entity.dE(), entity.dG(), facingLocation);
                continue;
            }
            CommandTeleport.a(source, entity, world, vec3d.c, vec3d.d, vec3d.e, set, vec2f.j, vec2f.i, facingLocation);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).S_(), CommandTeleport.a(vec3d.c), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.multiple", targets.size(), CommandTeleport.a(vec3d.c), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e)), true);
        }
        return targets.size();
    }

    private static String a(double d2) {
        return String.format(Locale.ROOT, "%f", d2);
    }

    private static void a(CommandListenerWrapper source, net.minecraft.world.entity.Entity target, WorldServer world, double x2, double y2, double z2, Set<RelativeMovement> movementFlags, float yaw, float pitch, @Nullable a facingLocation) throws CommandSyntaxException {
        boolean result;
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        if (!World.l(blockposition)) {
            throw a.create();
        }
        float f2 = MathHelper.g(yaw);
        float f3 = MathHelper.g(pitch);
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            result = player.teleportTo(world, x2, y2, z2, movementFlags, f2, f3, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((org.bukkit.World)world.getWorld(), x2, y2, z2, f2, f3);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)target.getBukkitEntity(), target.getBukkitEntity().getLocation(), to);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getTo() == null) {
                return;
            }
            to = event.getTo();
            x2 = to.getX();
            y2 = to.getY();
            z2 = to.getZ();
            f2 = to.getYaw();
            f3 = to.getPitch();
            world = ((CraftWorld)to.getWorld()).getHandle();
            result = target.a(world, x2, y2, z2, movementFlags, f2, f3);
        }
        if (result) {
            EntityLiving entityliving;
            if (facingLocation != null) {
                facingLocation.perform(source, target);
            }
            if (!(target instanceof EntityLiving) || !(entityliving = (EntityLiving)target).fA()) {
                target.i(target.dr().d(1.0, 0.0, 1.0));
                target.d(true);
            }
            if (target instanceof EntityCreature) {
                EntityCreature entitycreature = (EntityCreature)target;
                entitycreature.N().n();
            }
        }
    }

    @FunctionalInterface
    private static interface a {
        public void perform(CommandListenerWrapper var1, net.minecraft.world.entity.Entity var2);
    }

    private record c(Vec3D a) implements a
    {
        @Override
        public void perform(CommandListenerWrapper source, net.minecraft.world.entity.Entity entity) {
            entity.a(source.m(), this.a);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "position", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "position", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "position", "a"}, this, o2);
        }
    }

    private record b(net.minecraft.world.entity.Entity a, ArgumentAnchor.Anchor b) implements a
    {
        @Override
        public void perform(CommandListenerWrapper source, net.minecraft.world.entity.Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                entityplayer.a(source.m(), this.a, this.b);
            } else {
                entity.a(source.m(), this.b.a(this.a));
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "entity;anchor", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "entity;anchor", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "entity;anchor", "a", "b"}, this, o2);
        }
    }
}

