/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.destroystokyo.paper.gui.GuiStatsComponent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogQueues;
import com.mojang.logging.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.PlayerListBox;
import org.slf4j.Logger;

public class ServerGUI
extends JComponent {
    private static final Font a = new Font("Monospaced", 0, 12);
    private static final Logger b = LogUtils.getLogger();
    private static final String c = "Minecraft server";
    private static final String d = "Minecraft server - shutting down!";
    private final DedicatedServer e;
    private Thread f;
    private final Collection<Runnable> g = Lists.newArrayList();
    final AtomicBoolean h = new AtomicBoolean();
    private static final Pattern ANSI = Pattern.compile("\\e\\[[\\d;]*[^\\d;]");

    public static ServerGUI a(final DedicatedServer server) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame jframe = new JFrame(c);
        final ServerGUI servergui = new ServerGUI(server);
        jframe.setDefaultCloseOperation(2);
        jframe.add(servergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.setName(c);
        try {
            jframe.setIconImage(ImageIO.read(Objects.requireNonNull(ServerGUI.class.getClassLoader().getResourceAsStream("logo.png"))));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowevent) {
                if (!servergui.h.getAndSet(true)) {
                    jframe.setTitle(ServerGUI.d);
                    server.a(true);
                    servergui.f();
                }
            }
        });
        Objects.requireNonNull(jframe);
        servergui.a(jframe::dispose);
        servergui.a();
        return servergui;
    }

    private ServerGUI(DedicatedServer server) {
        this.e = server;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.buildOnboardingPanel(), "North");
            this.add((Component)this.e(), "Center");
            this.add((Component)this.c(), "West");
        }
        catch (Exception exception) {
            b.error("Couldn't build server GUI", (Throwable)exception);
        }
    }

    public void a(Runnable task) {
        this.g.add(task);
    }

    private JComponent c() {
        JPanel jpanel = new JPanel(new BorderLayout());
        GuiStatsComponent guistatscomponent = new GuiStatsComponent(this.e);
        Collection<Runnable> collection = this.g;
        Objects.requireNonNull(guistatscomponent);
        collection.add(guistatscomponent::close);
        jpanel.add((Component)guistatscomponent, "North");
        jpanel.add((Component)this.d(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent buildOnboardingPanel() {
        final String onboardingLink = "https://docs.papermc.io/paper/next-steps";
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("If you need help setting up your server you can visit:");
        jLabel.setFont(a);
        JLabel link = new JLabel("<html><u> " + onboardingLink + "</u></html>");
        link.setFont(a);
        link.setCursor(new Cursor(12));
        link.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e2) {
                try {
                    Desktop.getDesktop().browse(URI.create(onboardingLink));
                }
                catch (IOException exception) {
                    b.error("Unable to find a default browser. Please manually visit the website: " + onboardingLink, (Throwable)exception);
                }
                catch (UnsupportedOperationException exception) {
                    b.error("This platform does not support the BROWSE action. Please manually visit the website: " + onboardingLink, (Throwable)exception);
                }
                catch (SecurityException exception) {
                    b.error("This action has been denied by the security manager. Please manually visit the website: " + onboardingLink, (Throwable)exception);
                }
            }
        });
        jPanel.add(jLabel);
        jPanel.add(link);
        return jPanel;
    }

    private JComponent d() {
        PlayerListBox jlist = new PlayerListBox(this.e);
        JScrollPane jscrollpane = new JScrollPane(jlist, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent e() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JTextArea jtextarea = new JTextArea();
        JScrollPane jscrollpane = new JScrollPane(jtextarea, 22, 30);
        jtextarea.setEditable(false);
        jtextarea.setFont(a);
        JTextField jtextfield = new JTextField();
        jtextfield.addActionListener(actionevent -> {
            String s2 = jtextfield.getText().trim();
            if (!s2.isEmpty()) {
                this.e.a(s2, this.e.aI());
            }
            jtextfield.setText("");
        });
        jtextarea.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusGained(FocusEvent focusevent) {
            }
        });
        jpanel.add((Component)jscrollpane, "Center");
        jpanel.add((Component)jtextfield, "South");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.f = new Thread(() -> {
            String s2;
            while ((s2 = LogQueues.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                this.a(jtextarea, jscrollpane, s2);
            }
        });
        this.f.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(b));
        this.f.setDaemon(true);
        return jpanel;
    }

    public void a() {
        this.f.start();
    }

    public void b() {
        if (!this.h.getAndSet(true)) {
            this.f();
        }
    }

    void f() {
        this.g.forEach(Runnable::run);
    }

    public void a(JTextArea textArea, JScrollPane scrollPane, String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.a(textArea, scrollPane, message));
        } else {
            Document document = textArea.getDocument();
            JScrollBar jscrollbar = scrollPane.getVerticalScrollBar();
            boolean flag = false;
            if (scrollPane.getViewport().getView() == textArea) {
                flag = (double)jscrollbar.getValue() + jscrollbar.getSize().getHeight() + (double)(a.getSize() * 4) > (double)jscrollbar.getMaximum();
            }
            try {
                document.insertString(document.getLength(), ANSI.matcher(message).replaceAll(""), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (flag) {
                jscrollbar.setValue(Integer.MAX_VALUE);
            }
        }
    }
}

