/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman
implements ChunkSystemServerPlayer {
    private static final Logger cz = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cA = 32;
    private static final int cB = 10;
    private static final int cD = 25;
    public static final double b = 1.0;
    private static final AttributeModifier cE = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    public PlayerConnection c;
    public final MinecraftServer d;
    public final PlayerInteractManager e;
    private final AdvancementDataPlayer cG;
    private final ServerStatisticManager cH;
    private float cI = Float.MIN_VALUE;
    private int cJ = Integer.MIN_VALUE;
    private int cK = Integer.MIN_VALUE;
    private int cL = Integer.MIN_VALUE;
    private int cM = Integer.MIN_VALUE;
    private int cN = Integer.MIN_VALUE;
    private float cO = -1.0E8f;
    private int cP = -99999999;
    private boolean cQ = true;
    public int cR = -99999999;
    public int cS = 60;
    private EnumChatVisibility cT;
    private boolean cU = true;
    private long cV;
    @Nullable
    private net.minecraft.world.entity.Entity cW;
    public boolean cX;
    public boolean f;
    private final RecipeBookServer cY;
    @Nullable
    private Vec3D cZ;
    private int da;
    private boolean db;
    private int dc = 2;
    public String dd = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D de;
    @Nullable
    private Vec3D df;
    @Nullable
    private Vec3D dg;
    private SectionPosition dh;
    private ChunkTrackingView di;
    private ResourceKey<net.minecraft.world.level.World> dj;
    @Nullable
    private BlockPosition dk;
    private boolean dl;
    private float dm;
    private final ITextFilter dn;
    private boolean do;
    private boolean dp;
    private boolean dq;
    public WardenSpawnTracker dr;
    @Nullable
    private BlockPosition ds;
    private Vec3D dt;
    public final ContainerSynchronizer du;
    private final ICrafting dv;
    @Nullable
    private RemoteChatSession dw;
    @Nullable
    public final Object g;
    private int dx;
    public boolean h;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile, ClientInformation clientOptions) {
        super(world, world.V(), world.W(), profile);
        this.cT = EnumChatVisibility.a;
        this.cV = SystemUtils.c();
        this.cY = new RecipeBookServer();
        this.dh = SectionPosition.a(0, 0, 0);
        this.di = ChunkTrackingView.a;
        this.dj = net.minecraft.world.level.World.h;
        this.dr = new WardenSpawnTracker(0, 0, 0);
        this.dt = Vec3D.b;
        this.du = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.c.b(new PacketPlayOutWindowItems(handler.j, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(EntityPlayer.this.cc.j, EntityPlayer.this.cc.k(), 45, EntityPlayer.this.cc.b(45).g().s()));
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(handler.j, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.c.b(new PacketPlayOutSetSlot(-1, handler.k(), -1, stack));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.c.b(new PacketPlayOutWindowData(handler.j, property, value));
            }
        };
        this.dv = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.fY()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fY(), stack);
                }
            }

            @Override
            public void slotChanged(Container handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.fY()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fY(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.fY(), stack);
                    }
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.dn = server.a(this);
        this.e = server.b(this);
        this.d = server;
        this.cH = server.ah().getPlayerStats(this);
        this.cG = server.ah().g(this);
        this.updateOptionsNoEvents(clientOptions);
        this.g = null;
        this.displayName = this.cB();
        this.adventure$displayName = Component.text((String)this.cB());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eN();
    }

    @Deprecated
    public void resendItemInHands() {
        this.cd.b(this.fY(), this.fY().k).ifPresent(s2 -> this.du.a(this.cd, s2, this.eT()));
        this.du.a((Container)this.cc, 45, this.eU());
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.V();
        if (worldserver.D_().g() && worldserver.K.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(worldserver));
            int j2 = MathHelper.a(worldserver.C_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPosition a(WorldServer world, BlockPosition basePos) {
        AxisAlignedBB axisalignedbb = this.a(EntityPose.a).a(Vec3D.b);
        BlockPosition blockposition1 = basePos;
        if (world.D_().g() && world.K.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.d.a(world));
            int j2 = MathHelper.a(world.C_().b(basePos.u(), basePos.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                blockposition1 = WorldProviderNormal.a(world, basePos.u() + j22 - i2, basePos.w() + k22 - i2);
                if (blockposition1 == null || !world.a((net.minecraft.world.entity.Entity)this, axisalignedbb.c(blockposition1.c()))) continue;
                return blockposition1;
            }
            blockposition1 = basePos;
        }
        while (!world.a((net.minecraft.world.entity.Entity)this, axisalignedbb.c(blockposition1.c())) && blockposition1.v() < world.am() - 1) {
            blockposition1 = blockposition1.d();
        }
        while (world.a((net.minecraft.world.entity.Entity)this, axisalignedbb.c(blockposition1.e().c())) && blockposition1.v() > world.I_() + 1) {
            blockposition1 = blockposition1.e();
        }
        return blockposition1;
    }

    private int t(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        Logger logger;
        DataResult dataresult;
        super.a(nbt);
        if (nbt.b("warden_spawn_tracker", 10)) {
            dataresult = WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("warden_spawn_tracker")));
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.dr = wardenspawntracker;
            });
        }
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.df = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.f = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.cY.a(nbt.p("recipeBook"), this.d.aJ());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fH()) {
            this.fI();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.dj = oldWorld.getHandle().af();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.dk = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.dl = nbt.q("SpawnForced");
            this.dm = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger1 = cz;
                Objects.requireNonNull(logger1);
                this.dj = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
        this.dq = nbt.q("spawn_extra_particles_on_fall");
        NBTBase nbtbase = nbt.c("raid_omen_position");
        if (nbtbase != null) {
            dataresult = BlockPosition.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbtbase);
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(blockposition -> {
                this.ds = blockposition;
            });
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dr);
        Logger logger = cz;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbt);
        nbt.a("seenCredits", this.f);
        if (this.df != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.df.c);
            nbttagcompound1.a("y", this.df.d);
            nbttagcompound1.a("z", this.df.e);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cZ();
        net.minecraft.world.entity.Entity entity1 = this.dc();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.dc()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cY() && !entity.dJ()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.cz());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbt.a("RootVehicle", nbttagcompound2);
        }
        nbt.a("recipeBook", this.cY.b());
        nbt.a("Dimension", this.dO().af().a().toString());
        if (this.dk != null) {
            nbt.a("SpawnX", this.dk.u());
            nbt.a("SpawnY", this.dk.v());
            nbt.a("SpawnZ", this.dk.w());
            nbt.a("SpawnForced", this.dl);
            nbt.a("SpawnAngle", this.dm);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dj.a());
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
        nbt.a("spawn_extra_particles_on_fall", this.dq);
        if (this.ds != null) {
            dataresult = BlockPosition.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.ds);
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("raid_omen_position", (NBTBase)nbtbase));
        }
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dL();
            Vec3D position = null;
            if (this.dj != null && (world = this.d.a(this.dj)) != null && this.S() != null) {
                position = EntityPlayer.a((WorldServer)world, this.S(), this.T(), false, false).map(RespawnPosAngle::a).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.V());
            }
            this.a(world);
            this.o(position.a(), position.b(), position.c());
        }
        this.e.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.gh();
        float f1 = (f2 - 1.0f) / f2;
        this.cs = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cR = -1;
    }

    public void b(int level) {
        this.cq = level;
        this.cR = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cR = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cR = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.dv);
        screenHandler.a(this.du);
    }

    public void h() {
        this.a(this.cc);
    }

    @Override
    public void f_() {
        super.f_();
        this.c.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void g_() {
        super.g_();
        this.c.b(new ClientboundPlayerCombatEndPacket(this.eL()));
    }

    @Override
    public void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.e.a();
        this.dr.a();
        --this.cS;
        if (this.am > 0) {
            --this.am;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.cd.d();
            this.containerUpdateDelay = this.dO().paperConfig().tickRates.containerUpdate;
        }
        if (!(this.dO().B || this.cd == this.cc || !this.fc() && this.cd.b(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cd = this.cc;
        }
        if ((entity = this.L()) != this) {
            if (entity.bE()) {
                this.a(entity.dt(), entity.dv(), entity.dz(), entity.dE(), entity.dG());
                this.A().l().a(this);
                if (this.fO()) {
                    this.d((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.d((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.cZ != null) {
            CriterionTriggers.v.a(this, this.cZ, this.ai - this.da);
        }
        this.o();
        this.p();
        this.gD();
        this.cG.b(this);
    }

    private void gD() {
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.f(GenericAttributes.g);
        if (attributemodifiable != null) {
            if (this.f()) {
                attributemodifiable.a(cE);
            } else {
                attributemodifiable.e(cE);
            }
        }
        if ((attributemodifiable1 = this.f(GenericAttributes.j)) != null) {
            if (this.f()) {
                attributemodifiable1.a(cF);
            } else {
                attributemodifiable1.e(cF);
            }
        }
    }

    public void m() {
        try {
            if (this.valid && !this.R_() || !this.dh()) {
                super.l();
            }
            for (int i2 = 0; i2 < this.fY().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fY().a(i2);
                if (!itemstack.g().ao_() || (packet = ((ItemWorldMapBase)itemstack.g()).a(itemstack, this.dO(), this)) == null) continue;
                this.c.b(packet);
            }
            if (this.ew() != this.cO || this.cP != this.ce.a() || this.ce.e() == 0.0f != this.cQ) {
                this.c.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.ce.a(), this.ce.e()));
                this.cO = this.ew();
                this.cP = this.ce.a();
                boolean bl = this.cQ = this.ce.e() == 0.0f;
            }
            if (this.ew() + this.fo() != this.cI) {
                this.cI = this.ew() + this.fo();
                this.a(IScoreboardCriteria.g, MathHelper.f(this.cI));
            }
            if (this.ce.a() != this.cJ) {
                this.cJ = this.ce.a();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cJ));
            }
            if (this.cm() != this.cK) {
                this.cK = this.cm();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cK));
            }
            if (this.eK() != this.cL) {
                this.cL = this.eK();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cL));
            }
            if (this.cr != this.cN) {
                this.cN = this.cr;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cN));
            }
            if (this.maxHealthCache != (double)this.eN()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cq != this.cM) {
                this.cM = this.cq;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cM));
            }
            if (this.cr != this.cR) {
                this.cR = this.cr;
                this.c.b(new PacketPlayOutExperience(this.cs, this.cr, this.cq));
            }
            if (this.ai % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cq;
            }
            if (this.oldLevel != this.cq) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cq);
                this.oldLevel = this.cq;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.ew() > 0.0f && this.de != null) {
            CriterionTriggers.X.a(this, this.de);
        }
        this.de = null;
        super.n();
    }

    public void o() {
        if (this.ac > 0.0f && this.de == null) {
            this.de = this.dm();
            if (this.cx != null && this.cx.d <= this.de.d) {
                CriterionTriggers.ae.a(this, this.cx, this.cy);
            }
        }
    }

    public void p() {
        if (this.dc() != null && this.dc().bt()) {
            if (this.dg == null) {
                this.dg = this.dm();
            } else {
                CriterionTriggers.Y.a(this, this.dg);
            }
        }
        if (!(this.dg == null || this.dc() != null && this.dc().bt())) {
            this.dg = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(criterion, this, scoreaccess -> scoreaccess.a(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.a(item, EnchantmentEffectComponents.D) || itemsToKeep.isEmpty() || item.e()) {
                inv.set(i2, ItemStack.l);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.l);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        boolean flag = this.dO().ab().b(GameRules.n);
        if (this.dJ()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.fY().b());
        boolean bl = keepInventory = this.dO().ab().b(GameRules.d) || this.R_();
        if (!keepInventory) {
            for (ItemStack item : this.fY().getContents()) {
                if (item.e() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false)));
            }
        }
        if (this.ef() && this.dO().ab().b(GameRules.f)) {
            this.a(damageSource, this.bd > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eL().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damageSource, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.ew() <= 0.0f) {
                this.v((float)event.getReviveHealth());
            }
            return;
        }
        ((net.minecraft.world.entity.Entity)this).a(GameEvent.p);
        if (this.cd != this.cc) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.c.a(new ClientboundPlayerCombatKillPacket(this.an(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.S_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.an(), ichatmutablecomponent1);
            }));
            ScoreboardTeam scoreboardTeam = this.ck();
            if (scoreboardTeam != null && scoreboardTeam.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeam.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.d.ah().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeam.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.d.ah().b(this, ichatbasecomponent);
                }
            } else {
                this.d.ah().a(ichatbasecomponent, false);
            }
        } else {
            this.c.b(new ClientboundPlayerCombatKillPacket(this.an(), CommonComponents.a));
        }
        this.gm();
        if (this.dO().ab().b(GameRules.N)) {
            this.gE();
        }
        if (event.shouldDropExperience()) {
            this.C(damageSource.d());
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.fY().n) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.d((net.minecraft.world.entity.Entity)this);
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.d, this, ScoreAccess::b);
        EntityLiving entityliving = this.eM();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.am()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bl, damageSource);
            this.f(entityliving);
        }
        this.dO().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aD();
        this.k(0);
        this.c(false);
        this.eL().c();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.dO().af(), this.do())));
    }

    private void gE() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.do()).c(32.0, 10.0, 32.0);
        this.dO().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.s(score);
            this.dO().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dO().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entityKilled, IScoreboardCriteria.m);
            this.a((ScoreHolder)entityKilled, (ScoreHolder)this, IScoreboardCriteria.n);
            CriterionTriggers.c.a(this, entityKilled, damageSource);
        }
    }

    private void a(ScoreHolder targetScoreHolder, ScoreHolder aboutScoreHolder, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gn().e(aboutScoreHolder.cB());
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.dO().getCraftServer().getScoreboardManager().forAllObjectives(criterions[i2], targetScoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(source)) {
            return false;
        }
        boolean bl = flag = this.d.n() && this.gF() && source.a(DamageTypeTags.m);
        if (!flag && this.cS > 0 && !source.a(DamageTypeTags.d)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).s()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.c.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.gF() ? false : super.a(player);
    }

    private boolean gF() {
        return this.dO().pvpMode;
    }

    public DimensionTransition findRespawnPositionAndUseSpawnBlock(boolean flag, DimensionTransition.a dimensiontransition_a, PlayerRespawnEvent.RespawnReason reason) {
        DimensionTransition dimensionTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        BlockPosition blockposition = this.S();
        float f2 = this.T();
        boolean flag1 = this.V();
        WorldServer worldserver = this.d.a(this.U());
        if (worldserver != null && blockposition != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, blockposition, f2, flag1, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                dimensionTransition = new DimensionTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.b, entityplayer_respawnposangle.b(), 0.0f, dimensiontransition_a);
            } else {
                dimensionTransition = DimensionTransition.a(this.d.I(), this, dimensiontransition_a);
            }
        } else {
            dimensionTransition = new DimensionTransition(this.d.I(), this, dimensiontransition_a);
        }
        if (reason == null) {
            return dimensionTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(dimensionTransition.b(), (World)dimensionTransition.a().getWorld(), dimensionTransition.d(), dimensionTransition.e());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (reason == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.END_PORTAL);
        }
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason, builder);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.c.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new DimensionTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), dimensionTransition.c(), location.getYaw(), location.getPitch(), dimensionTransition.f(), dimensionTransition.g(), dimensionTransition.cause());
    }

    public static Optional<RespawnPosAngle> a(WorldServer world, BlockPosition pos, float spawnAngle, boolean spawnForced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (spawnForced || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.by, world, pos);
            if (!spawnForced && !alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.a(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, pos, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.by, (ICollisionAccess)world, pos, iblockdata.c(BlockFacingHorizontal.aE), spawnAngle).map(vec3d -> RespawnPosAngle.of(vec3d, pos, true, false));
        }
        if (!spawnForced) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = world.a_(pos.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5), spawnAngle, false, false)) : Optional.empty();
    }

    public void q() {
        this.ak();
        this.A().a(this, Entity.RemovalReason.e);
        if (!this.h) {
            if (this.dO().paperConfig().misc.disableEndCredits) {
                this.f = true;
            }
            this.h = true;
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.f = true;
        }
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(DimensionTransition teleportTarget) {
        if (this.fH()) {
            return null;
        }
        if (this.dJ()) {
            return null;
        }
        if (teleportTarget.f()) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = teleportTarget.a();
        WorldServer worldserver1 = this.A();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (worldserver != null && worldserver.af() == worldserver1.af()) {
            TileEntity tileEntity;
            if (this.aw != null && this.aw.a((BlockEndGateway)Blocks.kF) && (tileEntity = this.A().c_(this.aw.c())) instanceof TileEntityEndGateway) {
                TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
                Location to = CraftLocation.toBukkit(teleportTarget.b(), (World)this.A().getWorld(), teleportTarget.d(), teleportTarget.e());
                PlayerTeleportEndGatewayEvent event = new PlayerTeleportEndGatewayEvent((Player)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), to, (EndGateway)new CraftEndGateway(to.getWorld(), theEndGatewayBlockEntity));
                if (!event.callEvent() || event.getTo() == null) {
                    return null;
                }
                this.c.teleport(event.getTo());
            } else {
                boolean result = this.c.teleport(teleportTarget.b().c, teleportTarget.b().d, teleportTarget.b().e, teleportTarget.d(), teleportTarget.e(), teleportTarget.cause());
                if (!result) {
                    return null;
                }
            }
            this.c.l();
            teleportTarget.g().onTransition(this);
            return this;
        }
        worldserver1.ag().a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.df = this.dm();
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(teleportTarget.b(), (World)worldserver.getWorld(), teleportTarget.d(), teleportTarget.e());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleportTarget.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ag().c();
        worldserver1.ag().a("placing");
        this.cX = true;
        WorldData worlddata = worldserver.A_();
        this.c.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.c.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerlist = this.d.ah();
        playerlist.e(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dL();
        this.a(worldserver);
        this.c.teleport(exit);
        this.c.l();
        worldserver.d(this);
        worldserver1.ag().c();
        this.c(worldserver1);
        this.c.b(new PacketPlayOutAbilities(this.fZ()));
        playerlist.a(this, worldserver);
        playerlist.f(this);
        playerlist.d(this);
        teleportTarget.g().onTransition(this);
        this.cR = -1;
        this.cO = -1.0f;
        this.cP = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dO().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.fy()) {
            this.fx();
        }
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    public void c(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.af();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dO().af();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dO());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.df != null) {
            CriterionTriggers.D.a(this, this.df);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.df = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.R_() ? this.L() == this : (this.R_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.cd.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fH() && this.bE()) {
            if (!this.dO().D_().j() || !this.dO().D_().l()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.dO().af(), blockposition, this.dE(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.dO().R()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dO().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a((EntityHuman)this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dO().a_(blockposition).c(BlockFacingHorizontal.aE);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.A().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dO()).e();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dt() - vec3d.a()) <= 3.0 && Math.abs(this.dv() - vec3d.b()) <= 2.0 && Math.abs(this.dz() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(direction.g()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fH()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fF().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.dO().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dO().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fH()) {
            this.A().l().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.c != null) {
            this.c.teleport(this.dt(), this.dv(), this.dz(), this.dE(), this.dG(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.bJ();
        this.a_(destX, destY, destZ);
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) || this.P() || !this.dO().paperConfig().collisions.allowPlayerCrammingDamage && damageSource == this.dP().h();
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    protected void b(WorldServer world, BlockPosition pos) {
        if (!this.R_()) {
            super.b(world, pos);
        }
    }

    public void a(double xDifference, double yDifference, double zDifference, boolean onGround) {
        if (!this.dh()) {
            this.b(onGround, new Vec3D(xDifference, yDifference, zDifference));
            BlockPosition blockposition = this.aK();
            IBlockData iblockdata = this.dO().a_(blockposition);
            if (this.dq && onGround && this.ac > 0.0f) {
                Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
                int i2 = (int)MathHelper.a(50.0f * this.ac, 0.0f, 200.0f);
                this.A().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.c, vec3d.d, vec3d.e, i2, (double)0.3f, (double)0.3f, (double)0.3f, 0.15f);
                this.dq = false;
            }
            super.a(yDifference, onGround, iblockdata, blockposition);
        }
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity) {
        super.a(entity);
        this.cx = this.dm();
        this.cy = entity;
        this.w(entity != null && entity.am() == EntityTypes.bn);
    }

    @Override
    protected void r() {
        if (this.dO().s().i()) {
            super.r();
        }
    }

    @Override
    public void a(TileEntitySign sign, boolean front) {
        this.c.b(new PacketPlayOutBlockChange(this.dO(), sign.aD_()));
        this.c.b(new PacketPlayOutOpenSignEditor(sign.aD_(), front));
    }

    public int nextContainerCounter() {
        this.dx = this.dx % 100 + 1;
        return this.dx;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.dx, this.fY(), this);
        IChatBaseComponent title = null;
        if (container != null) {
            container.setTitle(factory.S_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, container, cancelled);
            container = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.R_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cd = container;
        if (!this.fc()) {
            this.c.b(new PacketPlayOutOpenWindow(container.j, container.a(), Objects.requireNonNullElseGet(title, container::getTitle)));
        }
        this.a(container);
        return OptionalInt.of(this.dx);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.c.b(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dx, this.fY(), inventory, horse, horse.af_());
        container.setTitle(horse.S_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.cd != this.cc) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int i2 = horse.af_();
        this.c.b(new PacketPlayOutOpenWindowHorse(this.dx, i2, horse.an()));
        this.cd = container;
        this.a(this.cd);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.a(Items.ua)) {
            if (ItemWrittenBook.a(book, this.dg(), this)) {
                this.cd.d();
            }
            this.c.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.c.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::e));
    }

    @Override
    public void s() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.b(new PacketPlayOutCloseWindow(this.cd.j));
        this.t();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.c.b(new PacketPlayOutCloseWindow(this.cd.j));
        this.cd = this.cc;
    }

    @Override
    public void t() {
        this.cd.a(this);
        this.cc.a(this.cd);
        this.cd = this.cc;
    }

    public void a(float sidewaysSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        if (this.bS()) {
            if (sidewaysSpeed >= -1.0f && sidewaysSpeed <= 1.0f) {
                this.bo = sidewaysSpeed;
            }
            if (forwardSpeed >= -1.0f && forwardSpeed <= 1.0f) {
                this.bq = forwardSpeed;
            }
            this.bn = jumping;
            if (sneaking != this.bW()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), sneaking);
                this.d.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.g(sneaking);
        }
    }

    @Override
    public void a(Vec3D movementInput) {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.a(movementInput);
        this.b(this.dt() - d0, this.dv() - d1, this.dz() - d2);
    }

    @Override
    public void u() {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.u();
        this.q(this.dt() - d0, this.dv() - d1, this.dz() - d2);
    }

    public void b(double deltaX, double deltaY, double deltaZ) {
        if (!this.bS() && !EntityPlayer.r(deltaX, deltaY, deltaZ)) {
            if (this.cd()) {
                int i2 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dO().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.dO().spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bf()) {
                int i4 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.dO().spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.p_()) {
                if (deltaY > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(deltaY * 100.0));
                }
            } else if (this.aF()) {
                int i5 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i5 > 0) {
                    if (this.cc()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.dO().spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cb()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.dO().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.dO().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fA()) {
                int i6 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void q(double deltaX, double deltaY, double deltaZ) {
        if (this.bS() && !EntityPlayer.r(deltaX, deltaY, deltaZ)) {
            int i2 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
            net.minecraft.world.entity.Entity entity = this.dc();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof EntityBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    private static boolean r(double deltaX, double deltaY, double deltaZ) {
        return deltaX == 0.0 && deltaY == 0.0 && deltaZ == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cH.b(this, stat, amount);
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, scoreaccess -> scoreaccess.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cH.a(this, stat, 0);
        this.dO().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.cY.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> ingredients) {
        CriterionTriggers.ac.a(this, recipe.a(), ingredients);
    }

    @Override
    public void b(List<MinecraftKey> recipes) {
        List<RecipeHolder<?>> list1 = recipes.stream().flatMap(minecraftkey -> this.d.aJ().a((MinecraftKey)minecraftkey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.cY.b(recipes, this);
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cR = -1;
    }

    public void v() {
        this.db = true;
        this.bI();
        if (this.bS() && this.dc() instanceof EntityPlayer) {
            this.ad();
        }
        if (this.fH()) {
            this.a(true, false);
        }
    }

    public boolean w() {
        return this.db;
    }

    public void x() {
        this.cO = -1.0E8f;
        this.cR = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    public void L_() {
        if (!this.bz.e() && this.fr()) {
            this.c.b(new PacketPlayOutEntityStatus(this, 9));
            super.L_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.c.b(new PacketPlayOutLookAt(anchorPoint, target.c, target.d, target.e));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.c.b(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.dr = oldPlayer.dr;
        this.dw = oldPlayer.dw;
        this.e.a(oldPlayer.e.b(), oldPlayer.e.c());
        this.z();
        this.eS().b(oldPlayer.eS());
        if (alive) {
            this.fY().a(oldPlayer.fY());
            this.v(oldPlayer.ew());
            this.ce = oldPlayer.ce;
            for (MobEffect mobEffect : oldPlayer.et()) {
            }
            this.cq = oldPlayer.cq;
            this.cr = oldPlayer.cr;
            this.cs = oldPlayer.cs;
            this.r(oldPlayer.fS());
            this.aw = oldPlayer.aw;
        } else if (this.dO().ab().b(GameRules.d) || oldPlayer.R_()) {
            this.fY().a(oldPlayer.fY());
            this.cq = oldPlayer.cq;
            this.cr = oldPlayer.cr;
            this.cs = oldPlayer.cs;
            this.r(oldPlayer.fS());
        }
        this.ct = oldPlayer.ct;
        this.cb = oldPlayer.cb;
        this.ar().a(EntityHuman.bX, oldPlayer.ar().a(EntityHuman.bX));
        this.cR = -1;
        this.cO = -1.0f;
        this.cP = -1;
        this.f = oldPlayer.f;
        this.df = oldPlayer.df;
        this.di = oldPlayer.di;
        this.i(oldPlayer.gp());
        this.j(oldPlayer.gq());
        ((EntityHuman)this).a(oldPlayer.gx());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.c.b(new PacketPlayOutEntityEffect(this.an(), effect, true));
        if (effect.a(MobEffects.y)) {
            this.da = this.ai;
            this.cZ = this.dm();
        }
        CriterionTriggers.B.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.c.b(new PacketPlayOutEntityEffect(this.an(), effect, false));
        CriterionTriggers.B.a(this, source);
    }

    @Override
    protected void a(MobEffect effect) {
        super.a(effect);
        this.c.b(new PacketPlayOutRemoveEntityEffect(this.an(), effect.c()));
        if (effect.a(MobEffects.y)) {
            this.cZ = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void c(double destX, double destY, double destZ) {
        this.c.a(destX, destY, destZ, this.dE(), this.dG(), RelativeMovement.g);
    }

    @Override
    public void d(double offsetX, double offsetY, double offsetZ) {
        this.c.a(this.dt() + offsetX, this.dv() + offsetY, this.dz() + offsetZ, this.dE(), this.dG(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        return this.teleportTo(world, destX, destY, destZ, flags, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.l().a(TicketType.f, chunkcoordintpair, 1, this.an());
        this.ad();
        if (this.fH()) {
            this.a(true, true);
        }
        if (worldserver == this.dO()) {
            this.c.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.o(f2);
        return true;
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.c.l();
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.A().l().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void c(net.minecraft.world.entity.Entity target) {
        this.A().l().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void z() {
        if (this.c != null) {
            this.c.b(new PacketPlayOutAbilities(this.fZ()));
            this.K();
        }
    }

    public WorldServer A() {
        return (WorldServer)this.dO();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean flag = this.R_();
        PlayerGameModeChangeEvent event = this.e.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gm();
            this.ad();
            EnchantmentManager.a(this);
        } else {
            this.d((net.minecraft.world.entity.Entity)this);
            if (flag) {
                EnchantmentManager.a(this.A(), (EntityLiving)this);
            }
        }
        this.z();
        this.fp();
        return event;
    }

    @Override
    public boolean R_() {
        return this.e.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.e.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.x(overlay)) {
            this.c.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    boolean flag1 = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params, @Nullable IChatBaseComponent unsigned) {
        if (this.gH()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String B() {
        SocketAddress socketaddress = this.c.m();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    private Map<ClientOption<?>, ?> getClientOptionMap(String locale, int viewDistance, ClientOption.ChatVisibility chatVisibility, boolean chatColors, PaperSkinParts skinParts, MainHand mainHand, boolean allowsServerListing, boolean textFilteringEnabled) {
        HashMap<ClientOption, Object> map = new HashMap<ClientOption, Object>();
        map.put(ClientOption.LOCALE, locale);
        map.put(ClientOption.VIEW_DISTANCE, viewDistance);
        map.put(ClientOption.CHAT_VISIBILITY, chatVisibility);
        map.put(ClientOption.CHAT_COLORS_ENABLED, chatColors);
        map.put(ClientOption.SKIN_PARTS, skinParts);
        map.put(ClientOption.MAIN_HAND, mainHand);
        map.put(ClientOption.ALLOW_SERVER_LISTINGS, allowsServerListing);
        map.put(ClientOption.TEXT_FILTERING_ENABLED, textFilteringEnabled);
        return map;
    }

    public void a(ClientInformation clientOptions) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), this.getClientOptionMap(clientOptions.b(), clientOptions.c(), ClientOption.ChatVisibility.valueOf((String)clientOptions.d().name()), clientOptions.e(), new PaperSkinParts(clientOptions.f()), clientOptions.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT, clientOptions.i(), clientOptions.h())).callEvent();
        if (this.fq() != clientOptions.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fq() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        if (this.dd == null || !this.dd.equals(clientOptions.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientOptions.b());
            this.d.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientOptions);
    }

    public void updateOptionsNoEvents(ClientInformation clientOptions) {
        this.dd = clientOptions.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.dd), Locale.US);
        this.dc = clientOptions.c();
        this.cT = clientOptions.d();
        this.cU = clientOptions.e();
        this.do = clientOptions.h();
        this.dp = clientOptions.i();
        this.ar().a(EntityHuman.bX, (byte)clientOptions.f());
        this.ar().a(EntityHuman.bY, (byte)clientOptions.g().a());
    }

    public ClientInformation C() {
        byte b0 = this.ar().a(EntityHuman.bX);
        EnumMainHand enummainhand = EnumMainHand.d.apply(this.ar().a(EntityHuman.bY).byteValue());
        return new ClientInformation(this.dd, this.dc, this.cT, this.cU, b0, enummainhand, this.do, this.dp);
    }

    public boolean D() {
        return this.cU;
    }

    public EnumChatVisibility E() {
        return this.cT;
    }

    private boolean x(boolean overlay) {
        return this.cT == EnumChatVisibility.c ? overlay : true;
    }

    private boolean gH() {
        return this.cT == EnumChatVisibility.a;
    }

    public int F() {
        return this.dc;
    }

    public void a(ServerPing metadata) {
        this.c.b(new ClientboundServerDataPacket(metadata.a(), metadata.d().map(ServerPing.a::a)));
    }

    @Override
    protected int G() {
        return this.d.c(this.fX());
    }

    public void H() {
        this.cV = SystemUtils.c();
    }

    public ServerStatisticManager I() {
        return this.cH;
    }

    public RecipeBookServer J() {
        return this.cY;
    }

    @Override
    protected void K() {
        if (this.R_()) {
            this.er();
            this.k(true);
        } else {
            super.K();
        }
    }

    public net.minecraft.world.entity.Entity L() {
        return this.cW == null ? this : this.cW;
    }

    public void d(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.L();
        net.minecraft.world.entity.Entity entity2 = this.cW = entity == null ? this : entity;
        if (entity1 != this.cW) {
            net.minecraft.world.level.World world;
            if (this.cW == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.cW = entity1;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.cW = entity1;
                    return;
                }
            }
            if ((world = this.cW.dO()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cW.dt(), this.cW.dv(), this.cW.dz(), Set.of(), this.dE(), this.dG(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.A().l().a(this);
            }
            this.c.b(new PacketPlayOutCamera(this.cW));
            this.c.l();
        }
    }

    @Override
    protected void M() {
        if (!this.cX) {
            super.M();
        }
    }

    @Override
    public void e(net.minecraft.world.entity.Entity target) {
        if (this.e.b() == EnumGamemode.d) {
            this.d(target);
        } else {
            super.e(target);
        }
    }

    public long N() {
        return this.cV;
    }

    @Nullable
    public IChatBaseComponent O() {
        return this.listName;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gs();
    }

    public boolean P() {
        return this.cX;
    }

    public void Q() {
        this.cX = false;
    }

    public AdvancementDataPlayer R() {
        return this.cG;
    }

    public void a(WorldServer targetWorld, double x2, double y2, double z2, float yaw, float pitch) {
        this.teleportTo(targetWorld, x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.d((net.minecraft.world.entity.Entity)this);
        this.ad();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition S() {
        return this.dk;
    }

    public float T() {
        return this.dm;
    }

    public ResourceKey<net.minecraft.world.level.World> U() {
        return this.dj;
    }

    public boolean V() {
        return this.dl;
    }

    public void b(EntityPlayer player) {
        this.a(player.U(), player.S(), player.T(), player.V(), false);
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.dk) && dimension.equals(this.dj);
            spawnLoc = MCUtil.toLocation(this.cO().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().af() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.dk = pos;
            this.dj = dimension;
            this.dm = angle;
            this.dl = forced;
        } else {
            this.dk = null;
            this.dj = net.minecraft.world.level.World.h;
            this.dm = 0.0f;
            this.dl = false;
        }
        return true;
    }

    public SectionPosition W() {
        return this.dh;
    }

    public void a(SectionPosition section) {
        this.dh = section;
    }

    public ChunkTrackingView X() {
        return this.di;
    }

    public void a(ChunkTrackingView chunkFilter) {
        this.di = chunkFilter;
    }

    @Override
    public void a(SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(sound), category, this.dt(), this.dv(), this.dz(), volume, pitch, this.ah.g()));
    }

    @Override
    public EntityItem a(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        EntityItem entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (entityitem == null) {
            return null;
        }
        this.dO().b(entityitem);
        ItemStack itemstack1 = entityitem.p();
        if (flag1) {
            if (!itemstack1.e()) {
                this.a(StatisticList.f.b(itemstack1.g()), itemstack1.H());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter Y() {
        return this.dn;
    }

    public void a(WorldServer world) {
        this.a((net.minecraft.world.level.World)world);
        this.e.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.d.bf();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.d.u_());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.d.bf() != null && this.d.bf() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.d.u_().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.e.a(this.d.bf(), EnumGamemode.e);
            } else {
                this.e.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.e.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.e.b().a());
        EnumGamemode enumgamemode = this.e.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean Z() {
        return this.do;
    }

    public boolean c(EntityPlayer player) {
        return player == this ? false : this.do || player.do;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return super.a(world, pos) && world.a(this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.W.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.fY();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.cd.b(playerinventory, playerinventory.k).ifPresent(i2 -> this.cd.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean aa() {
        return this.dp;
    }

    @Override
    public Optional<WardenSpawnTracker> ab() {
        return Optional.of(this.dr);
    }

    public void b(boolean spawnExtraParticlesOnFall) {
        this.dq = spawnExtraParticlesOnFall;
    }

    @Override
    public void a(EntityItem item) {
        super.a(item);
        net.minecraft.world.entity.Entity entity = item.s();
        if (entity != null) {
            CriterionTriggers.S.a(this, item.p(), entity);
        }
    }

    public void a(RemoteChatSession session) {
        this.dw = session;
    }

    @Nullable
    public RemoteChatSession ac() {
        return this.dw != null && this.dw.b() ? null : this.dw;
    }

    @Override
    public void a(double deltaX, double deltaZ) {
        this.cw = (float)(MathHelper.d(deltaZ, deltaX) * 57.2957763671875 - (double)this.dE());
        this.c.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force) {
        if (super.a(entity, force)) {
            this.b(Vec3D.b);
            entity.j(this);
            this.c.a(this.dt(), this.dv(), this.dz(), this.dE(), this.dG());
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.d.ah().a(entityliving, this.c);
            }
            return true;
        }
        return false;
    }

    @Override
    public void ad() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity entity = this.dc();
        super.stopRiding(suppressCancellation);
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.et()) {
                this.c.b(new PacketPlayOutRemoveEntityEffect(entity.an(), mobeffect.c()));
            }
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer world) {
        return new CommonPlayerSpawnInfo(world.ae(), world.af(), BiomeManager.a(world.C()), this.e.b(), this.e.c(), world.ai(), world.B(), this.gx(), this.az());
    }

    public void c(BlockPosition startRaidPos) {
        this.ds = startRaidPos;
    }

    public void ae() {
        this.ds = null;
    }

    @Nullable
    public BlockPosition af() {
        return this.ds;
    }

    @Override
    public Vec3D ag() {
        net.minecraft.world.entity.Entity entity = this.dc();
        return entity != null && entity.cQ() != this ? entity.ag() : this.dt;
    }

    public void b(Vec3D movement) {
        this.dt = movement;
    }

    @Override
    protected float a(net.minecraft.world.entity.Entity target, float baseDamage, DamageSource damageSource) {
        return EnchantmentManager.a(this.A(), this.dS(), target, damageSource, baseDamage);
    }

    @Override
    public void a(Item item, EnumItemSlot slot) {
        super.a(item, slot);
        this.b(StatisticList.d.b(item));
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dO().aa() + this.timeOffset;
        }
        return this.dO().aa() - this.dO().aa() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dO().A_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cB() + " at " + this.dt() + "," + this.dv() + "," + this.dz() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.c.l();
    }

    @Override
    public boolean fc() {
        return super.fc() || this.c != null && this.c.isDisconnected();
    }

    @Override
    public Scoreboard gn() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.dO().ab().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.cs;
            this.newTotalExp = this.cr;
            this.newLevel = this.cq;
        }
        this.v(this.eN());
        this.fx();
        this.j(this.cl());
        this.h(0);
        this.ac = 0.0f;
        this.ce = new FoodMetaData(this);
        this.cq = this.newLevel;
        this.cr = this.newTotalExp;
        this.cs = 0.0f;
        this.aQ = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).cb = true;
        this.cd = this.cc;
        this.bc = null;
        ((EntityLiving)this).cc = null;
        ((EntityLiving)this).bV = new CombatTracker(this);
        this.cR = -1;
        if (this.keepLevel) {
            this.cs = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        ((EntityLiving)this).cp = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.b(vec3d, blockposition), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D respawnPos, BlockPosition currentPos) {
            Vec3D vec3d1 = Vec3D.c(currentPos).d(respawnPos).d();
            return (float)MathHelper.d(MathHelper.d(vec3d1.e, vec3d1.c) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

