/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.moonrise.common.list.IBlockDataList;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingHistory;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R1.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;

public class WorldServer
extends net.minecraft.world.level.World
implements GeneratorAccessSeed,
ChunkSystemServerLevel,
ChunkSystemLevelReader {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider D = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger E = LogUtils.getLogger();
    private static final int F = 300;
    private static final int G = 65536;
    final List<EntityPlayer> H;
    public final ChunkProviderServer I;
    private final MinecraftServer J;
    public final WorldDataServer K;
    private int L;
    final EntityTickList M;
    private final GameEventDispatcher O;
    public boolean e;
    private final SleepStatus P;
    private int Q;
    private final PortalTravelAgent R;
    private final TickListServer<Block> S;
    private final TickListServer<FluidType> T;
    private final PathTypeCache U;
    final Set<EntityInsentient> V;
    volatile boolean W;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> X;
    private final List<BlockActionData> Y;
    private boolean Z;
    private final List<MobSpawner> aa;
    @Nullable
    private EnderDragonBattle ab;
    final Int2ObjectMap<EntityComplexPart> ac;
    private final StructureManager ad;
    private final StructureCheck ae;
    private final boolean af;
    private final RandomSequences ag;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    private boolean markedClosing;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final ChunkProviderServer.a[] EMPTY_CHUNK_AND_HOLDERS = new ChunkProviderServer.a[0];
    private final ReferenceList<ChunkProviderServer.a> loadedChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ChunkProviderServer.a> tickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ChunkProviderServer.a> entityTickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();

    @Override
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.I.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB axisalignedbb) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.l();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB axisalignedbb, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        EntityPlayer player = this.o().ah().a(uuid);
        return player != null && player.dO() == this ? player : null;
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.I.a(chunkX, chunkZ);
    }

    @Override
    public final IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.J.moonrise$executeMidTickTasks();
    }

    @Override
    public final IChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final RegionFileIOThread.ChunkDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final RegionFileIOThread.ChunkDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final RegionFileIOThread.ChunkDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, PrioritisedExecutor.Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkTaskScheduler.scheduleChunkLoad(cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.bc(), worlddimension.a(), minecraftserver::aT, false, flag, i2, minecraftserver.bl(), gen, biomeProvider, env, spigotConfig -> minecraftserver.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(convertable_conversionsession.c.f(), iworlddataserver.e(), resourcekey.a(), spigotConfig, minecraftserver.bc(), iworlddataserver.o())), executor);
        this.pvpMode = minecraftserver.ad();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.H = Lists.newArrayList();
        this.M = new EntityTickList();
        this.S = new TickListServer(this::d, this.ah());
        this.T = new TickListServer(this::d, this.ah());
        this.U = new PathTypeCache();
        this.V = new ObjectOpenHashSet();
        this.X = new ObjectLinkedOpenHashSet();
        this.Y = new ArrayList<BlockActionData>(64);
        this.ac = new Int2ObjectOpenHashMap();
        this.af = flag1;
        this.J = minecraftserver;
        this.aa = list;
        this.K = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.K.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.J.bc().d(Registries.aF));
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.h(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aZ();
        DataFixer datafixer = minecraftserver.aD();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.s), this, minecraftserver);
        StructureTemplateManager structuretemplatemanager = minecraftserver.ba();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        this.I = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, null, () -> minecraftserver.I().u());
        this.I.h().b();
        this.R = new PortalTravelAgent(this);
        this.U();
        this.X();
        this.C_().a(minecraftserver.ax());
        this.f = this.u().a(PersistentRaid.a(this), PersistentRaid.a(this.ae()));
        if (!minecraftserver.T()) {
            iworlddataserver.a(minecraftserver.u_());
        }
        long l2 = minecraftserver.bb().y().b();
        this.ae = new StructureCheck(this.I.m(), this.H_(), minecraftserver.ba(), this.getTypeKey(), chunkgenerator, this.I.i(), this, chunkgenerator.d(), l2, datafixer);
        this.ad = new StructureManager(this, this.K.y(), this.ae);
        this.ab = this.af() == net.minecraft.world.level.World.j && this.ae().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.K.y().b(), this.K.C()) : null;
        this.P = new SleepStatus();
        this.O = new GameEventDispatcher(this);
        this.ag = Objects.requireNonNullElseGet(randomsequences, () -> this.u().a(RandomSequences.a(l2), "random_sequences"));
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), minecraftserver.aZ()));
        this.poiDataController = new PoiDataController(this);
        this.chunkDataController = new ChunkDataController(this);
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new a()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this, MoonriseCommon.WORKER_POOL);
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.l().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderDragonFight) {
        this.ab = enderDragonFight;
    }

    public void a(int clearDuration, int rainDuration, boolean raining, boolean thundering) {
        this.K.a(clearDuration);
        this.K.c(rainDuration);
        this.K.b(rainDuration);
        this.K.setRaining(raining, WeatherChangeEvent.Cause.COMMAND);
        this.K.setThundering(thundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.l().g().d().getNoiseBiome(biomeX, biomeY, biomeZ, this.l().i().b());
    }

    public StructureManager a() {
        return this.ad;
    }

    public void a(BooleanSupplier shouldKeepTicking) {
        boolean flag1;
        long j2;
        int i2;
        GameProfilerFiller gameprofilerfiller = this.ag();
        this.Z = true;
        TickRateManager tickratemanager = this.s();
        boolean flag = tickratemanager.i();
        if (flag) {
            gameprofilerfiller.a("world border");
            this.C_().s();
            gameprofilerfiller.b("weather");
            this.au();
        }
        if (this.P.a(i2 = this.ab().c(GameRules.P)) && this.P.a(i2, this.H)) {
            j2 = this.A.d() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.aa());
            if (this.ab().b(GameRules.l)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.aa() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.as();
            }
            if (this.ab().b(GameRules.v) && this.ad()) {
                this.g();
            }
        }
        this.U();
        if (flag) {
            this.b();
        }
        gameprofilerfiller.b("tickPending");
        this.timings.scheduledBlocks.startTiming();
        if (!this.ai() && flag) {
            j2 = this.Z();
            gameprofilerfiller.a("blockTicks");
            this.S.a(j2, this.paperConfig().environment.maxBlockTicks, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.T.a(j2, this.paperConfig().environment.maxFluidTicks, this::a);
            gameprofilerfiller.c();
        }
        this.timings.scheduledBlocks.stopTiming();
        gameprofilerfiller.b("raid");
        if (flag) {
            this.timings.raids.startTiming();
            this.f.a();
            this.timings.raids.stopTiming();
        }
        gameprofilerfiller.b("chunkSource");
        this.timings.chunkProviderTick.startTiming();
        this.l().a(shouldKeepTicking, true);
        this.timings.chunkProviderTick.stopTiming();
        gameprofilerfiller.b("blockEvents");
        if (flag) {
            this.timings.doSounds.startTiming();
            this.aw();
            this.timings.doSounds.stopTiming();
        }
        this.Z = false;
        gameprofilerfiller.c();
        boolean bl = flag1 = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || !this.H.isEmpty() || !this.w().isEmpty();
        if (flag1) {
            this.h();
        }
        if (flag1 || this.Q++ < 300) {
            gameprofilerfiller.a("entities");
            this.timings.tickEntities.startTiming();
            if (this.ab != null && flag) {
                gameprofilerfiller.a("dragonFight");
                this.ab.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.timings.entityTick.startTiming();
            this.M.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.dJ() && !tickratemanager.a((net.minecraft.world.entity.Entity)entity)) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dA();
                    gameprofilerfiller.c();
                    net.minecraft.world.entity.Entity entity1 = entity.dc();
                    if (entity1 != null) {
                        if (!entity1.dJ() && entity1.x((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.ad();
                    }
                    gameprofilerfiller.a("tick");
                    this.a(this::a, entity);
                    gameprofilerfiller.c();
                }
            });
            this.timings.entityTick.stopTiming();
            this.timings.tickEntities.stopTiming();
            gameprofilerfiller.c();
            this.T();
        }
        gameprofilerfiller.a("entityManagement");
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void b() {
        if (this.af) {
            long i2 = this.A.c() + 1L;
            this.K.a(i2);
            this.K.s().a(this.J, i2);
            if (this.A.o().b(GameRules.l)) {
                this.b(this.A.d() + 1L);
            }
        }
    }

    public void b(long timeOfDay) {
        this.K.b(timeOfDay);
    }

    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        for (MobSpawner mobspawner : this.aa) {
            mobspawner.a(this, spawnMonsters, spawnAnimals);
        }
    }

    private boolean i(net.minecraft.world.entity.Entity entity) {
        return !this.J.ab() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal) ? true : !this.J.ac() && entity instanceof NPC;
    }

    private void as() {
        this.P.a();
        this.H.stream().filter(EntityLiving::fH).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    private void optimiseRandomTick(Chunk chunk, int tickSpeed) {
        ChunkSection[] sections = chunk.d();
        int minSection = WorldUtil.getMinSection(this);
        RandomSource random = this.z;
        boolean tickFluids = false;
        ChunkCoordIntPair cpos = chunk.f();
        int offsetX = cpos.e << 4;
        int offsetZ = cpos.f << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            IBlockDataList tickList;
            int offsetY = sectionIndex + minSection << 4;
            ChunkSection section = sections[sectionIndex];
            DataPaletteBlock<IBlockData> states = section.h;
            if (section == null || !section.e() || (tickList = section.moonrise$getTickingBlockList()).size() == 0) continue;
            for (int i2 = 0; i2 < tickSpeed; ++i2) {
                int tickingBlocks = tickList.size();
                int index = random.f() & 0xFFF;
                if (index >= tickingBlocks) continue;
                long raw = tickList.getRaw(index);
                int location = IBlockDataList.getLocationFromRaw(raw);
                int randomX = location & 0xF;
                int randomY = location >>> 8 & 0xFF;
                int randomZ = location >>> 4 & 0xF;
                IBlockData state = states.a(randomX | randomZ << 4 | randomY << 8);
                BlockPosition pos = new BlockPosition(randomX | offsetX, randomY | offsetY, randomZ | offsetZ);
                state.b(this, pos, random);
            }
        }
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        BlockPosition blockposition;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.ad();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = this.ag();
        gameprofilerfiller.a("thunder");
        if (!this.paperConfig().environment.disableThunder && flag && this.ac() && this.spigotConfig.thunderChance > 0 && this.z.a(this.spigotConfig.thunderChance) == 0 && this.r(blockposition = this.b(this.a(j2, 0, k2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
            boolean bl = flag1 = this.ab().b(GameRules.e) && this.z.j() < (double)difficultydamagescaler.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockposition.e()).a(Blocks.ss);
            if (flag1 && (entityhorseskeleton = EntityTypes.aO.a(this)) != null) {
                entityhorseskeleton.x(true);
                entityhorseskeleton.c_(0);
                entityhorseskeleton.a_(blockposition.u(), blockposition.v(), blockposition.w());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.am.a(this)) != null) {
                entitylightning.f(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.b("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int l2 = 0; l2 < randomTickSpeed; ++l2) {
                if (this.z.a(48) != 0) continue;
                this.a(this.a(j2, 0, k2, 15));
            }
        }
        gameprofilerfiller.b("tickBlocks");
        this.timings.chunkTicksBlocks.startTiming();
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        this.timings.chunkTicksBlocks.stopTiming();
        gameprofilerfiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition pos) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        BlockPosition blockposition2 = blockposition1.e();
        BiomeBase biomebase = this.t(blockposition1).a();
        if (biomebase.a(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition2, Blocks.dO.o(), null);
        }
        if (this.ad()) {
            BiomeBase.Precipitation biomebase_precipitation;
            int i2 = this.ab().c(GameRules.T);
            if (i2 > 0 && biomebase.b(this, blockposition1)) {
                IBlockData iblockdata = this.a_(blockposition1);
                if (iblockdata.a(Blocks.dN)) {
                    int j2 = iblockdata.c(BlockSnow.c);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.a(BlockSnow.c, j2 + 1);
                        Block.a(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.dN.o(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.a(blockposition2)) != BiomeBase.Precipitation.a) {
                IBlockData iblockdata2 = this.a_(blockposition2);
                iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, blockposition2, biomebase_precipitation);
            }
        }
    }

    public Optional<BlockPosition> E(BlockPosition pos) {
        Optional<BlockPosition> optional = this.y().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition b(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.E(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(blockposition1, new BlockPosition(blockposition1.h(this.am()))).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bE() && this.h(entityliving.do()) && !entityliving.R_());
        if (!list.isEmpty()) {
            return list.get(this.z.a(list.size())).do();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (blockposition1.v() == this.I_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean c() {
        return this.Z;
    }

    public boolean d() {
        return this.ab().c(GameRules.P) <= 100;
    }

    private void at() {
        if (this.d() && (!this.o().T() || this.o().r())) {
            int i2 = this.ab().c(GameRules.P);
            IChatMutableComponent ichatmutablecomponent = this.P.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.P.b(), this.P.b(i2));
            for (EntityPlayer entityplayer : this.H) {
                entityplayer.a(ichatmutablecomponent, true);
            }
        }
    }

    public void e() {
        if (!this.H.isEmpty() && this.P.a(this.H)) {
            this.at();
        }
    }

    public ScoreboardServer f() {
        return this.J.aK();
    }

    private void au() {
        int idx;
        boolean flag = this.ad();
        if (this.D_().g()) {
            if (this.ab().b(GameRules.v)) {
                int i2 = this.K.f();
                int j2 = this.K.h();
                int k2 = this.K.j();
                boolean flag1 = this.A.g();
                boolean flag2 = this.A.i();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.z) : D.a(this.z);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.z) : b.a(this.z);
                    }
                }
                this.K.b(j2);
                this.K.c(k2);
                this.K.a(i2);
                this.K.setThundering(flag1, ThunderChangeEvent.Cause.NATURAL);
                this.K.setRaining(flag2, WeatherChangeEvent.Cause.NATURAL);
            }
            this.x = this.y;
            this.y = this.A.g() ? (this.y += 0.01f) : (this.y -= 0.01f);
            this.y = MathHelper.a(this.y, 0.0f, 1.0f);
            this.v = this.w;
            this.w = this.A.i() ? (this.w += 0.01f) : (this.w -= 0.01f);
            this.w = MathHelper.a(this.w, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dO() != this) continue;
            this.H.get(idx).tickWeather();
        }
        if (flag != this.ad()) {
            for (idx = 0; idx < this.H.size(); ++idx) {
                if (this.H.get(idx).dO() != this) continue;
                this.H.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.H.size(); ++idx) {
            if (this.H.get(idx).dO() != this) continue;
            this.H.get(idx).updateWeather(this.v, this.w, this.x, this.y);
        }
    }

    @VisibleForTesting
    public void g() {
        this.K.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.K.i()) {
            this.K.c(0);
        }
        this.K.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.K.g()) {
            this.K.b(0);
        }
    }

    public void h() {
        this.Q = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        Fluid fluid1 = this.b_(pos);
        if (fluid1.b(fluid)) {
            fluid1.a(this, pos);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.J.moonrise$executeMidTickTasks();
        }
    }

    private void d(BlockPosition pos, Block block) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.a(block)) {
            iblockdata.a(this, pos, this.z);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.J.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            ++TimingHistory.entityTicks;
            boolean isActive = ActivationRange.checkIfActive(entity);
            Timing timer = isActive ? entity.am().tickTimer.startTiming() : entity.am().inactiveTickTimer.startTiming();
            try {
                entity.bv();
                GameProfilerFiller gameprofilerfiller = this.ag();
                ++entity.ai;
                this.ag().a(() -> BuiltInRegistries.f.b(entity.am()).toString());
                gameprofilerfiller.d("tickNonPassenger");
                if (isActive) {
                    ++TimingHistory.activatedEntityTicks;
                    entity.l();
                    entity.postTick();
                } else {
                    entity.inactiveTick();
                }
                this.ag().c();
            }
            finally {
                timer.stopTiming();
            }
            for (net.minecraft.world.entity.Entity entity1 : entity.cS()) {
                this.a(entity, entity1);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(net.minecraft.world.entity.Entity vehicle, net.minecraft.world.entity.Entity passenger) {
        if (!passenger.dJ() && passenger.dc() == vehicle) {
            if (passenger instanceof EntityHuman || this.M.c(passenger)) {
                boolean isActive = ActivationRange.checkIfActive(passenger);
                Timing timer = isActive ? passenger.am().passengerTickTimer.startTiming() : passenger.am().passengerInactiveTickTimer.startTiming();
                try {
                    passenger.bv();
                    ++passenger.ai;
                    GameProfilerFiller gameprofilerfiller = this.ag();
                    gameprofilerfiller.a(() -> BuiltInRegistries.f.b(passenger.am()).toString());
                    gameprofilerfiller.d("tickPassenger");
                    if (isActive) {
                        passenger.u();
                        passenger.postTick();
                    } else {
                        passenger.i(Vec3D.b);
                        passenger.inactiveTick();
                        vehicle.j(passenger);
                    }
                    gameprofilerfiller.c();
                    for (net.minecraft.world.entity.Entity entity2 : passenger.cS()) {
                        this.a(passenger, entity2);
                    }
                }
                finally {
                    timer.stopTiming();
                }
            }
        } else {
            passenger.ad();
        }
    }

    @Override
    public boolean a(EntityHuman player, BlockPosition pos) {
        return !this.J.a(this, pos, player) && this.C_().a(pos);
    }

    public void saveIncrementally(boolean doFull) {
        ChunkProviderServer chunkproviderserver = this.l();
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        try (Timing ignored = this.timings.worldSave.startTiming();){
            if (doFull) {
                this.saveLevelData(true);
            }
            if (doFull) {
                WorldServer worldserver1 = this;
                this.K.a(worldserver1.C_().t());
                this.K.a(this.J.aN().a(this.H_()));
                this.convertable.a(this.J.bc(), this.K, this.J.ah().r());
            }
        }
    }

    public void a(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled) {
        this.save(progressListener, flush, savingDisabled, false);
    }

    public void save(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled, boolean close) {
        ChunkProviderServer chunkproviderserver = this.l();
        if (!savingDisabled) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            try (Timing ignored = this.timings.worldSave.startTiming();){
                if (progressListener != null) {
                    progressListener.a(IChatBaseComponent.c("menu.savingLevel"));
                }
                this.saveLevelData(!close);
                if (progressListener != null) {
                    progressListener.c(IChatBaseComponent.c("menu.savingChunks"));
                }
                this.timings.worldSaveChunks.startTiming();
                if (!close) {
                    chunkproviderserver.a(flush);
                }
                this.timings.worldSaveChunks.stopTiming();
            }
        }
        if (close) {
            try {
                chunkproviderserver.close(!savingDisabled);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        WorldServer worldserver1 = this;
        this.K.a(worldserver1.C_().t());
        this.K.a(this.J.aN().a(this.H_()));
        this.convertable.a(this.J.bc(), this.K, this.J.ah().r());
    }

    private void saveLevelData(boolean async) {
        if (this.ab != null) {
            this.K.a(this.ab.b());
        }
        this.l().k().save(async);
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(filter, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result) {
        this.a(filter, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result, int limit) {
        this.G().a(filter, (U entity) -> {
            if (predicate.test(entity)) {
                result.add((Object)entity);
                if (result.size() >= limit) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> i() {
        return this.a(EntityTypes.F, EntityLiving::bE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int limit) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.H) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < limit) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer j() {
        List<EntityPlayer> list = this.a(EntityLiving::bE);
        return list.isEmpty() ? null : list.get(this.z.a(list.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.c(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer player) {
        this.c(player);
    }

    public void b(EntityPlayer player) {
        this.c(player);
    }

    private void c(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.G().a(player.cz());
        if (entity != null) {
            E.warn("Force-added player with duplicate UUID {}", (Object)player.cz());
            entity.ak();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.k.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.dJ()) {
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).p().e()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.cU().map(net.minecraft.world.entity.Entity::cz).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.G().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                ((CraftHumanEntity)h2).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.I();
        chunk.b(this);
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int entityId, BlockPosition pos, int progress) {
        Iterator<EntityPlayer> iterator = this.J.ah().t().iterator();
        EntityHuman entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.a(entityId);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        if (entity != null) {
            float progressFloat = (float)MathHelper.a(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.dO() != this || entityplayer.an() == entityId) continue;
            double d0 = (double)pos.u() - entityplayer.dt();
            double d1 = (double)pos.v() - entityplayer.dv();
            double d2 = (double)pos.w() - entityplayer.dz();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.c.b(new PacketPlayOutBlockBreakAnimation(entityId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.J.ah().a(source, x2, y2, z2, sound.a().a(volume), this.af(), new PacketPlayOutNamedSoundEffect(sound, category, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable EntityHuman source, net.minecraft.world.entity.Entity entity, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.J.ah().a(source, entity.dt(), entity.dv(), entity.dz(), sound.a().a(volume), this.af(), new PacketPlayOutEntitySound(sound, category, entity, volume, pitch, seed));
    }

    @Override
    public void b(int eventId, BlockPosition pos, int data) {
        if (this.ab().b(GameRules.W)) {
            this.J.ah().a(new PacketPlayOutWorldEvent(eventId, pos, data, true));
        } else {
            this.a((EntityHuman)null, eventId, pos, data);
        }
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
        this.J.ah().a(player, pos.u(), pos.v(), pos.w(), 64.0, this.af(), new PacketPlayOutWorldEvent(eventId, pos, data, false));
    }

    public int k() {
        return this.D_().p();
    }

    @Override
    public void a(Holder<GameEvent> event, Vec3D emitterPos, GameEvent.a emitter) {
        if (this.getChunkIfLoadedImmediately(MathHelper.a(emitterPos.c) >> 4, MathHelper.a(emitterPos.e) >> 4) == null) {
            return;
        }
        this.O.a(event, emitterPos, emitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        if (this.W) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.l().a(pos);
        this.U.a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(voxelshape = oldState.k(this, pos), voxelshape1 = newState.k(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.V.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(pos, oldState, newState, flags);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.N();
                if (!navigationabstract.b(pos)) continue;
                list.add(navigationabstract);
            }
            try {
                this.W = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.i();
                }
            }
            finally {
                this.W = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock) {
        if (this.captureBlockStates) {
            return;
        }
        this.s.a(pos, sourceBlock, (EnumDirection)null);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction) {
        this.s.a(pos, sourceBlock, direction);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, BlockPosition sourcePos) {
        this.s.a(pos, sourceBlock, sourcePos);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        this.s.a(state, pos, sourceBlock, sourcePos, notify);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte status) {
        this.l().a(entity, new PacketPlayOutEntityStatus(entity, status));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.l().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer l() {
        return this.I;
    }

    @Override
    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, World.a explosionSourceType, ParticleParam particle, ParticleParam emitterParticle, Holder<SoundEffect> soundEvent) {
        Explosion explosion = this.a(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, false, particle, emitterParticle, soundEvent);
        if (explosion.wasCanceled) {
            return explosion;
        }
        if (!explosion.d()) {
            explosion.h();
        }
        for (EntityPlayer entityplayer : this.H) {
            if (!(entityplayer.i(x2, y2, z2) < 4096.0)) continue;
            entityplayer.c.b(new PacketPlayOutExplosion(x2, y2, z2, power, explosion.i(), explosion.e().get(entityplayer), explosion.j(), explosion.k(), explosion.l(), explosion.m()));
        }
        return explosion;
    }

    @Override
    public void a(BlockPosition pos, Block block, int type, int data) {
        this.X.add((Object)new BlockActionData(pos, block, type, data));
    }

    private void aw() {
        this.Y.clear();
        while (!this.X.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.X.removeFirst();
            if (this.n(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.J.ah().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.af(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.Y.add(blockactiondata);
        }
        this.X.addAll(this.Y);
    }

    private boolean a(BlockActionData event) {
        IBlockData iblockdata = this.a_(event.a());
        return iblockdata.a(event.b()) ? iblockdata.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d()) : false;
    }

    public TickListServer<Block> m() {
        return this.S;
    }

    public TickListServer<FluidType> n() {
        return this.T;
    }

    @Override
    @Nonnull
    public MinecraftServer o() {
        return this.J;
    }

    public PortalTravelAgent p() {
        return this.R;
    }

    public StructureTemplateManager q() {
        return this.J.ba();
    }

    public <T extends ParticleParam> int a(T particle, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        return this.sendParticles(null, particle, x2, y2, z2, count, deltaX, deltaY, deltaZ, speed, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        return this.sendParticles(this.H, sender, t0, d0, d1, d2, i2, d3, d4, d5, d6, force);
    }

    public <T extends ParticleParam> int sendParticles(List<EntityPlayer> receivers, @Nullable EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (EntityHuman entityHuman : receivers) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer viewer, T particle, boolean force, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, force, x2, y2, z2, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        return this.a(viewer, force, x2, y2, z2, packet);
    }

    private boolean a(EntityPlayer player, boolean force, double x2, double y2, double z2, Packet<?> packet) {
        if (player.dO() != this) {
            return false;
        }
        BlockPosition blockposition = player.do();
        if (blockposition.a(new Vec3D(x2, y2, z2), force ? 512.0 : 32.0)) {
            player.c.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.G().a(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.G().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.ac.get(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uuid) {
        return this.G().a(uuid);
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipReferencedStructures) {
        if (!this.K.y().c()) {
            return null;
        }
        Optional<HolderSet.Named<Structure>> optional = this.H_().d(Registries.aR).b(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.l().g().a(this, (HolderSet<Structure>)optional.get(), pos, radius, skipReferencedStructures);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition pos, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval) {
        return this.l().g().d().a(pos, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, this.l().i().b(), this);
    }

    @Override
    public CraftingManager r() {
        return this.J.aJ();
    }

    @Override
    public TickRateManager s() {
        return this.J.aQ();
    }

    @Override
    public boolean t() {
        return this.e;
    }

    public WorldPersistentData u() {
        return this.l().k();
    }

    @Override
    @Nullable
    public WorldMap a(MapId id) {
        WorldMap data;
        WorldPersistentData storage = this.o().I().u();
        PersistentBase existing = storage.b.get(id.a());
        if (existing == null && !storage.b.containsKey(id.a())) {
            WorldMap worldmap = this.o().I().u().b(WorldMap.a(), id.a());
            storage.b.put(id.a(), worldmap);
            if (worldmap != null) {
                worldmap.id = id;
                new MapInitializeEvent((MapView)worldmap.mapView).callEvent();
                return worldmap;
            }
        } else if (existing instanceof WorldMap) {
            WorldMap mapItemSavedData = (WorldMap)existing;
            mapItemSavedData.id = id;
        }
        return existing instanceof WorldMap ? (data = (WorldMap)existing) : null;
    }

    @Override
    public void a(MapId id, WorldMap state) {
        state.id = id;
        MapInitializeEvent event = new MapInitializeEvent((MapView)state.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.o().I().u().a(id.a(), state);
    }

    @Override
    public MapId v() {
        return this.o().I().u().a(PersistentIdCounts.a(), "idcounts").b();
    }

    public void a(BlockPosition pos, float angle) {
        int i2;
        BlockPosition blockposition1 = this.A.a();
        float f1 = this.A.b();
        if (!blockposition1.equals(pos) || f1 != angle) {
            Location prevSpawnLoc = this.getWorld().getSpawnLocation();
            this.A.a(pos, angle);
            new SpawnChangeEvent((World)this.getWorld(), prevSpawnLoc).callEvent();
            this.o().ah().a(new PacketPlayOutSpawnPosition(pos, angle));
        }
        if (this.L > 1) {
            this.l().b(TicketType.a, new ChunkCoordIntPair(blockposition1), this.L, Unit.a);
        }
        if ((i2 = this.ab().c(GameRules.Z) + 1) > 1) {
            this.l().a(TicketType.a, new ChunkCoordIntPair(pos), i2, Unit.a);
        }
        this.L = i2;
    }

    public LongSet w() {
        ForcedChunk forcedchunk = this.u().b(ForcedChunk.a(), "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.b()) : LongSets.EMPTY_SET;
    }

    public boolean a(int x2, int z2, boolean forced) {
        boolean flag1;
        ForcedChunk forcedchunk = this.u().a(ForcedChunk.a(), "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(x2, z2);
        long k2 = chunkcoordintpair.a();
        if (forced) {
            flag1 = forcedchunk.b().add(k2);
            if (flag1) {
                this.d(x2, z2);
            }
        } else {
            flag1 = forcedchunk.b().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.l().a(chunkcoordintpair, forced);
        }
        return flag1;
    }

    public List<EntityPlayer> x() {
        return this.H;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(oldBlock);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newBlock))) {
            BlockPosition blockposition1 = pos.j();
            optional.ifPresent(holder -> this.o().execute(() -> {
                this.y().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.o().execute(() -> {
                if (optional.isEmpty() && this.y().a(blockposition1, (Holder<VillagePlaceType> poiType) -> true)) {
                    this.y().a(blockposition1);
                }
                this.y().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace y() {
        return this.l().l();
    }

    public boolean c(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition sectionPos) {
        return this.c(sectionPos.k());
    }

    public boolean a(BlockPosition pos, int maxDistance) {
        return maxDistance > 6 ? false : this.b(SectionPosition.a(pos)) <= maxDistance;
    }

    public int b(SectionPosition pos) {
        return this.y().a(pos);
    }

    public PersistentRaid z() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean e(BlockPosition pos) {
        return this.d(pos) != null;
    }

    public void a(ReputationEvent interaction, net.minecraft.world.entity.Entity entity, ReputationHandler observer) {
        observer.a(interaction, entity);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedwriter3;
        PlayerChunkMap playerchunkmap = this.l().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().b()));
            SpawnerCreature.d spawnercreature_d = this.l().n();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.r.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.m().a()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.n().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.j().c() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.l().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedwriter2 != null) {
            bufferedwriter2.close();
        }
        if ((bufferedwriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            bufferedwriter3.close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.G().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent ichatbasecomponent = entity.aj();
            IChatBaseComponent ichatbasecomponent1 = entity.S_();
            csvwriter.a(entity.dt(), entity.dv(), entity.dz(), entity.cz(), BuiltInRegistries.f.b(entity.am()), entity.bE(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.r) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox box) {
        this.X.removeIf(blockactiondata -> box.b(blockactiondata.a()));
    }

    @Override
    public void b(BlockPosition pos, Block block) {
        if (!this.ai()) {
            if (this.populating) {
                return;
            }
            this.a(pos, block);
        }
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> A() {
        return this.G().a();
    }

    public String toString() {
        return "ServerLevel[" + this.K.e() + "]";
    }

    public boolean B() {
        return this.K.z();
    }

    @Override
    public long C() {
        return this.K.y().b();
    }

    @Nullable
    public EnderDragonBattle D() {
        return this.ab;
    }

    @Override
    public WorldServer E() {
        return this;
    }

    @VisibleForTesting
    public String F() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.H.size(), this.moonrise$getEntityLookup().getDebugInfo(), WorldServer.a(this.moonrise$getEntityLookup().a(), (T entity) -> BuiltInRegistries.f.b(entity.am()).toString()), this.r.size(), WorldServer.a(this.r, TickingBlockEntity::d), this.m().a(), this.n().a(), this.I());
    }

    private static <T> String a(Iterable<T> items, Function<T, String> classifier) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : items) {
                String s2 = classifier.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> G() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Chunk chunk) {
        chunk.c(this.A_().c());
    }

    public void a(IChunkAccess chunk) {
        this.J.execute(() -> this.ae.a(chunk.f(), chunk.g()));
    }

    public PathTypeCache H() {
        return this.U;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String I() {
        String s2 = this.I.e();
        return "Chunks[S] W: " + s2 + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    private boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean f(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean g(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Override
    public FeatureFlagSet J() {
        return this.J.bb().K();
    }

    @Override
    public PotionBrewer K() {
        return this.J.bp();
    }

    public RandomSource a(MinecraftKey id) {
        return this.ag.a(id);
    }

    public RandomSequences L() {
        return this.ag;
    }

    @Override
    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashreportsystemdetails = super.a(report);
        crashreportsystemdetails.a("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashreportsystemdetails;
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.J.ah().a(uuid);
    }

    private final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.f().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.M.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.M.b(entity);
            if (WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.c = null;
                ((IProjectile)pearl).b = null;
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.add(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.V.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gg()) {
                    WorldServer.this.ac.put(entitycomplexpart.an(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
            WorldServer.this.l().b(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)WorldServer.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.o().K()).map(WorldServer::u).forEach(worldData -> {
                    for (PersistentBase o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)o2;
                        map.p.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.o.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            map.r.remove(entity.ah().getString());
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dK() != Entity.RemovalReason.a)) {
                Object merchant;
                CraftEntity craftEntity = entity.getBukkitEntity();
                if (craftEntity instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.l().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.H.remove(entityplayer);
                WorldServer.this.e();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.V.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.gg()) {
                    WorldServer.this.ac.remove(entitycomplexpart.an());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.H) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

