/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class PathPackResources
extends ResourcePackAbstract {
    private static final Logger c = LogUtils.getLogger();
    private static final Joiner d = Joiner.on((String)"/");
    private final Path e;

    public PathPackResources(PackLocationInfo info, Path root) {
        super(info);
        this.e = root;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(String ... segments) {
        FileUtils.a(segments);
        Path path = FileUtils.a(this.e, List.of(segments));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create(path) : null;
    }

    public static boolean a(Path path) {
        return true;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> a(EnumResourcePackType type, MinecraftKey id) {
        Path path = this.e.resolve(type.a()).resolve(id.b());
        return PathPackResources.a(id, path);
    }

    @Nullable
    public static IoSupplier<InputStream> a(MinecraftKey id, Path path) {
        return (IoSupplier)FileUtils.d(id.a()).mapOrElse(segments -> {
            Path path2 = FileUtils.a(path, segments);
            return PathPackResources.b(path2);
        }, error -> {
            c.error("Invalid path {}: {}", (Object)id, (Object)error.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> b(Path path) {
        return Files.exists(path, new LinkOption[0]) && PathPackResources.a(path) ? IoSupplier.create(path) : null;
    }

    @Override
    public void a(EnumResourcePackType type, String namespace, String prefix, IResourcePack.a consumer) {
        FileUtils.d(prefix).ifSuccess(prefixSegments -> {
            Path path = this.e.resolve(type.a()).resolve(namespace);
            PathPackResources.a(namespace, path, prefixSegments, consumer);
        }).ifError(error -> c.error("Invalid path {}: {}", (Object)prefix, (Object)error.message()));
    }

    public static void a(String namespace, Path path, List<String> prefixSegments, IResourcePack.a consumer) {
        Path path2 = FileUtils.a(path, prefixSegments);
        try (Stream<Path> stream2 = Files.find(path2, Integer.MAX_VALUE, (path2x, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            stream2.forEach(foundPath -> {
                String string2 = d.join((Iterable)path.relativize((Path)foundPath));
                MinecraftKey resourceLocation = MinecraftKey.b(namespace, string2);
                if (resourceLocation == null) {
                    SystemUtils.b(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", namespace, string2));
                } else {
                    consumer.accept(resourceLocation, IoSupplier.create(foundPath));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException stream2) {
        }
        catch (IOException var11) {
            c.error("Failed to list path {}", (Object)path2, (Object)var11);
        }
    }

    @Override
    public Set<String> a(EnumResourcePackType type) {
        HashSet set = Sets.newHashSet();
        Path path = this.e.resolve(type.a());
        try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream2) {
                String string = path2.getFileName().toString();
                if (!Files.isDirectory(path2, new LinkOption[0])) {
                    c.error("Invalid directory entry: {} in {}.", new Object[]{string, this.e, new NotDirectoryException(string)});
                    continue;
                }
                if (MinecraftKey.j(string)) {
                    set.add(string);
                    continue;
                }
                c.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string, (Object)this.e);
            }
        }
        catch (NoSuchFileException | NotDirectoryException directoryStream2) {
        }
        catch (IOException var11) {
            c.error("Failed to list path {}", (Object)path, (Object)var11);
        }
        return set;
    }

    @Override
    public void close() {
    }

    public static class a
    implements ResourcePackLoader.c {
        private final Path a;

        public a(Path path) {
            this.a = path;
        }

        @Override
        public IResourcePack a(PackLocationInfo info) {
            return new PathPackResources(info, this.a);
        }

        @Override
        public IResourcePack a(PackLocationInfo info, ResourcePackLoader.a metadata) {
            IResourcePack packResources = this.a(info);
            List<String> list = metadata.d();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<IResourcePack> list2 = new ArrayList<IResourcePack>(list.size());
            for (String string : list) {
                Path path = this.a.resolve(string);
                list2.add(new PathPackResources(info, path));
            }
            return new CompositePackResources(packResources, list2);
        }
    }
}

