/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ResourcePackFile
extends ResourcePackAbstract {
    static final Logger c = LogUtils.getLogger();
    private final b d;
    private final String e;

    ResourcePackFile(PackLocationInfo info, b zipFile, String overlay) {
        super(info);
        this.d = zipFile;
        this.e = overlay;
    }

    private static String b(EnumResourcePackType type, MinecraftKey id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.a(), id.b(), id.a());
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(String ... segments) {
        return this.b(String.join((CharSequence)"/", segments));
    }

    @Override
    @Override
    public IoSupplier<InputStream> a(EnumResourcePackType type, MinecraftKey id) {
        return this.b(ResourcePackFile.b(type, id));
    }

    private String a(String path) {
        if (this.e.isEmpty()) {
            return path;
        }
        return this.e + "/" + path;
    }

    @Nullable
    private IoSupplier<InputStream> b(String path) {
        ZipFile zipFile = this.d.a();
        if (zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(this.a(path));
        if (zipEntry == null) {
            return null;
        }
        return IoSupplier.create(zipFile, zipEntry);
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        ZipFile zipFile = this.d.a();
        if (zipFile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet set = Sets.newHashSet();
        String string = this.a(type.a() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            String string3 = ResourcePackFile.a(string, string2);
            if (string3.isEmpty()) continue;
            if (MinecraftKey.j(string3)) {
                set.add(string3);
                continue;
            }
            c.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string3, (Object)this.d.a);
        }
        return set;
    }

    @VisibleForTesting
    public static String a(String prefix, String entryName) {
        if (!entryName.startsWith(prefix)) {
            return "";
        }
        int i2 = prefix.length();
        int j2 = entryName.indexOf(47, i2);
        if (j2 == -1) {
            return entryName.substring(i2);
        }
        return entryName.substring(i2, j2);
    }

    @Override
    @Override
    public void close() {
        this.d.close();
    }

    @Override
    @Override
    public void a(EnumResourcePackType type, String namespace, String prefix, IResourcePack.a consumer) {
        ZipFile zipFile = this.d.a();
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String string = this.a(type.a() + "/" + namespace + "/");
        String string2 = string + prefix + "/";
        while (enumeration.hasMoreElements()) {
            String string3;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).startsWith(string2)) continue;
            String string4 = string3.substring(string.length());
            MinecraftKey resourceLocation = MinecraftKey.b(namespace, string4);
            if (resourceLocation != null) {
                consumer.accept(resourceLocation, IoSupplier.create(zipFile, zipEntry));
                continue;
            }
            c.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)string4);
        }
    }

    static class b
    implements AutoCloseable {
        final File a;
        @Nullable
        private ZipFile b;
        private boolean c;

        b(File file) {
            this.a = file;
        }

        @Nullable
        ZipFile a() {
            if (this.c) {
                return null;
            }
            if (this.b == null) {
                try {
                    this.b = new ZipFile(this.a);
                }
                catch (IOException iOException) {
                    c.error("Failed to open pack {}", (Object)this.a, (Object)iOException);
                    this.c = true;
                    return null;
                }
            }
            return this.b;
        }

        @Override
        @Override
        public void close() {
            if (this.b != null) {
                IOUtils.closeQuietly((Closeable)this.b);
                this.b = null;
            }
        }

        @Override
        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class a
    implements ResourcePackLoader.c {
        private final File a;

        public a(Path path) {
            this(path.toFile());
        }

        public a(File file) {
            this.a = file;
        }

        @Override
        @Override
        public IResourcePack a(PackLocationInfo info) {
            b sharedZipFileAccess = new b(this.a);
            return new ResourcePackFile(info, sharedZipFileAccess, "");
        }

        @Override
        @Override
        public IResourcePack a(PackLocationInfo info, ResourcePackLoader.a metadata) {
            b sharedZipFileAccess = new b(this.a);
            ResourcePackFile packResources = new ResourcePackFile(info, sharedZipFileAccess, "");
            List<String> list = metadata.d();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<IResourcePack> list2 = new ArrayList<IResourcePack>(list.size());
            for (String string : list) {
                list2.add(new ResourcePackFile(info, sharedZipFileAccess, string));
            }
            return new CompositePackResources(packResources, list2);
        }
    }
}

