/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class ChunkHeightAndBiomeFix
extends DataFix {
    public static final String a = "__context";
    private static final String d = "ChunkHeightAndBiomeFix";
    private static final int e = 16;
    private static final int f = 24;
    private static final int g = -4;
    public static final int b = 4096;
    private static final int h = 64;
    private static final int i = 9;
    private static final long j = 511L;
    private static final int k = 64;
    private static final String[] l = new String[]{"WORLD_SURFACE_WG", "WORLD_SURFACE", "WORLD_SURFACE_IGNORE_SNOW", "OCEAN_FLOOR_WG", "OCEAN_FLOOR", "MOTION_BLOCKING", "MOTION_BLOCKING_NO_LEAVES"};
    private static final Set<String> m = Set.of("surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> n = Set.of("noise", "surface", "carvers", "liquid_carvers", "features", "light", "spawn", "heightmaps", "full");
    private static final Set<String> o = Set.of("minecraft:air", "minecraft:basalt", "minecraft:bedrock", "minecraft:blackstone", "minecraft:calcite", "minecraft:cave_air", "minecraft:coarse_dirt", "minecraft:crimson_nylium", "minecraft:dirt", "minecraft:end_stone", "minecraft:grass_block", "minecraft:gravel", "minecraft:ice", "minecraft:lava", "minecraft:mycelium", "minecraft:nether_wart_block", "minecraft:netherrack", "minecraft:orange_terracotta", "minecraft:packed_ice", "minecraft:podzol", "minecraft:powder_snow", "minecraft:red_sand", "minecraft:red_sandstone", "minecraft:sand", "minecraft:sandstone", "minecraft:snow_block", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:stone", "minecraft:terracotta", "minecraft:warped_nylium", "minecraft:warped_wart_block", "minecraft:water", "minecraft:white_terracotta");
    private static final int p = 16;
    private static final int q = 64;
    private static final int r = 1008;
    public static final String c = "minecraft:plains";
    private static final Int2ObjectMap<String> s = new Int2ObjectOpenHashMap();

    public ChunkHeightAndBiomeFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder2 = opticFinder.type().findField("Sections");
        Schema schema = this.getOutputSchema();
        Type type2 = schema.getType(DataConverterTypes.c);
        Type type3 = type2.findField("Level").type();
        Type type4 = type3.findField("Sections").type();
        return this.fixTypeEverywhereTyped(d, type, type2, chunk -> chunk.updateTyped(opticFinder, type3, level -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)level.get(DSL.remainderFinder()))));
            OptionalDynamic optionalDynamic = ((Dynamic)((Object)((Object)((Object)chunk.get(DSL.remainderFinder()))))).get(a);
            String string = optionalDynamic.get("dimension").asString().result().orElse("");
            String string2 = optionalDynamic.get("generator").asString().result().orElse("");
            boolean bl = "minecraft:overworld".equals(string);
            MutableBoolean mutableBoolean = new MutableBoolean();
            int i2 = bl ? -4 : 0;
            Dynamic[] dynamics = ChunkHeightAndBiomeFix.a(dynamic, bl, i2, mutableBoolean);
            Dynamic<?> dynamic2 = ChunkHeightAndBiomeFix.d(dynamic.createList(Stream.of(dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air")))))));
            HashSet set = Sets.newHashSet();
            MutableObject mutableObject = new MutableObject(() -> null);
            level = level.updateTyped(opticFinder2, type4, sections -> {
                IntOpenHashSet intSet = new IntOpenHashSet();
                Dynamic dynamic3 = (Dynamic)((Object)((Object)((Object)((Object)sections.write().result().orElseThrow(() -> new IllegalStateException("Malformed Chunk.Level.Sections"))))));
                List list = dynamic3.asStream().map(arg_0 -> ChunkHeightAndBiomeFix.a(set, dynamic2, i2, dynamics, (IntSet)intSet, mutableObject, arg_0)).collect(Collectors.toCollection(ArrayList::new));
                for (int j2 = 0; j2 < dynamics.length; ++j2) {
                    int k2 = j2 + i2;
                    if (!intSet.add(k2)) continue;
                    Dynamic dynamic4 = dynamic.createMap(Map.of(dynamic.createString("Y"), dynamic.createInt(k2)));
                    dynamic4 = dynamic4.set("block_states", dynamic2);
                    dynamic4 = dynamic4.set("biomes", dynamics[j2]);
                    list.add(dynamic4);
                }
                return SystemUtils.a(type4, dynamic.createList(list.stream()));
            });
            return level.update(DSL.remainderFinder(), level2 -> {
                if (bl) {
                    level2 = this.a((Dynamic<?>)((Object)((Object)((Object)level2))), set);
                }
                return ChunkHeightAndBiomeFix.a(level2, bl, mutableBoolean.booleanValue(), "minecraft:noise".equals(string2), (Supplier)mutableObject.getValue());
            });
        }));
    }

    private Dynamic<?> a(Dynamic<?> level, Set<String> blocks) {
        return level.update("Status", status -> {
            boolean bl2;
            String string = status.asString("empty");
            if (m.contains(string)) {
                return status;
            }
            blocks.remove("minecraft:air");
            boolean bl = !blocks.isEmpty();
            blocks.removeAll(o);
            boolean bl3 = bl2 = !blocks.isEmpty();
            if (bl2) {
                return status.createString("liquid_carvers");
            }
            if ("noise".equals(string) || bl) {
                return status.createString("noise");
            }
            if ("biomes".equals(string)) {
                return status.createString("structure_references");
            }
            return status;
        });
    }

    private static Dynamic<?>[] a(Dynamic<?> level, boolean overworld, int i2, MutableBoolean heightAlreadyUpdated) {
        Dynamic[] dynamics = new Dynamic[overworld ? 24 : 16];
        int[] is = level.get("Biomes").asIntStreamOpt().result().map(IntStream::toArray).orElse(null);
        if (is != null && is.length == 1536) {
            heightAlreadyUpdated.setValue(true);
            for (int j2 = 0; j2 < 24; ++j2) {
                int k2 = j2;
                dynamics[j2] = ChunkHeightAndBiomeFix.a(level, sectionY -> ChunkHeightAndBiomeFix.a(is, k2 * 64 + sectionY));
            }
        } else if (is != null && is.length == 1024) {
            int l2 = 0;
            while (l2 < 16) {
                int m2 = l2 - i2;
                int n2 = l2++;
                dynamics[m2] = ChunkHeightAndBiomeFix.a(level, sectionY -> ChunkHeightAndBiomeFix.a(is, n2 * 64 + sectionY));
            }
            if (overworld) {
                Dynamic<?> dynamic = ChunkHeightAndBiomeFix.a(level, sectionY -> ChunkHeightAndBiomeFix.a(is, sectionY % 16));
                Dynamic<?> dynamic2 = ChunkHeightAndBiomeFix.a(level, sectionY -> ChunkHeightAndBiomeFix.a(is, sectionY % 16 + 1008));
                for (int o2 = 0; o2 < 4; ++o2) {
                    dynamics[o2] = dynamic;
                }
                for (int p2 = 20; p2 < 24; ++p2) {
                    dynamics[p2] = dynamic2;
                }
            }
        } else {
            Arrays.fill((Object[])dynamics, ChunkHeightAndBiomeFix.d(level.createList(Stream.of(level.createString(c)))));
        }
        return dynamics;
    }

    private static int a(int[] is, int index) {
        return is[index] & 0xFF;
    }

    private static Dynamic<?> a(Dynamic<?> level, boolean overworld, boolean heightAlreadyUpdated, boolean atNoiseStatus, Supplier<ChunkProtoTickListFix.a> supplier) {
        Dynamic dynamic;
        String string;
        level = level.remove("Biomes");
        if (!overworld) {
            return ChunkHeightAndBiomeFix.a(level, 16, 0);
        }
        if (heightAlreadyUpdated) {
            return ChunkHeightAndBiomeFix.a(level, 24, 0);
        }
        level = ChunkHeightAndBiomeFix.b(level);
        level = ChunkHeightAndBiomeFix.a(level, "LiquidsToBeTicked");
        level = ChunkHeightAndBiomeFix.a(level, "PostProcessing");
        level = ChunkHeightAndBiomeFix.a(level, "ToBeTicked");
        level = ChunkHeightAndBiomeFix.a(level, 24, 4);
        level = level.update("UpgradeData", ChunkHeightAndBiomeFix::a);
        if (!atNoiseStatus) {
            return level;
        }
        Optional optional = level.get("Status").result();
        if (optional.isPresent() && !"empty".equals(string = (dynamic = (Dynamic)((Object)optional.get())).asString(""))) {
            level = level.set("blending_data", level.createMap((Map)ImmutableMap.of((Object)((Object)level.createString("old_noise")), (Object)((Object)level.createBoolean(n.contains(string))))));
            ChunkProtoTickListFix.a poorMansPalettedContainer = supplier.get();
            if (poorMansPalettedContainer != null) {
                BitSet bitSet = new BitSet(256);
                boolean bl = string.equals("noise");
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int j2 = 0; j2 < 16; ++j2) {
                        boolean bl3;
                        Dynamic<?> dynamic2 = poorMansPalettedContainer.a(j2, 0, i2);
                        boolean bl2 = dynamic2 != null && "minecraft:bedrock".equals(dynamic2.get("Name").asString(""));
                        boolean bl4 = bl3 = dynamic2 != null && "minecraft:air".equals(dynamic2.get("Name").asString(""));
                        if (bl3) {
                            bitSet.set(i2 * 16 + j2);
                        }
                        bl |= bl2;
                    }
                }
                if (bl && bitSet.cardinality() != bitSet.size()) {
                    Dynamic dynamic3 = "full".equals(string) ? level.createString("heightmaps") : dynamic;
                    level = level.set("below_zero_retrogen", level.createMap((Map)ImmutableMap.of((Object)((Object)level.createString("target_status")), (Object)((Object)dynamic3), (Object)((Object)level.createString("missing_bedrock")), (Object)((Object)level.createLongList(LongStream.of(bitSet.toLongArray()))))));
                    level = level.set("Status", level.createString("empty"));
                }
                level = level.set("isLightOn", level.createBoolean(false));
            }
        }
        return level;
    }

    private static <T> Dynamic<T> a(Dynamic<T> upgradeData) {
        return upgradeData.update("Indices", indices -> {
            HashMap map = new HashMap();
            indices.getMapValues().ifSuccess(indicesMap -> indicesMap.forEach((key, value) -> {
                try {
                    key.asString().result().map(Integer::parseInt).ifPresent(index -> {
                        int i2 = index - -4;
                        map.put(key.createString(Integer.toString(i2)), value);
                    });
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }));
            return indices.createMap(map);
        });
    }

    private static Dynamic<?> a(Dynamic<?> level, int sectionsPerChunk, int oldBottomSectionY) {
        Dynamic dynamic = level.get("CarvingMasks").orElseEmptyMap();
        dynamic = dynamic.updateMapValues(mask -> {
            long[] ls = BitSet.valueOf(((Dynamic)((Object)((Object)mask.getSecond()))).asByteBuffer().array()).toLongArray();
            long[] ms = new long[64 * sectionsPerChunk];
            System.arraycopy(ls, 0, ms, 64 * oldBottomSectionY, ls.length);
            return Pair.of((Object)((Object)((Dynamic)((Object)((Object)mask.getFirst())))), (Object)((Object)level.createLongList(LongStream.of(ms))));
        });
        return level.set("CarvingMasks", dynamic);
    }

    private static Dynamic<?> a(Dynamic<?> level, String key) {
        List list = level.get(key).orElseEmptyList().asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 24) {
            return level;
        }
        Dynamic dynamic = level.emptyList();
        for (int i2 = 0; i2 < 4; ++i2) {
            list.add(0, dynamic);
            list.add(dynamic);
        }
        return level.set(key, level.createList(list.stream()));
    }

    private static Dynamic<?> b(Dynamic<?> level) {
        return level.update("Heightmaps", heightmaps -> {
            for (String string : l) {
                heightmaps = heightmaps.update(string, ChunkHeightAndBiomeFix::c);
            }
            return heightmaps;
        });
    }

    private static Dynamic<?> c(Dynamic<?> heightmap) {
        return heightmap.createLongList(heightmap.asLongStream().map(entry -> {
            long l2 = 0L;
            int i2 = 0;
            while (i2 + 9 <= 64) {
                long o2;
                long m2 = entry >> i2 & 0x1FFL;
                if (m2 == 0L) {
                    long n2 = 0L;
                } else {
                    o2 = Math.min(m2 + 64L, 511L);
                }
                l2 |= o2 << i2;
                i2 += 9;
            }
            return l2;
        }));
    }

    private static Dynamic<?> a(Dynamic<?> level, Int2IntFunction biomeGetter) {
        Int2IntLinkedOpenHashMap int2IntMap = new Int2IntLinkedOpenHashMap();
        for (int i2 = 0; i2 < 64; ++i2) {
            int j2 = biomeGetter.applyAsInt(i2);
            if (int2IntMap.containsKey(j2)) continue;
            int2IntMap.put(j2, int2IntMap.size());
        }
        Dynamic dynamic = level.createList(int2IntMap.keySet().stream().map(rawBiomeId -> level.createString((String)s.getOrDefault(rawBiomeId.intValue(), (Object)c))));
        int k2 = ChunkHeightAndBiomeFix.a(int2IntMap.size());
        if (k2 == 0) {
            return ChunkHeightAndBiomeFix.d(dynamic);
        }
        int l2 = 64 / k2;
        int m2 = (64 + l2 - 1) / l2;
        long[] ls = new long[m2];
        int n2 = 0;
        int o2 = 0;
        for (int p2 = 0; p2 < 64; ++p2) {
            int q2 = biomeGetter.applyAsInt(p2);
            int n3 = n2++;
            ls[n3] = ls[n3] | (long)int2IntMap.get(q2) << o2;
            if ((o2 += k2) + k2 <= 64) continue;
            o2 = 0;
        }
        Dynamic dynamic2 = level.createLongList(Arrays.stream(ls));
        return ChunkHeightAndBiomeFix.a(dynamic, dynamic2);
    }

    private static Dynamic<?> d(Dynamic<?> palette) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette));
    }

    private static Dynamic<?> a(Dynamic<?> palette, Dynamic<?> data) {
        return palette.createMap((Map)ImmutableMap.of((Object)((Object)palette.createString("palette")), palette, (Object)((Object)palette.createString("data")), data));
    }

    private static Dynamic<?> b(Dynamic<?> dynamic, Dynamic<?> dynamic2) {
        List list = dynamic.asStream().collect(Collectors.toCollection(ArrayList::new));
        if (list.size() == 1) {
            return ChunkHeightAndBiomeFix.d(dynamic);
        }
        dynamic = ChunkHeightAndBiomeFix.a(dynamic, dynamic2, list);
        return ChunkHeightAndBiomeFix.a(dynamic, dynamic2);
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, Dynamic<?> dynamic2, List<Dynamic<?>> list) {
        int i2;
        int j2;
        long l2 = dynamic2.asLongStream().count() * 64L;
        long m2 = l2 / 4096L;
        if (m2 > (long)(j2 = ChunkHeightAndBiomeFix.a(i2 = list.size()))) {
            Dynamic dynamic3 = dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Name")), (Object)((Object)dynamic.createString("minecraft:air"))));
            int k2 = (1 << (int)(m2 - 1L)) + 1;
            int n2 = k2 - i2;
            for (int o2 = 0; o2 < n2; ++o2) {
                list.add(dynamic3);
            }
            return dynamic.createList(list.stream());
        }
        return dynamic;
    }

    public static int a(int value) {
        if (value == 0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(value) / Math.log(2.0));
    }

    private static /* synthetic */ Dynamic a(Set set, Dynamic dynamic, int i2, Dynamic[] dynamics, IntSet intSet, MutableObject mutableObject, Dynamic dynamic2) {
        int j2 = dynamic2.get("Y").asInt(0);
        Dynamic dynamic3 = (Dynamic)((Object)DataFixUtils.orElse(dynamic2.get("Palette").result().flatMap(dynamic22 -> {
            dynamic22.asStream().map(dynamic -> dynamic.get("Name").asString("minecraft:air")).forEach(set::add);
            return dynamic2.get("BlockStates").result().map(dynamic2 -> ChunkHeightAndBiomeFix.b(dynamic22, dynamic2));
        }), (Object)((Object)dynamic)));
        Dynamic dynamic4 = dynamic2;
        int k2 = j2 - i2;
        if (k2 >= 0 && k2 < dynamics.length) {
            dynamic4 = dynamic4.set("biomes", dynamics[k2]);
        }
        intSet.add(j2);
        if (dynamic2.get("Y").asInt(Integer.MAX_VALUE) == 0) {
            mutableObject.setValue(() -> {
                List list = dynamic3.get("palette").asList(Function.identity());
                long[] ls = dynamic3.get("data").asLongStream().toArray();
                return new ChunkProtoTickListFix.a(list, ls);
            });
        }
        return dynamic4.set("block_states", dynamic3).remove("Palette").remove("BlockStates");
    }

    static {
        s.put(0, (Object)"minecraft:ocean");
        s.put(1, (Object)c);
        s.put(2, (Object)"minecraft:desert");
        s.put(3, (Object)"minecraft:mountains");
        s.put(4, (Object)"minecraft:forest");
        s.put(5, (Object)"minecraft:taiga");
        s.put(6, (Object)"minecraft:swamp");
        s.put(7, (Object)"minecraft:river");
        s.put(8, (Object)"minecraft:nether_wastes");
        s.put(9, (Object)"minecraft:the_end");
        s.put(10, (Object)"minecraft:frozen_ocean");
        s.put(11, (Object)"minecraft:frozen_river");
        s.put(12, (Object)"minecraft:snowy_tundra");
        s.put(13, (Object)"minecraft:snowy_mountains");
        s.put(14, (Object)"minecraft:mushroom_fields");
        s.put(15, (Object)"minecraft:mushroom_field_shore");
        s.put(16, (Object)"minecraft:beach");
        s.put(17, (Object)"minecraft:desert_hills");
        s.put(18, (Object)"minecraft:wooded_hills");
        s.put(19, (Object)"minecraft:taiga_hills");
        s.put(20, (Object)"minecraft:mountain_edge");
        s.put(21, (Object)"minecraft:jungle");
        s.put(22, (Object)"minecraft:jungle_hills");
        s.put(23, (Object)"minecraft:jungle_edge");
        s.put(24, (Object)"minecraft:deep_ocean");
        s.put(25, (Object)"minecraft:stone_shore");
        s.put(26, (Object)"minecraft:snowy_beach");
        s.put(27, (Object)"minecraft:birch_forest");
        s.put(28, (Object)"minecraft:birch_forest_hills");
        s.put(29, (Object)"minecraft:dark_forest");
        s.put(30, (Object)"minecraft:snowy_taiga");
        s.put(31, (Object)"minecraft:snowy_taiga_hills");
        s.put(32, (Object)"minecraft:giant_tree_taiga");
        s.put(33, (Object)"minecraft:giant_tree_taiga_hills");
        s.put(34, (Object)"minecraft:wooded_mountains");
        s.put(35, (Object)"minecraft:savanna");
        s.put(36, (Object)"minecraft:savanna_plateau");
        s.put(37, (Object)"minecraft:badlands");
        s.put(38, (Object)"minecraft:wooded_badlands_plateau");
        s.put(39, (Object)"minecraft:badlands_plateau");
        s.put(40, (Object)"minecraft:small_end_islands");
        s.put(41, (Object)"minecraft:end_midlands");
        s.put(42, (Object)"minecraft:end_highlands");
        s.put(43, (Object)"minecraft:end_barrens");
        s.put(44, (Object)"minecraft:warm_ocean");
        s.put(45, (Object)"minecraft:lukewarm_ocean");
        s.put(46, (Object)"minecraft:cold_ocean");
        s.put(47, (Object)"minecraft:deep_warm_ocean");
        s.put(48, (Object)"minecraft:deep_lukewarm_ocean");
        s.put(49, (Object)"minecraft:deep_cold_ocean");
        s.put(50, (Object)"minecraft:deep_frozen_ocean");
        s.put(127, (Object)"minecraft:the_void");
        s.put(129, (Object)"minecraft:sunflower_plains");
        s.put(130, (Object)"minecraft:desert_lakes");
        s.put(131, (Object)"minecraft:gravelly_mountains");
        s.put(132, (Object)"minecraft:flower_forest");
        s.put(133, (Object)"minecraft:taiga_mountains");
        s.put(134, (Object)"minecraft:swamp_hills");
        s.put(140, (Object)"minecraft:ice_spikes");
        s.put(149, (Object)"minecraft:modified_jungle");
        s.put(151, (Object)"minecraft:modified_jungle_edge");
        s.put(155, (Object)"minecraft:tall_birch_forest");
        s.put(156, (Object)"minecraft:tall_birch_hills");
        s.put(157, (Object)"minecraft:dark_forest_hills");
        s.put(158, (Object)"minecraft:snowy_taiga_mountains");
        s.put(160, (Object)"minecraft:giant_spruce_taiga");
        s.put(161, (Object)"minecraft:giant_spruce_taiga_hills");
        s.put(162, (Object)"minecraft:modified_gravelly_mountains");
        s.put(163, (Object)"minecraft:shattered_savanna");
        s.put(164, (Object)"minecraft:shattered_savanna_plateau");
        s.put(165, (Object)"minecraft:eroded_badlands");
        s.put(166, (Object)"minecraft:modified_wooded_badlands_plateau");
        s.put(167, (Object)"minecraft:modified_badlands_plateau");
        s.put(168, (Object)"minecraft:bamboo_jungle");
        s.put(169, (Object)"minecraft:bamboo_jungle_hills");
        s.put(170, (Object)"minecraft:soul_sand_valley");
        s.put(171, (Object)"minecraft:crimson_forest");
        s.put(172, (Object)"minecraft:warped_forest");
        s.put(173, (Object)"minecraft:basalt_deltas");
        s.put(174, (Object)"minecraft:dripstone_caves");
        s.put(175, (Object)"minecraft:lush_caves");
        s.put(177, (Object)"minecraft:meadow");
        s.put(178, (Object)"minecraft:grove");
        s.put(179, (Object)"minecraft:snowy_slopes");
        s.put(180, (Object)"minecraft:snowcapped_peaks");
        s.put(181, (Object)"minecraft:lofty_peaks");
        s.put(182, (Object)"minecraft:stony_peaks");
    }
}

