/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class ChunkRenamesFix
extends DataFix {
    public ChunkRenamesFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder2 = opticFinder.type().findField("Structures");
        Type type2 = this.getOutputSchema().getType(DataConverterTypes.c);
        Type type3 = type2.findFieldType("structures");
        return this.fixTypeEverywhereTyped("Chunk Renames; purge Level-tag", type, type2, chunkTyped -> {
            Typed typed = chunkTyped.getTyped(opticFinder);
            Typed<?> typed2 = ChunkRenamesFix.a(typed);
            typed2 = typed2.set(DSL.remainderFinder(), ChunkRenamesFix.a(chunkTyped, (Dynamic)((Object)((Object)typed.get(DSL.remainderFinder())))));
            typed2 = ChunkRenamesFix.a(typed2, "TileEntities", "block_entities");
            typed2 = ChunkRenamesFix.a(typed2, "TileTicks", "block_ticks");
            typed2 = ChunkRenamesFix.a(typed2, "Entities", "entities");
            typed2 = ChunkRenamesFix.a(typed2, "Sections", "sections");
            typed2 = typed2.updateTyped(opticFinder2, type3, structuresTyped -> ChunkRenamesFix.a(structuresTyped, "Starts", "starts"));
            typed2 = ChunkRenamesFix.a(typed2, "Structures", "structures");
            return typed2.update(DSL.remainderFinder(), dynamic -> dynamic.remove("Level"));
        });
    }

    private static Typed<?> a(Typed<?> typed, String oldKey, String newKey) {
        return ChunkRenamesFix.a(typed, oldKey, newKey, typed.getType().findFieldType(oldKey)).update(DSL.remainderFinder(), dynamic -> dynamic.remove(oldKey));
    }

    private static <A> Typed<?> a(Typed<?> typed, String oldKey, String newKey, Type<A> type) {
        Type type2 = DSL.optional((Type)DSL.field((String)oldKey, type));
        Type type3 = DSL.optional((Type)DSL.field((String)newKey, type));
        return typed.update(type2.finder(), type3, Function.identity());
    }

    private static <A> Typed<Pair<String, A>> a(Typed<A> outputTyped) {
        return new Typed(DSL.named((String)"chunk", (Type)outputTyped.getType()), outputTyped.getOps(), (Object)Pair.of((Object)"chunk", (Object)outputTyped.getValue()));
    }

    private static <T> Dynamic<T> a(Typed<?> chunkTyped, Dynamic<T> chunkDynamic) {
        DynamicOps dynamicOps = chunkDynamic.getOps();
        Dynamic dynamic = ((Dynamic)((Object)chunkTyped.get(DSL.remainderFinder()))).convert(dynamicOps);
        DataResult dataResult = dynamicOps.getMap(chunkDynamic.getValue()).flatMap(mapLike -> dynamicOps.mergeToMap(dynamic.getValue(), mapLike));
        return dataResult.result().map(object -> new Dynamic<Object>(dynamicOps, object)).orElse(chunkDynamic);
    }
}

