/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterHanging
extends DataFix {
    private static final int[][] a = new int[][]{{0, 0, 1}, {-1, 0, 0}, {0, 0, -1}, {1, 0, 0}};

    public DataConverterHanging(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private Dynamic<?> a(Dynamic<?> entityDynamic, boolean isPainting, boolean isItemFrame) {
        if ((isPainting || isItemFrame) && entityDynamic.get("Facing").asNumber().result().isEmpty()) {
            int j2;
            if (entityDynamic.get("Direction").asNumber().result().isPresent()) {
                int i2 = entityDynamic.get("Direction").asByte((byte)0) % a.length;
                int[] is = a[i2];
                entityDynamic = entityDynamic.set("TileX", entityDynamic.createInt(entityDynamic.get("TileX").asInt(0) + is[0]));
                entityDynamic = entityDynamic.set("TileY", entityDynamic.createInt(entityDynamic.get("TileY").asInt(0) + is[1]));
                entityDynamic = entityDynamic.set("TileZ", entityDynamic.createInt(entityDynamic.get("TileZ").asInt(0) + is[2]));
                entityDynamic = entityDynamic.remove("Direction");
                if (isItemFrame && entityDynamic.get("ItemRotation").asNumber().result().isPresent()) {
                    entityDynamic = entityDynamic.set("ItemRotation", entityDynamic.createByte((byte)(entityDynamic.get("ItemRotation").asByte((byte)0) * 2)));
                }
            } else {
                j2 = entityDynamic.get("Dir").asByte((byte)0) % a.length;
                entityDynamic = entityDynamic.remove("Dir");
            }
            entityDynamic = entityDynamic.set("Facing", entityDynamic.createByte((byte)j2));
        }
        return entityDynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getChoiceType(DataConverterTypes.B, "Painting");
        OpticFinder opticFinder = DSL.namedChoice((String)"Painting", (Type)type);
        Type type2 = this.getInputSchema().getChoiceType(DataConverterTypes.B, "ItemFrame");
        OpticFinder opticFinder2 = DSL.namedChoice((String)"ItemFrame", (Type)type2);
        Type type3 = this.getInputSchema().getType(DataConverterTypes.B);
        TypeRewriteRule typeRewriteRule = this.fixTypeEverywhereTyped("EntityPaintingFix", type3, entityTyped -> entityTyped.updateTyped(opticFinder, type, paintingTyped -> paintingTyped.update(DSL.remainderFinder(), paintingDynamic -> this.a((Dynamic<?>)((Object)((Object)((Object)paintingDynamic))), true, false))));
        TypeRewriteRule typeRewriteRule2 = this.fixTypeEverywhereTyped("EntityItemFrameFix", type3, entityTyped -> entityTyped.updateTyped(opticFinder2, type2, itemFrameTyped -> itemFrameTyped.update(DSL.remainderFinder(), itemFrameDynamic -> this.a((Dynamic<?>)((Object)((Object)((Object)itemFrameDynamic))), false, true))));
        return TypeRewriteRule.seq((TypeRewriteRule)typeRewriteRule, (TypeRewriteRule)typeRewriteRule2);
    }
}

