/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterPOI
extends DataFix {
    public DataConverterPOI(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = DSL.named((String)DataConverterTypes.q.typeName(), (Type)DSL.remainderType());
        if (!Objects.equals(type, this.getInputSchema().getType(DataConverterTypes.q))) {
            throw new IllegalStateException("Poi type is not what was expected.");
        }
        return this.fixTypeEverywhere("POI reorganization", type, dynamicOps -> pair -> pair.mapSecond(DataConverterPOI::a));
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic) {
        HashMap map = Maps.newHashMap();
        for (int i2 = 0; i2 < 16; ++i2) {
            String string = String.valueOf(i2);
            Optional optional = dynamic.get(string).result();
            if (!optional.isPresent()) continue;
            Dynamic dynamic2 = (Dynamic)((Object)optional.get());
            Dynamic dynamic3 = dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("Records")), (Object)((Object)dynamic2)));
            map.put(dynamic.createInt(i2), dynamic3);
            dynamic = dynamic.remove(string);
        }
        return dynamic.set("Sections", dynamic.createMap(map));
    }
}

