/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterProtoChunk
extends DataFix {
    private static final int a = 16;

    public DataConverterProtoChunk(Schema outputSchema, boolean changestype) {
        super(outputSchema, changestype);
    }

    public TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ChunkToProtoChunkFix", this.getInputSchema().getType(DataConverterTypes.c), this.getOutputSchema().getType(DataConverterTypes.c), chunkDynamic -> chunkDynamic.update("Level", DataConverterProtoChunk::a));
    }

    private static <T> Dynamic<T> a(Dynamic<T> levelDynamic) {
        String string3;
        boolean bl2;
        boolean bl = levelDynamic.get("TerrainPopulated").asBoolean(false);
        boolean bl3 = bl2 = levelDynamic.get("LightPopulated").asNumber().result().isEmpty() || levelDynamic.get("LightPopulated").asBoolean(false);
        if (bl) {
            if (bl2) {
                String string = "mobs_spawned";
            } else {
                String string2 = "decorated";
            }
        } else {
            string3 = "carved";
        }
        return DataConverterProtoChunk.c(DataConverterProtoChunk.b(levelDynamic)).set("Status", levelDynamic.createString(string3)).set("hasLegacyStructureData", levelDynamic.createBoolean(true));
    }

    private static <T> Dynamic<T> b(Dynamic<T> levelDynamic) {
        return levelDynamic.update("Biomes", biomesDynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse(biomesDynamic.asByteBufferOpt().result().map(biomes -> {
            int[] is = new int[256];
            for (int i2 = 0; i2 < is.length; ++i2) {
                if (i2 >= biomes.capacity()) continue;
                is[i2] = biomes.get(i2) & 0xFF;
            }
            return levelDynamic.createIntList(Arrays.stream(is));
        }), (Object)biomesDynamic))));
    }

    private static <T> Dynamic<T> c(Dynamic<T> levelDynamic) {
        return (Dynamic)((Object)DataFixUtils.orElse(levelDynamic.get("TileTicks").asStreamOpt().result().map(tileTicksDynamic -> {
            List list = IntStream.range(0, 16).mapToObj(sectionY -> new ShortArrayList()).collect(Collectors.toList());
            tileTicksDynamic.forEach(tickTag -> {
                int i2 = tickTag.get("x").asInt(0);
                int j2 = tickTag.get("y").asInt(0);
                int k2 = tickTag.get("z").asInt(0);
                short s2 = DataConverterProtoChunk.a(i2, j2, k2);
                ((ShortList)list.get(j2 >> 4)).add(s2);
            });
            return levelDynamic.remove("TileTicks").set("ToBeTicked", levelDynamic.createList(list.stream().map(section -> levelDynamic.createList(section.intStream().mapToObj(packedLocalPos -> levelDynamic.createShort((short)packedLocalPos))))));
        }), levelDynamic));
    }

    private static short a(int x2, int y2, int z2) {
        return (short)(x2 & 0xF | (y2 & 0xF) << 4 | (z2 & 0xF) << 8);
    }
}

