/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterEntityName;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterZombieType
extends DataConverterEntityName {
    private final Supplier<Type<?>> b = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(DataConverterTypes.B, "ZombieVillager"));

    public DataConverterZombieType(Schema outputSchema) {
        super("EntityZombieSplitFix", outputSchema, true);
    }

    @Override
    @Override
    protected Pair<String, Typed<?>> a(String choice, Typed<?> entityTyped) {
        Typed<?> typed3;
        String string3;
        if (!choice.equals("Zombie")) {
            return Pair.of((Object)choice, entityTyped);
        }
        Dynamic dynamic = (Dynamic)((Object)entityTyped.getOptional(DSL.remainderFinder()).orElseThrow());
        int i2 = dynamic.get("ZombieType").asInt(0);
        switch (i2) {
            default: {
                String string = "Zombie";
                Typed<?> typed = entityTyped;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String string2 = "ZombieVillager";
                Typed<?> typed2 = this.a(entityTyped, i2 - 1);
                break;
            }
            case 6: {
                string3 = "Husk";
                typed3 = entityTyped;
            }
        }
        return Pair.of((Object)string3, (Object)typed3.update(DSL.remainderFinder(), entityDynamic -> entityDynamic.remove("ZombieType")));
    }

    private Typed<?> a(Typed<?> entityTyped, int variant) {
        return SystemUtils.a(entityTyped, this.b.get(), zombieVillagerDynamic -> zombieVillagerDynamic.set("Profession", zombieVillagerDynamic.createInt(variant)));
    }
}

