/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class EffectDurationFix
extends DataFix {
    private static final Set<String> a = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public EffectDurationFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        Type type = this.getInputSchema().getType(DataConverterTypes.t);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.D.typeName(), DataConverterSchemaNamed.a()));
        OpticFinder opticFinder2 = type.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EffectDurationEntity", schema.getType(DataConverterTypes.B), entityTyped -> entityTyped.update(DSL.remainderFinder(), this::c)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("EffectDurationPlayer", schema.getType(DataConverterTypes.b), playerTyped -> playerTyped.update(DSL.remainderFinder(), this::c)), this.fixTypeEverywhereTyped("EffectDurationItem", type, itemStackTyped -> {
            Optional optional2;
            Optional optional = itemStackTyped.getOptional(opticFinder);
            if (optional.filter(a::contains).isPresent() && (optional2 = itemStackTyped.getOptionalTyped(opticFinder2)).isPresent()) {
                Dynamic dynamic = (Dynamic)((Object)((Object)((Typed)optional2.get()).get(DSL.remainderFinder())));
                Typed typed = ((Typed)optional2.get()).set(DSL.remainderFinder(), dynamic.update("CustomPotionEffects", this::b));
                return itemStackTyped.set(opticFinder2, typed);
            }
            return itemStackTyped;
        })});
    }

    private Dynamic<?> a(Dynamic<?> effectDynamic) {
        return effectDynamic.update("FactorCalculationData", factorCalculationDataDynamic -> {
            int i2 = factorCalculationDataDynamic.get("effect_changed_timestamp").asInt(-1);
            factorCalculationDataDynamic = factorCalculationDataDynamic.remove("effect_changed_timestamp");
            int j2 = effectDynamic.get("Duration").asInt(-1);
            int k2 = i2 - j2;
            return factorCalculationDataDynamic.set("ticks_active", factorCalculationDataDynamic.createInt(k2));
        });
    }

    private Dynamic<?> b(Dynamic<?> effectsDynamic) {
        return effectsDynamic.createList(effectsDynamic.asStream().map(this::a));
    }

    private Dynamic<?> c(Dynamic<?> entityDynamic) {
        entityDynamic = entityDynamic.update("Effects", this::b);
        entityDynamic = entityDynamic.update("ActiveEffects", this::b);
        entityDynamic = entityDynamic.update("CustomPotionEffects", this::b);
        return entityDynamic;
    }
}

