/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Splitter;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class ItemStackComponentizationFix
extends DataFix {
    private static final int a = 1;
    private static final int b = 2;
    private static final int c = 4;
    private static final int d = 8;
    private static final int e = 16;
    private static final int f = 32;
    private static final int g = 64;
    private static final int h = 128;
    private static final Set<String> i = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");
    private static final Set<String> j = Set.of("minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:cod_bucket", "minecraft:tropical_fish_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket");
    private static final List<String> k = List.of("NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag");
    private static final Set<String> l = Set.of("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting");
    private static final Splitter m = Splitter.on((char)',');

    public ItemStackComponentizationFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    private static void a(a data, Dynamic<?> dynamic3) {
        int i2 = data.a("HideFlags").asInt(0);
        data.a("Damage", "minecraft:damage", dynamic3.createInt(0));
        data.a("RepairCost", "minecraft:repair_cost", dynamic3.createInt(0));
        data.a("CustomModelData", "minecraft:custom_model_data");
        data.a("BlockStateTag").result().ifPresent(blockStateTagDynamic -> data.a("minecraft:block_state", ItemStackComponentizationFix.b(blockStateTagDynamic)));
        data.a("EntityTag", "minecraft:entity_data");
        data.a("BlockEntityTag", false, blockEntityTagDynamic -> {
            String string = DataConverterSchemaNamed.a(blockEntityTagDynamic.get("id").asString(""));
            Dynamic dynamic = (blockEntityTagDynamic = ItemStackComponentizationFix.a(data, blockEntityTagDynamic, string)).remove("id");
            if (dynamic.equals((Object)blockEntityTagDynamic.emptyMap())) {
                return dynamic;
            }
            return blockEntityTagDynamic;
        });
        data.a("BlockEntityTag", "minecraft:block_entity_data");
        if (data.a("Unbreakable").asBoolean(false)) {
            Dynamic dynamic22 = dynamic3.emptyMap();
            if ((i2 & 4) != 0) {
                dynamic22 = dynamic22.set("show_in_tooltip", dynamic3.createBoolean(false));
            }
            data.a("minecraft:unbreakable", dynamic22);
        }
        ItemStackComponentizationFix.a(data, dynamic3, "Enchantments", "minecraft:enchantments", (i2 & 1) != 0);
        if (data.b("minecraft:enchanted_book")) {
            ItemStackComponentizationFix.a(data, dynamic3, "StoredEnchantments", "minecraft:stored_enchantments", (i2 & 0x20) != 0);
        }
        data.a("display", false, displayDynamic -> ItemStackComponentizationFix.a(data, displayDynamic, i2));
        ItemStackComponentizationFix.b(data, dynamic3, i2);
        ItemStackComponentizationFix.c(data, dynamic3, i2);
        Optional optional = data.a("Trim").result();
        if (optional.isPresent()) {
            Dynamic dynamic32 = (Dynamic)((Object)optional.get());
            if ((i2 & 0x80) != 0) {
                dynamic32 = dynamic32.set("show_in_tooltip", dynamic32.createBoolean(false));
            }
            data.a("minecraft:trim", dynamic32);
        }
        if ((i2 & 0x20) != 0) {
            data.a("minecraft:hide_additional_tooltip", dynamic3.emptyMap());
        }
        if (data.b("minecraft:crossbow")) {
            data.a("Charged");
            data.a("ChargedProjectiles", "minecraft:charged_projectiles", dynamic3.createList(Stream.empty()));
        }
        if (data.b("minecraft:bundle")) {
            data.a("Items", "minecraft:bundle_contents", dynamic3.createList(Stream.empty()));
        }
        if (data.b("minecraft:filled_map")) {
            data.a("map", "minecraft:map_id");
            Map<Dynamic, Dynamic> map = data.a("Decorations").asStream().map(ItemStackComponentizationFix::e).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (dynamic, dynamic2) -> dynamic));
            if (!map.isEmpty()) {
                data.a("minecraft:map_decorations", dynamic3.createMap(map));
            }
        }
        if (data.a(i)) {
            ItemStackComponentizationFix.b(data, dynamic3);
        }
        if (data.b("minecraft:writable_book")) {
            ItemStackComponentizationFix.c(data, dynamic3);
        }
        if (data.b("minecraft:written_book")) {
            ItemStackComponentizationFix.d(data, dynamic3);
        }
        if (data.b("minecraft:suspicious_stew")) {
            data.a("effects", "minecraft:suspicious_stew_effects");
        }
        if (data.b("minecraft:debug_stick")) {
            data.a("DebugProperty", "minecraft:debug_stick_state");
        }
        if (data.a(j)) {
            ItemStackComponentizationFix.f(data, dynamic3);
        }
        if (data.b("minecraft:goat_horn")) {
            data.a("instrument", "minecraft:instrument");
        }
        if (data.b("minecraft:knowledge_book")) {
            data.a("Recipes", "minecraft:recipes");
        }
        if (data.b("minecraft:compass")) {
            ItemStackComponentizationFix.g(data, dynamic3);
        }
        if (data.b("minecraft:firework_rocket")) {
            ItemStackComponentizationFix.b(data);
        }
        if (data.b("minecraft:firework_star")) {
            ItemStackComponentizationFix.a(data);
        }
        if (data.b("minecraft:player_head")) {
            data.a("SkullOwner").result().ifPresent(skullOwnerDynamic -> data.a("minecraft:profile", ItemStackComponentizationFix.a(skullOwnerDynamic)));
        }
    }

    private static Dynamic<?> b(Dynamic<?> dynamic) {
        return (Dynamic)((Object)DataFixUtils.orElse(dynamic.asMapOpt().result().map(stream -> stream.collect(Collectors.toMap(Pair::getFirst, pair -> {
            Optional optional;
            String string = ((Dynamic)((Object)((Object)((Object)pair.getFirst())))).asString("");
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)pair.getSecond())));
            if (l.contains(string) && (optional = dynamic.asBoolean().result()).isPresent()) {
                return dynamic.createString(String.valueOf(optional.get()));
            }
            Optional optional2 = dynamic.asNumber().result();
            if (optional2.isPresent()) {
                return dynamic.createString(((Number)optional2.get()).toString());
            }
            return dynamic;
        }))).map(arg_0 -> dynamic.createMap(arg_0)), dynamic));
    }

    private static Dynamic<?> a(a data, Dynamic<?> dynamic, int hideFlags) {
        Optional optional2;
        boolean bl;
        data.a("minecraft:custom_name", dynamic.get("Name"));
        data.a("minecraft:lore", dynamic.get("Lore"));
        Optional<Integer> optional = dynamic.get("color").asNumber().result().map(Number::intValue);
        boolean bl2 = bl = (hideFlags & 0x40) != 0;
        if (optional.isPresent() || bl) {
            Dynamic dynamic2 = dynamic.emptyMap().set("rgb", dynamic.createInt(optional.orElse(10511680)));
            if (bl) {
                dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.a("minecraft:dyed_color", dynamic2);
        }
        if ((optional2 = dynamic.get("LocName").asString().result()).isPresent()) {
            data.a("minecraft:item_name", ComponentDataFixUtils.b(dynamic.getOps(), (String)optional2.get()));
        }
        if (data.b("minecraft:filled_map")) {
            data.a("minecraft:map_color", dynamic.get("MapColor"));
            dynamic = dynamic.remove("MapColor");
        }
        return dynamic.remove("Name").remove("Lore").remove("color").remove("LocName");
    }

    private static <T> Dynamic<T> a(a data, Dynamic<T> dynamic, String blockEntityId) {
        data.a("minecraft:lock", dynamic.get("Lock"));
        dynamic = dynamic.remove("Lock");
        Optional optional = dynamic.get("LootTable").result();
        if (optional.isPresent()) {
            Dynamic dynamic2 = dynamic.emptyMap().set("loot_table", (Dynamic)((Object)optional.get()));
            long l2 = dynamic.get("LootTableSeed").asLong(0L);
            if (l2 != 0L) {
                dynamic2 = dynamic2.set("seed", dynamic.createLong(l2));
            }
            data.a("minecraft:container_loot", dynamic2);
            dynamic = dynamic.remove("LootTable").remove("LootTableSeed");
        }
        return switch (blockEntityId) {
            case "minecraft:skull" -> {
                data.a("minecraft:note_block_sound", dynamic.get("note_block_sound"));
                yield dynamic.remove("note_block_sound");
            }
            case "minecraft:decorated_pot" -> {
                data.a("minecraft:pot_decorations", dynamic.get("sherds"));
                Optional optional2 = dynamic.get("item").result();
                if (optional2.isPresent()) {
                    data.a("minecraft:container", dynamic.createList(Stream.of(dynamic.emptyMap().set("slot", dynamic.createInt(0)).set("item", (Dynamic)((Object)optional2.get())))));
                }
                yield dynamic.remove("sherds").remove("item");
            }
            case "minecraft:banner" -> {
                data.a("minecraft:banner_patterns", dynamic.get("patterns"));
                Optional optional3 = dynamic.get("Base").asNumber().result();
                if (optional3.isPresent()) {
                    data.a("minecraft:base_color", dynamic.createString(BannerPatternFormatFix.a(((Number)optional3.get()).intValue())));
                }
                yield dynamic.remove("patterns").remove("Base");
            }
            case "minecraft:shulker_box", "minecraft:chest", "minecraft:trapped_chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:brewing_stand", "minecraft:hopper", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:chiseled_bookshelf", "minecraft:crafter" -> {
                List list = dynamic.get("Items").asList(itemsDynamic -> itemsDynamic.emptyMap().set("slot", itemsDynamic.createInt(itemsDynamic.get("Slot").asByte((byte)0) & 0xFF)).set("item", itemsDynamic.remove("Slot")));
                if (!list.isEmpty()) {
                    data.a("minecraft:container", dynamic.createList(list.stream()));
                }
                yield dynamic.remove("Items");
            }
            case "minecraft:beehive" -> {
                data.a("minecraft:bees", dynamic.get("bees"));
                yield dynamic.remove("bees");
            }
            default -> dynamic;
        };
    }

    private static void a(a data, Dynamic<?> dynamic, String nbtKey, String componentId, boolean hideInTooltip) {
        OptionalDynamic<?> optionalDynamic = data.a(nbtKey);
        List list = optionalDynamic.asList(Function.identity()).stream().flatMap(enchantmentsDynamic -> ItemStackComponentizationFix.c(enchantmentsDynamic).stream()).toList();
        if (!list.isEmpty() || hideInTooltip) {
            Dynamic dynamic2 = dynamic.emptyMap();
            Dynamic dynamic3 = dynamic.emptyMap();
            for (Pair pair : list) {
                dynamic3 = dynamic3.set((String)pair.getFirst(), dynamic.createInt((Integer)pair.getSecond()));
            }
            dynamic2 = dynamic2.set("levels", dynamic3);
            if (hideInTooltip) {
                dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.a(componentId, dynamic2);
        }
        if (optionalDynamic.result().isPresent() && list.isEmpty()) {
            data.a("minecraft:enchantment_glint_override", dynamic.createBoolean(true));
        }
    }

    private static Optional<Pair<String, Integer>> c(Dynamic<?> dynamic) {
        return dynamic.get("id").asString().apply2stable((enchantmentId, level) -> Pair.of((Object)enchantmentId, (Object)MathHelper.a(level.intValue(), 0, 255)), dynamic.get("lvl").asNumber()).result();
    }

    private static void b(a data, Dynamic<?> dynamic, int hideFlags) {
        ItemStackComponentizationFix.b(data, dynamic, "CanDestroy", "minecraft:can_break", (hideFlags & 8) != 0);
        ItemStackComponentizationFix.b(data, dynamic, "CanPlaceOn", "minecraft:can_place_on", (hideFlags & 0x10) != 0);
    }

    private static void b(a data, Dynamic<?> dynamic, String nbtKey, String componentId, boolean hideInTooltip) {
        Optional optional = data.a(nbtKey).result();
        if (optional.isEmpty()) {
            return;
        }
        Dynamic dynamic2 = dynamic.emptyMap().set("predicates", dynamic.createList(((Dynamic)((Object)optional.get())).asStream().map(predicatesDynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)predicatesDynamic.asString().map(string -> ItemStackComponentizationFix.a(predicatesDynamic, string)).result(), (Object)predicatesDynamic))))));
        if (hideInTooltip) {
            dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
        }
        data.a(componentId, dynamic2);
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, String listAsString) {
        int i2 = listAsString.indexOf(91);
        int j2 = listAsString.indexOf(123);
        int k2 = listAsString.length();
        if (i2 != -1) {
            k2 = i2;
        }
        if (j2 != -1) {
            k2 = Math.min(k2, j2);
        }
        String string = listAsString.substring(0, k2);
        Dynamic dynamic2 = dynamic.emptyMap().set("blocks", dynamic.createString(string.trim()));
        int l2 = listAsString.indexOf(93);
        if (i2 != -1 && l2 != -1) {
            Dynamic dynamic3 = dynamic.emptyMap();
            Iterable iterable = m.split((CharSequence)listAsString.substring(i2 + 1, l2));
            for (String string2 : iterable) {
                int m2 = string2.indexOf(61);
                if (m2 == -1) continue;
                String string3 = string2.substring(0, m2).trim();
                String string4 = string2.substring(m2 + 1).trim();
                dynamic3 = dynamic3.set(string3, dynamic.createString(string4));
            }
            dynamic2 = dynamic2.set("state", dynamic3);
        }
        int n2 = listAsString.indexOf(125);
        if (j2 != -1 && n2 != -1) {
            dynamic2 = dynamic2.set("nbt", dynamic.createString(listAsString.substring(j2, n2 + 1)));
        }
        return dynamic2;
    }

    private static void c(a data, Dynamic<?> dynamic, int hideFlags) {
        OptionalDynamic<?> optionalDynamic = data.a("AttributeModifiers");
        if (optionalDynamic.result().isEmpty()) {
            return;
        }
        boolean bl = (hideFlags & 2) != 0;
        List list = optionalDynamic.asList(ItemStackComponentizationFix::d);
        Dynamic dynamic2 = dynamic.emptyMap().set("modifiers", dynamic.createList(list.stream()));
        if (bl) {
            dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
        }
        data.a("minecraft:attribute_modifiers", dynamic2);
    }

    private static Dynamic<?> d(Dynamic<?> dynamic) {
        Dynamic<Object> dynamic2 = dynamic.emptyMap().set("name", dynamic.createString("")).set("amount", dynamic.createDouble(0.0)).set("operation", dynamic.createString("add_value"));
        dynamic2 = Dynamic.copyField(dynamic, "AttributeName", dynamic2, "type");
        dynamic2 = Dynamic.copyField(dynamic, "Slot", dynamic2, "slot");
        dynamic2 = Dynamic.copyField(dynamic, "UUID", dynamic2, "uuid");
        dynamic2 = Dynamic.copyField(dynamic, "Name", dynamic2, "name");
        dynamic2 = Dynamic.copyField(dynamic, "Amount", dynamic2, "amount");
        dynamic2 = Dynamic.copyAndFixField(dynamic, "Operation", dynamic2, "operation", operationDynamic -> operationDynamic.createString(switch (operationDynamic.asInt(0)) {
            default -> "add_value";
            case 1 -> "add_multiplied_base";
            case 2 -> "add_multiplied_total";
        }));
        return dynamic2;
    }

    private static Pair<Dynamic<?>, Dynamic<?>> e(Dynamic<?> dynamic) {
        Dynamic dynamic2 = (Dynamic)((Object)DataFixUtils.orElseGet((Optional)dynamic.get("id").result(), () -> dynamic.createString("")));
        Dynamic dynamic3 = dynamic.emptyMap().set("type", dynamic.createString(ItemStackComponentizationFix.a(dynamic.get("type").asInt(0)))).set("x", dynamic.createDouble(dynamic.get("x").asDouble(0.0))).set("z", dynamic.createDouble(dynamic.get("z").asDouble(0.0))).set("rotation", dynamic.createFloat((float)dynamic.get("rot").asDouble(0.0)));
        return Pair.of((Object)((Object)dynamic2), dynamic3);
    }

    private static String a(int index) {
        return switch (index) {
            default -> "player";
            case 1 -> "frame";
            case 2 -> "red_marker";
            case 3 -> "blue_marker";
            case 4 -> "target_x";
            case 5 -> "target_point";
            case 6 -> "player_off_map";
            case 7 -> "player_off_limits";
            case 8 -> "mansion";
            case 9 -> "monument";
            case 10 -> "banner_white";
            case 11 -> "banner_orange";
            case 12 -> "banner_magenta";
            case 13 -> "banner_light_blue";
            case 14 -> "banner_yellow";
            case 15 -> "banner_lime";
            case 16 -> "banner_pink";
            case 17 -> "banner_gray";
            case 18 -> "banner_light_gray";
            case 19 -> "banner_cyan";
            case 20 -> "banner_purple";
            case 21 -> "banner_blue";
            case 22 -> "banner_brown";
            case 23 -> "banner_green";
            case 24 -> "banner_red";
            case 25 -> "banner_black";
            case 26 -> "red_x";
            case 27 -> "village_desert";
            case 28 -> "village_plains";
            case 29 -> "village_savanna";
            case 30 -> "village_snowy";
            case 31 -> "village_taiga";
            case 32 -> "jungle_temple";
            case 33 -> "swamp_hut";
        };
    }

    private static void b(a data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = dynamic.emptyMap();
        Optional<String> optional = data.a("Potion").asString().result().filter(potionId -> !potionId.equals("minecraft:empty"));
        if (optional.isPresent()) {
            dynamic2 = dynamic2.set("potion", dynamic.createString(optional.get()));
        }
        dynamic2 = data.a("CustomPotionColor", dynamic2, "custom_color");
        if (!(dynamic2 = data.a("custom_potion_effects", dynamic2, "custom_effects")).equals((Object)dynamic.emptyMap())) {
            data.a("minecraft:potion_contents", dynamic2);
        }
    }

    private static void c(a data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = ItemStackComponentizationFix.e(data, dynamic);
        if (dynamic2 != null) {
            data.a("minecraft:writable_book_content", dynamic.emptyMap().set("pages", dynamic2));
        }
    }

    private static void d(a data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = ItemStackComponentizationFix.e(data, dynamic);
        String string = data.a("title").asString("");
        Optional optional = data.a("filtered_title").asString().result();
        Dynamic<Object> dynamic3 = dynamic.emptyMap();
        dynamic3 = dynamic3.set("title", ItemStackComponentizationFix.a(dynamic, string, optional));
        dynamic3 = data.a("author", dynamic3, "author");
        dynamic3 = data.a("resolved", dynamic3, "resolved");
        dynamic3 = data.a("generation", dynamic3, "generation");
        if (dynamic2 != null) {
            dynamic3 = dynamic3.set("pages", dynamic2);
        }
        data.a("minecraft:written_book_content", dynamic3);
    }

    @Nullable
    private static Dynamic<?> e(a data, Dynamic<?> dynamic) {
        List list = data.a("pages").asList(pagesDynamic -> pagesDynamic.asString(""));
        Map map = data.a("filtered_pages").asMap(filteredPagesKeyDynamic -> filteredPagesKeyDynamic.asString("0"), filteredPagesValueDynamic -> filteredPagesValueDynamic.asString(""));
        if (list.isEmpty()) {
            return null;
        }
        ArrayList list2 = new ArrayList(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            String string2 = (String)map.get(String.valueOf(i2));
            list2.add(ItemStackComponentizationFix.a(dynamic, string, Optional.ofNullable(string2)));
        }
        return dynamic.createList(list2.stream());
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, String unfiltered, Optional<String> filtered) {
        Dynamic dynamic2 = dynamic.emptyMap().set("raw", dynamic.createString(unfiltered));
        if (filtered.isPresent()) {
            dynamic2 = dynamic2.set("filtered", dynamic.createString(filtered.get()));
        }
        return dynamic2;
    }

    private static void f(a data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = dynamic.emptyMap();
        for (String string : k) {
            dynamic2 = data.a(string, dynamic2, string);
        }
        if (!dynamic2.equals((Object)dynamic.emptyMap())) {
            data.a("minecraft:bucket_entity_data", dynamic2);
        }
    }

    private static void g(a data, Dynamic<?> dynamic) {
        Optional optional = data.a("LodestonePos").result();
        Optional optional2 = data.a("LodestoneDimension").result();
        if (optional.isEmpty() && optional2.isEmpty()) {
            return;
        }
        boolean bl = data.a("LodestoneTracked").asBoolean(true);
        Dynamic dynamic2 = dynamic.emptyMap();
        if (optional.isPresent() && optional2.isPresent()) {
            dynamic2 = dynamic2.set("target", dynamic.emptyMap().set("pos", (Dynamic)((Object)optional.get())).set("dimension", (Dynamic)((Object)optional2.get())));
        }
        if (!bl) {
            dynamic2 = dynamic2.set("tracked", dynamic.createBoolean(false));
        }
        data.a("minecraft:lodestone_tracker", dynamic2);
    }

    private static void a(a data) {
        data.a("Explosion", true, explosionDynamic -> {
            data.a("minecraft:firework_explosion", ItemStackComponentizationFix.f(explosionDynamic));
            return explosionDynamic.remove("Type").remove("Colors").remove("FadeColors").remove("Trail").remove("Flicker");
        });
    }

    private static void b(a data) {
        data.a("Fireworks", true, fireworksDynamic -> {
            Stream<Dynamic> stream = fireworksDynamic.get("Explosions").asStream().map(ItemStackComponentizationFix::f);
            int i2 = fireworksDynamic.get("Flight").asInt(0);
            data.a("minecraft:fireworks", fireworksDynamic.emptyMap().set("explosions", fireworksDynamic.createList(stream)).set("flight_duration", fireworksDynamic.createByte((byte)i2)));
            return fireworksDynamic.remove("Explosions").remove("Flight");
        });
    }

    private static Dynamic<?> f(Dynamic<?> dynamic) {
        dynamic = dynamic.set("shape", dynamic.createString(switch (dynamic.get("Type").asInt(0)) {
            default -> "small_ball";
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
        })).remove("Type");
        dynamic = dynamic.renameField("Colors", "colors");
        dynamic = dynamic.renameField("FadeColors", "fade_colors");
        dynamic = dynamic.renameField("Trail", "has_trail");
        dynamic = dynamic.renameField("Flicker", "has_twinkle");
        return dynamic;
    }

    public static Dynamic<?> a(Dynamic<?> dynamic) {
        Optional optional = dynamic.asString().result();
        if (optional.isPresent()) {
            if (ItemStackComponentizationFix.a((String)optional.get())) {
                return dynamic.emptyMap().set("name", dynamic.createString((String)optional.get()));
            }
            return dynamic.emptyMap();
        }
        String string = dynamic.get("Name").asString("");
        Optional optional2 = dynamic.get("Id").result();
        Dynamic<?> dynamic2 = ItemStackComponentizationFix.a(dynamic.get("Properties"));
        Dynamic dynamic3 = dynamic.emptyMap();
        if (ItemStackComponentizationFix.a(string)) {
            dynamic3 = dynamic3.set("name", dynamic.createString(string));
        }
        if (optional2.isPresent()) {
            dynamic3 = dynamic3.set("id", (Dynamic)((Object)optional2.get()));
        }
        if (dynamic2 != null) {
            dynamic3 = dynamic3.set("properties", dynamic2);
        }
        return dynamic3;
    }

    private static boolean a(String username) {
        if (username.length() > 16) {
            return false;
        }
        return username.chars().filter(c2 -> c2 <= 32 || c2 >= 127).findAny().isEmpty();
    }

    @Nullable
    private static Dynamic<?> a(OptionalDynamic<?> propertiesDynamic) {
        Map map = propertiesDynamic.asMap(dynamic -> dynamic.asString(""), dynamic2 -> dynamic2.asList(dynamic -> {
            String string = dynamic.get("Value").asString("");
            Optional optional = dynamic.get("Signature").asString().result();
            return Pair.of((Object)string, (Object)optional);
        }));
        if (map.isEmpty()) {
            return null;
        }
        return propertiesDynamic.createList(map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(pair -> {
            Dynamic dynamic = propertiesDynamic.emptyMap().set("name", propertiesDynamic.createString((String)entry.getKey())).set("value", propertiesDynamic.createString((String)pair.getFirst()));
            Optional optional = (Optional)pair.getSecond();
            if (optional.isPresent()) {
                return dynamic.set("signature", propertiesDynamic.createString((String)optional.get()));
            }
            return dynamic;
        })));
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ItemStack componentization", this.getInputSchema().getType(DataConverterTypes.t), this.getOutputSchema().getType(DataConverterTypes.t), dynamic -> {
            Optional<Dynamic> optional = net.minecraft.util.datafix.fixes.ItemStackComponentizationFix$a.a(dynamic).map(data -> {
                ItemStackComponentizationFix.a(data, data.e);
                return data.a();
            });
            return (Dynamic)((Object)((Object)DataFixUtils.orElse(optional, (Object)dynamic)));
        });
    }

    static class a {
        private final String a;
        private final int b;
        private Dynamic<?> c;
        private final Dynamic<?> d;
        Dynamic<?> e;

        private a(String itemId, int count, Dynamic<?> dynamic) {
            this.a = DataConverterSchemaNamed.a(itemId);
            this.b = count;
            this.c = dynamic.emptyMap();
            this.e = dynamic.get("tag").orElseEmptyMap();
            this.d = dynamic.remove("tag");
        }

        public static Optional<a> a(Dynamic<?> dynamic) {
            return dynamic.get("id").asString().apply2stable((itemId, count) -> new a((String)itemId, count.intValue(), dynamic.remove("id").remove("Count")), dynamic.get("Count").asNumber()).result();
        }

        public OptionalDynamic<?> a(String key) {
            OptionalDynamic<?> optionalDynamic = this.e.get(key);
            this.e = this.e.remove(key);
            return optionalDynamic;
        }

        public void a(String key, Dynamic<?> value) {
            this.c = this.c.set(key, value);
        }

        public void a(String key, OptionalDynamic<?> optionalValue) {
            optionalValue.result().ifPresent(value -> {
                this.c = this.c.set(key, (Dynamic<?>)((Object)value));
            });
        }

        public Dynamic<?> a(String nbtKey, Dynamic<?> components, String componentId) {
            Optional optional = this.a(nbtKey).result();
            if (optional.isPresent()) {
                return components.set(componentId, (Dynamic)((Object)optional.get()));
            }
            return components;
        }

        public void a(String nbtKey, String componentId, Dynamic<?> defaultValue) {
            Optional optional = this.a(nbtKey).result();
            if (optional.isPresent() && !((Dynamic)((Object)optional.get())).equals(defaultValue)) {
                this.a(componentId, (Dynamic)((Object)optional.get()));
            }
        }

        public void a(String nbtKey, String componentId) {
            this.a(nbtKey).result().ifPresent(nbt -> this.a(componentId, (Dynamic<?>)((Object)nbt)));
        }

        public void a(String nbtKey, boolean removeIfEmpty, UnaryOperator<Dynamic<?>> fixer) {
            OptionalDynamic<?> optionalDynamic = this.e.get(nbtKey);
            if (removeIfEmpty && optionalDynamic.result().isEmpty()) {
                return;
            }
            Dynamic dynamic = optionalDynamic.orElseEmptyMap();
            this.e = (dynamic = (Dynamic)((Object)fixer.apply(dynamic))).equals((Object)dynamic.emptyMap()) ? this.e.remove(nbtKey) : this.e.set(nbtKey, dynamic);
        }

        public Dynamic<?> a() {
            Dynamic dynamic = this.e.emptyMap().set("id", this.e.createString(this.a)).set("count", this.e.createInt(this.b));
            if (!this.e.equals((Object)this.e.emptyMap())) {
                this.c = this.c.set("minecraft:custom_data", this.e);
            }
            if (!this.c.equals((Object)this.e.emptyMap())) {
                dynamic = dynamic.set("components", this.c);
            }
            return net.minecraft.util.datafix.fixes.ItemStackComponentizationFix$a.a(dynamic, this.d);
        }

        private static <T> Dynamic<T> a(Dynamic<T> data, Dynamic<?> leftoverNbt) {
            DynamicOps dynamicOps = data.getOps();
            return dynamicOps.getMap(data.getValue()).flatMap(mapLike -> dynamicOps.mergeToMap(leftoverNbt.convert(dynamicOps).getValue(), mapLike)).map(object -> new Dynamic<Object>(dynamicOps, object)).result().orElse(data);
        }

        public boolean b(String itemId) {
            return this.a.equals(itemId);
        }

        public boolean a(Set<String> itemIds) {
            return itemIds.contains(this.a);
        }

        public boolean c(String componentId) {
            return this.c.get(componentId).result().isPresent();
        }
    }
}

