/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class ItemStackTagFix
extends DataFix {
    private final String a;
    private final Predicate<String> b;

    public ItemStackTagFix(Schema outputSchema, String name, Predicate<String> itemIdPredicate) {
        super(outputSchema, false);
        this.a = name;
        this.b = itemIdPredicate;
    }

    public final TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.t);
        return this.fixTypeEverywhereTyped(this.a, type, ItemStackTagFix.a(type, this.b, this::a));
    }

    public static UnaryOperator<Typed<?>> a(Type<?> itemStackType, Predicate<String> itemIdPredicate, UnaryOperator<Dynamic<?>> nbtFixer) {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)DataConverterTypes.D.typeName(), DataConverterSchemaNamed.a()));
        OpticFinder opticFinder2 = itemStackType.findField("tag");
        return itemStackTyped -> {
            Optional optional = itemStackTyped.getOptional(opticFinder);
            if (optional.isPresent() && itemIdPredicate.test((String)((Pair)optional.get()).getSecond())) {
                return itemStackTyped.updateTyped(opticFinder2, tag -> tag.update(DSL.remainderFinder(), (Function)nbtFixer));
            }
            return itemStackTyped;
        };
    }

    protected abstract <T> Dynamic<T> a(Dynamic<T> var1);
}

