/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class ProjectileStoredWeaponFix
extends DataFix {
    public ProjectileStoredWeaponFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.B);
        Type type2 = this.getOutputSchema().getType(DataConverterTypes.B);
        return this.fixTypeEverywhereTyped("Fix Arrow stored weapon", type, type2, ExtraDataFixUtils.a(this.a("minecraft:arrow"), this.a("minecraft:spectral_arrow")));
    }

    private Function<Typed<?>, Typed<?>> a(String entityId) {
        Type type = this.getInputSchema().getChoiceType(DataConverterTypes.B, entityId);
        Type type2 = this.getOutputSchema().getChoiceType(DataConverterTypes.B, entityId);
        return ProjectileStoredWeaponFix.a(entityId, type, type2);
    }

    private static <T> Function<Typed<?>, Typed<?>> a(String name, Type<?> type, Type<T> type2) {
        OpticFinder opticFinder = DSL.namedChoice((String)name, type);
        return typed2 -> typed2.updateTyped(opticFinder, type2, typed -> SystemUtils.a(typed, type2, UnaryOperator.identity()));
    }
}

